/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema register response")
public class RegisterSchemaResponse {
    private int id;
    private Integer version;
    private String schemaType;
    private List<SchemaReference> references = null;
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    private String schema;

    public RegisterSchemaResponse() {
    }

    public RegisterSchemaResponse(int id) {
        this.id = id;
    }

    public RegisterSchemaResponse(Schema schema) {
        this.version = schema.getVersion() != null && schema.getVersion() > 0 ? schema.getVersion() : null;
        this.id = schema.getId();
        this.schemaType = schema.getSchemaType();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
        this.schema = schema.getSchema();
    }

    public static RegisterSchemaResponse fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, RegisterSchemaResponse.class);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Globally unique identifier of the schema", example="100001")
    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(int id) {
        this.id = id;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Version number")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema definition string")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterSchemaResponse that = (RegisterSchemaResponse)o;
        return Objects.equals(this.version, that.version) && this.id == that.id && Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.references, this.metadata, this.ruleSet, this.version, this.id, this.schema);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        if (this.version != null) {
            buf.append("version=").append(this.version).append(", ");
        }
        buf.append("id=").append(this.id).append(", ");
        buf.append("schemaType=").append(this.schemaType).append(", ");
        buf.append("references=").append(this.references).append(", ");
        buf.append("metadata=").append(this.metadata).append(", ");
        buf.append("ruleSet=").append(this.ruleSet).append(", ");
        buf.append("schema=").append(this.schema).append("}");
        return buf.toString();
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }
}

