/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.models.InternalDataLakeFileOpenInputStreamResult;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeFileOpenInputStreamResult;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.azure.storage.file.datalake.models.FileExpirationOffset;
import com.azure.storage.file.datalake.models.FileQueryResponse;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.FileReadResponse;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.options.DataLakeFileAppendOptions;
import com.azure.storage.file.datalake.options.DataLakeFileFlushOptions;
import com.azure.storage.file.datalake.options.DataLakeFileInputStreamOptions;
import com.azure.storage.file.datalake.options.DataLakeFileOutputStreamOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.azure.storage.file.datalake.options.FileParallelUploadOptions;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import com.azure.storage.file.datalake.options.FileScheduleDeletionOptions;
import com.azure.storage.file.datalake.options.ReadToFileOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakePathClientBuilder.class)
public class DataLakeFileClient
extends DataLakePathClient {
    private static final long MAX_APPEND_FILE_BYTES = 0xFA000000L;
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeFileClient.class);
    private final DataLakeFileAsyncClient dataLakeFileAsyncClient;

    DataLakeFileClient(DataLakeFileAsyncClient fileAsyncClient, BlockBlobClient blockBlobClient, HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String fileName, AzureSasCredential sasToken, CpkInfo customerProvidedKey, boolean isTokenCredentialAuthenticated) {
        super(fileAsyncClient.getPathAsyncClient(fileSystemName, fileName), blockBlobClient, pipeline, url, serviceVersion, accountName, fileSystemName, fileName, PathResourceType.FILE, sasToken, customerProvidedKey, isTokenCredentialAuthenticated);
        this.dataLakeFileAsyncClient = fileAsyncClient;
    }

    DataLakeFileClient(DataLakePathClient dataLakePathClient) {
        super(dataLakePathClient.dataLakePathAsyncClient, dataLakePathClient.getBlockBlobClient(), dataLakePathClient.getHttpPipeline(), dataLakePathClient.getAccountUrl(), dataLakePathClient.getServiceVersion(), dataLakePathClient.getAccountName(), dataLakePathClient.getFileSystemName(), Utility.urlEncode(dataLakePathClient.pathName), PathResourceType.FILE, dataLakePathClient.getSasToken(), dataLakePathClient.getCpkInfo(), dataLakePathClient.isTokenCredentialAuthenticated());
        this.dataLakeFileAsyncClient = new DataLakeFileAsyncClient(dataLakePathClient.dataLakePathAsyncClient);
    }

    public String getFileUrl() {
        return this.getPathUrl();
    }

    public String getFilePath() {
        return this.getObjectPath();
    }

    public String getFileName() {
        return this.getObjectName();
    }

    @Override
    public DataLakeFileClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new DataLakeFileClient(this.dataLakeFileAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.blockBlobClient.getCustomerProvidedKeyClient(Transforms.toBlobCustomerProvidedKey(customerProvidedKey)), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath(), this.getSasToken(), finalCustomerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return super.deleteWithResponse(null, requestConditions, timeout, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return super.deleteIfExistsWithResponse(options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(InputStream data, long length) {
        return this.upload(data, length, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(BinaryData data) {
        return this.upload(data, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(InputStream data, long length, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.uploadWithResponse(new FileParallelUploadOptions(data, length).setRequestConditions(requestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo upload(BinaryData data, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.uploadWithResponse(new FileParallelUploadOptions(data).setRequestConditions(requestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> uploadWithResponse(FileParallelUploadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options);
        Mono<Response<PathInfo>> upload = this.dataLakeFileAsyncClient.uploadWithResponse(options).contextWrite(FluxUtil.toReactorContext(context));
        try {
            return StorageImplUtils.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, boolean overwrite) {
        DataLakeRequestConditions requestConditions = null;
        if (!overwrite) {
            if (UploadUtils.shouldUploadInChunks(filePath, 0x6400000L, LOGGER) && this.exists().booleanValue()) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        this.uploadFromFile(filePath, null, null, null, requestConditions, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout) {
        Mono<Void> upload = this.dataLakeFileAsyncClient.uploadFromFile(filePath, parallelTransferOptions, headers, metadata, requestConditions);
        try {
            StorageImplUtils.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> uploadFromFileWithResponse(String filePath, ParallelTransferOptions parallelTransferOptions, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<PathInfo>> upload = this.dataLakeFileAsyncClient.uploadFromFileWithResponse(filePath, parallelTransferOptions, headers, metadata, requestConditions).contextWrite(FluxUtil.toReactorContext(context));
        try {
            return StorageImplUtils.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(InputStream data, long fileOffset, long length) {
        this.appendWithResponse(data, fileOffset, length, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(BinaryData data, long fileOffset) {
        this.appendWithResponse(data, fileOffset, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(InputStream data, long fileOffset, long length, byte[] contentMd5, String leaseId, Duration timeout, Context context) {
        DataLakeFileAppendOptions appendOptions = new DataLakeFileAppendOptions().setLeaseId(leaseId).setContentHash(contentMd5).setFlush(null);
        return this.appendWithResponse(data, fileOffset, length, appendOptions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(InputStream data, long fileOffset, long length, DataLakeFileAppendOptions appendOptions, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux<ByteBuffer> fbb = Utility.convertStreamToByteBuffer(data, length, 0x400000, true);
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.appendWithResponse(fbb, fileOffset, length, appendOptions, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(BinaryData data, long fileOffset, byte[] contentMd5, String leaseId, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux<ByteBuffer> fluxData = data.toFluxByteBuffer();
        DataLakeFileAppendOptions appendOptions = new DataLakeFileAppendOptions().setLeaseId(leaseId).setContentHash(contentMd5).setFlush(null);
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.appendWithResponse(fluxData, fileOffset, (long)data.getLength(), appendOptions, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(BinaryData data, long fileOffset, DataLakeFileAppendOptions appendOptions, Duration timeout, Context context) {
        Objects.requireNonNull(data);
        Flux<ByteBuffer> fluxData = data.toFluxByteBuffer();
        Mono<Response<Void>> response = this.dataLakeFileAsyncClient.appendWithResponse(fluxData, fileOffset, (long)data.getLength(), appendOptions, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo flush(long position) {
        return this.flush(position, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathInfo flush(long position, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions = new DataLakeRequestConditions().setIfNoneMatch("*");
        }
        return this.flushWithResponse(position, false, false, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> flushWithResponse(long position, boolean retainUncommittedData, boolean close, PathHttpHeaders httpHeaders, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeFileFlushOptions flushOptions = new DataLakeFileFlushOptions().setUncommittedDataRetained(retainUncommittedData).setClose(close).setPathHttpHeaders(httpHeaders).setRequestConditions(requestConditions);
        return this.flushWithResponse(position, flushOptions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathInfo> flushWithResponse(long position, DataLakeFileFlushOptions flushOptions, Duration timeout, Context context) {
        Mono<Response<PathInfo>> response = this.dataLakeFileAsyncClient.flushWithResponse(position, flushOptions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public void read(OutputStream stream) {
        this.readWithResponse(stream, null, null, null, false, null, Context.NONE);
    }

    public FileReadResponse readWithResponse(OutputStream stream, FileRange range, DownloadRetryOptions options, DataLakeRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            BlobDownloadResponse response = this.blockBlobClient.downloadWithResponse(stream, Transforms.toBlobRange(range), Transforms.toBlobDownloadRetryOptions(options), Transforms.toBlobRequestConditions(requestConditions), getRangeContentMd5, timeout, context);
            return Transforms.toFileReadResponse(response);
        }, LOGGER);
    }

    public DataLakeFileOpenInputStreamResult openInputStream() {
        return this.openInputStream(null);
    }

    public DataLakeFileOpenInputStreamResult openInputStream(DataLakeFileInputStreamOptions options) {
        return this.openInputStream(options, Context.NONE);
    }

    public DataLakeFileOpenInputStreamResult openInputStream(DataLakeFileInputStreamOptions options, Context context) {
        context = BuilderHelper.addUpnHeader(() -> options == null ? null : options.isUserPrincipalName(), context);
        BlobInputStreamOptions convertedOptions = Transforms.toBlobInputStreamOptions(options);
        BlobInputStream inputStream = this.blockBlobClient.openInputStream(convertedOptions, context);
        return new InternalDataLakeFileOpenInputStreamResult(inputStream, Transforms.toPathProperties(inputStream.getProperties()));
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(null);
    }

    public OutputStream getOutputStream(DataLakeFileOutputStreamOptions options) {
        return this.getOutputStream(options, null);
    }

    public OutputStream getOutputStream(DataLakeFileOutputStreamOptions options, Context context) {
        BlockBlobOutputStreamOptions convertedOptions = Transforms.toBlockBlobOutputStreamOptions(options);
        return this.blockBlobClient.getBlobOutputStream(convertedOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties readToFile(String filePath) {
        return this.readToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties readToFile(ReadToFileOptions options) {
        return this.readToFileWithResponse(options, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathProperties readToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return this.readToFileWithResponse(filePath, null, null, null, null, false, openOptions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathProperties> readToFileWithResponse(String filePath, FileRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, DataLakeRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobProperties> response = this.blockBlobClient.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(Transforms.toBlobRange(range)).setParallelTransferOptions(parallelTransferOptions).setDownloadRetryOptions(Transforms.toBlobDownloadRetryOptions(downloadRetryOptions)).setRequestConditions(Transforms.toBlobRequestConditions(requestConditions)).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), timeout, context);
            return new SimpleResponse<PathProperties>(response, Transforms.toPathProperties(response.getValue(), response));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathProperties> readToFileWithResponse(ReadToFileOptions options, Duration timeout, Context context) {
        Context finalContext = context = BuilderHelper.addUpnHeader(() -> options == null ? null : options.isUserPrincipalName(), context);
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobProperties> response = this.blockBlobClient.downloadToFileWithResponse(new BlobDownloadToFileOptions(options.getFilePath()).setRange(Transforms.toBlobRange(options.getRange())).setParallelTransferOptions(options.getParallelTransferOptions()).setDownloadRetryOptions(Transforms.toBlobDownloadRetryOptions(options.getDownloadRetryOptions())).setRequestConditions(Transforms.toBlobRequestConditions(options.getDataLakeRequestConditions())).setRetrieveContentRangeMd5(options.isRangeGetContentMd5()).setOpenOptions(options.getOpenOptions()), timeout, finalContext);
            return new SimpleResponse<PathProperties>(response, Transforms.toPathProperties(response.getValue(), response));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient rename(String destinationFileSystem, String destinationPath) {
        return this.renameWithResponse(destinationFileSystem, destinationPath, null, null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout, Context context) {
        Response<DataLakePathClient> response = this.renameWithResponseWithTimeout(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, timeout, context);
        return new SimpleResponse<DataLakeFileClient>(response, new DataLakeFileClient(response.getValue()));
    }

    public InputStream openQueryInputStream(String expression) {
        return this.openQueryInputStreamWithResponse(new FileQueryOptions(expression)).getValue();
    }

    public Response<InputStream> openQueryInputStreamWithResponse(FileQueryOptions queryOptions) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blockBlobClient.openQueryInputStreamWithResponse(Transforms.toBlobQueryOptions(queryOptions)), LOGGER);
    }

    public void query(OutputStream stream, String expression) {
        this.queryWithResponse(new FileQueryOptions(expression, stream), null, Context.NONE);
    }

    public FileQueryResponse queryWithResponse(FileQueryOptions queryOptions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            BlobQueryResponse response = this.blockBlobClient.queryWithResponse(Transforms.toBlobQueryOptions(queryOptions), timeout, context);
            return Transforms.toFileQueryResponse(response);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void scheduleDeletion(FileScheduleDeletionOptions options) {
        this.scheduleDeletionWithResponse(options, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> scheduleDeletionWithResponse(FileScheduleDeletionOptions options, Duration timeout, Context context) {
        String expiresOn;
        PathExpiryOptions pathExpiryOptions;
        Context finalContext;
        Context context2 = finalContext = context == null ? Context.NONE : context;
        if (options != null && options.getExpiresOn() != null) {
            pathExpiryOptions = PathExpiryOptions.ABSOLUTE;
            expiresOn = new DateTimeRfc1123(options.getExpiresOn()).toString();
        } else if (options != null && options.getTimeToExpire() != null) {
            pathExpiryOptions = options.getExpiryRelativeTo() == FileExpirationOffset.CREATION_TIME ? PathExpiryOptions.RELATIVE_TO_CREATION : PathExpiryOptions.RELATIVE_TO_NOW;
            expiresOn = Long.toString(options.getTimeToExpire().toMillis());
        } else {
            pathExpiryOptions = PathExpiryOptions.NEVER_EXPIRE;
            expiresOn = null;
        }
        Callable<ResponseBase> operation = () -> this.blobDataLakeStorage.getPaths().setExpiryWithResponse(pathExpiryOptions, null, null, expiresOn, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        return new SimpleResponse<Object>(response, null);
    }
}

