/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.models.ResponseError;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

final class ResponseErrorDeserializer
extends StdDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    private static final Pattern CODE_PATTERN = Pattern.compile("\"code\"", 2);
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\"message\"", 2);
    private static final Pattern TARGET_PATTERN = Pattern.compile("\"target\"", 2);
    private static final Pattern DETAILS_PATTERN = Pattern.compile("\"details\"", 2);
    public static final String ERROR_PROPERTY_KEY = "error";
    private final ObjectMapper mapper;

    private ResponseErrorDeserializer(Class<?> classType, ObjectMapper mapper) {
        super(classType);
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (ResponseError.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new ResponseErrorDeserializer(beanDesc.getBeanClass(), mapper);
                }
                return deserializer;
            }
        });
        return module;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        jsonParser.setCodec(this.mapper);
        JsonNode errorNode = (JsonNode)jsonParser.readValueAsTree();
        if (errorNode == null) {
            return null;
        }
        if (errorNode.get(ERROR_PROPERTY_KEY) != null) {
            errorNode = errorNode.get(ERROR_PROPERTY_KEY);
        }
        String nodeContent = errorNode.toString();
        nodeContent = CODE_PATTERN.matcher(nodeContent).replaceFirst("\"code\"");
        nodeContent = MESSAGE_PATTERN.matcher(nodeContent).replaceFirst("\"message\"");
        nodeContent = TARGET_PATTERN.matcher(nodeContent).replaceFirst("\"target\"");
        nodeContent = DETAILS_PATTERN.matcher(nodeContent).replaceFirst("\"details\"");
        JsonParser parser = new JsonFactory().createParser(nodeContent);
        parser.setCodec(this.mapper);
        return parser.readValueAs(this.handledType());
    }
}

