/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.clplog;

import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.plugin.inputformat.clplog.CLPLogRecordExtractorConfig;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPLogRecordExtractor
extends BaseRecordExtractor<Map<String, Object>> {
    private static final int MAX_VARIABLES_PER_CELL = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(CLPLogRecordExtractor.class);
    private Set<String> _fields;
    private boolean _extractAll = false;
    private CLPLogRecordExtractorConfig _config;
    private EncodedMessage _clpEncodedMessage;
    private MessageEncoder _clpMessageEncoder;
    private String _unencodableFieldErrorLogtype = null;
    private String[] _unencodableFieldErrorDictionaryVars = null;
    private Long[] _unencodableFieldErrorEncodedVars = null;
    private String _topicName;
    private ServerMetrics _serverMetrics;
    PinotMeter _realtimeClpTooManyEncodedVarsMeter = null;
    PinotMeter _realtimeClpUnencodableMeter = null;
    PinotMeter _realtimeClpEncodedNonStringsMeter = null;

    public void init(Set<String> fields, @Nullable RecordExtractorConfig recordExtractorConfig, String topicName, ServerMetrics serverMetrics) {
        this.init(fields, recordExtractorConfig);
        this._topicName = topicName;
        this._serverMetrics = serverMetrics;
    }

    public void init(Set<String> fields, @Nullable RecordExtractorConfig recordExtractorConfig, String topicName) {
        this.init(fields, recordExtractorConfig);
        this._topicName = topicName;
    }

    public void init(Set<String> fields, @Nullable RecordExtractorConfig recordExtractorConfig) {
        this._config = (CLPLogRecordExtractorConfig)recordExtractorConfig;
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Set.of();
        } else {
            this._fields = new HashSet<String>(fields);
            this._fields.removeAll(this._config.getFieldsForClpEncoding());
        }
        this._clpEncodedMessage = new EncodedMessage();
        this._clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        String unencodableFieldError = this._config.getUnencodableFieldError();
        if (null != unencodableFieldError) {
            try {
                this._clpMessageEncoder.encodeMessage(unencodableFieldError, this._clpEncodedMessage);
                this._unencodableFieldErrorLogtype = this._clpEncodedMessage.getLogTypeAsString();
                this._unencodableFieldErrorDictionaryVars = this._clpEncodedMessage.getDictionaryVarsAsStrings();
                this._unencodableFieldErrorEncodedVars = this._clpEncodedMessage.getEncodedVarsAsBoxedLongs();
            }
            catch (IOException e) {
                LOGGER.error("Can't encode 'unencodableFieldError' with CLP. error: {}", (Object)e.getMessage());
            }
        }
    }

    public GenericRow extract(Map<String, Object> from, GenericRow to) {
        Object value;
        Set<String> clpEncodedFieldNames = this._config.getFieldsForClpEncoding();
        if (this._config.getTopicNameDestinationColumn() != null) {
            to.putValue(this._config.getTopicNameDestinationColumn(), (Object)this._topicName);
        }
        if (this._extractAll) {
            for (Map.Entry<String, Object> recordEntry : from.entrySet()) {
                String recordKey = recordEntry.getKey();
                Object recordValue = recordEntry.getValue();
                if (clpEncodedFieldNames.contains(recordKey)) {
                    this.encodeFieldWithClp(recordKey, recordValue, to);
                    continue;
                }
                if (null != recordValue) {
                    recordValue = this.convert(recordValue);
                }
                to.putValue(recordKey, recordValue);
            }
            return to;
        }
        for (String fieldName : this._fields) {
            value = from.get(fieldName);
            if (null != value) {
                value = this.convert(value);
            }
            to.putValue(fieldName, value);
        }
        for (String fieldName : this._config.getFieldsForClpEncoding()) {
            value = from.get(fieldName);
            this.encodeFieldWithClp(fieldName, value, to);
        }
        return to;
    }

    protected Object convertSingleValue(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        return super.convertSingleValue(value);
    }

    private void encodeFieldWithClp(String key, Object value, GenericRow to) {
        String logtype = null;
        String[] dictVars = null;
        Long[] encodedVars = null;
        if (null != value) {
            boolean fieldIsUnencodable = false;
            String valueAsString = null;
            if (value instanceof String) {
                valueAsString = (String)value;
            } else {
                try {
                    valueAsString = JsonUtils.objectToString((Object)value);
                    this._realtimeClpEncodedNonStringsMeter = this._serverMetrics.addMeteredTableValue(this._topicName, (AbstractMetrics.Meter)ServerMeter.REALTIME_CLP_ENCODED_NON_STRINGS, 1L, this._realtimeClpEncodedNonStringsMeter);
                }
                catch (JsonProcessingException ex) {
                    LOGGER.error("Can't convert value of type {} to String (to encode with CLP). name: '{}', value: '{}'", new Object[]{value.getClass().getSimpleName(), key, value});
                    fieldIsUnencodable = true;
                }
            }
            if (null != valueAsString) {
                try {
                    this._clpMessageEncoder.encodeMessage(valueAsString, this._clpEncodedMessage);
                    logtype = this._clpEncodedMessage.getLogTypeAsString();
                    encodedVars = this._clpEncodedMessage.getEncodedVarsAsBoxedLongs();
                    dictVars = this._clpEncodedMessage.getDictionaryVarsAsStrings();
                    if (null != dictVars && dictVars.length > 1000 || null != encodedVars && encodedVars.length > 1000) {
                        this._realtimeClpTooManyEncodedVarsMeter = this._serverMetrics.addMeteredTableValue(this._topicName, (AbstractMetrics.Meter)ServerMeter.REALTIME_CLP_TOO_MANY_ENCODED_VARS, 1L, this._realtimeClpTooManyEncodedVarsMeter);
                        fieldIsUnencodable = true;
                    }
                }
                catch (IOException e) {
                    this._realtimeClpUnencodableMeter = this._serverMetrics.addMeteredTableValue(this._topicName, (AbstractMetrics.Meter)ServerMeter.REALTIME_CLP_UNENCODABLE, 1L, this._realtimeClpUnencodableMeter);
                    fieldIsUnencodable = true;
                }
            }
            if (fieldIsUnencodable) {
                String unencodableFieldSuffix = this._config.getUnencodableFieldSuffix();
                if (null != unencodableFieldSuffix) {
                    String unencodableFieldKey = key + unencodableFieldSuffix;
                    to.putValue(unencodableFieldKey, value);
                }
                if (null != this._config.getUnencodableFieldError()) {
                    logtype = this._unencodableFieldErrorLogtype;
                    dictVars = this._unencodableFieldErrorDictionaryVars;
                    encodedVars = this._unencodableFieldErrorEncodedVars;
                } else {
                    logtype = null;
                    dictVars = null;
                    encodedVars = null;
                }
            }
        }
        to.putValue(key + "_logtype", logtype);
        to.putValue(key + "_dictionaryVars", dictVars);
        to.putValue(key + "_encodedVars", encodedVars);
        if (!this._config.getRemoveProcessedFields()) {
            to.putValue(key, value);
        }
    }
}

