/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.filesystem;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.base.Strings;
import org.apache.pinot.shaded.com.google.common.base.Supplier;
import org.apache.pinot.shaded.com.google.common.base.Suppliers;

public class GcsUri {
    public static final String SCHEME = "gs";
    public static final String DELIMITER = "/";
    private final URI _uri;
    private final Supplier<String> _path;
    private final Supplier<String> _prefix;
    private final Supplier<Path> _absolutePath;

    public GcsUri(URI uri) {
        Objects.requireNonNull(uri, "uri is null");
        Objects.requireNonNull(uri.getAuthority(), "uri authority is null");
        Preconditions.checkState(!uri.isOpaque(), "URI cannot be opaque");
        this._uri = GcsUri.createUri(uri.getAuthority(), uri.getPath().replaceAll("/+", DELIMITER));
        this._path = Suppliers.memoize(this::calculatePath);
        this._prefix = Suppliers.memoize(this::calculatePrefix);
        this._absolutePath = Suppliers.memoize(this::calculateAbsolutePath);
    }

    public String getBucketName() {
        return this._uri.getAuthority();
    }

    public String getPath() {
        return this._path.get();
    }

    private String calculatePath() {
        if (Strings.isNullOrEmpty(this._uri.getPath()) || this._uri.getPath().equals(DELIMITER)) {
            return "";
        }
        return this._uri.getPath().substring(1);
    }

    public URI getUri() {
        return this._uri;
    }

    public String getPrefix() {
        return this._prefix.get();
    }

    private String calculatePrefix() {
        String prefix = this.getPath();
        if (Strings.isNullOrEmpty(prefix) || prefix.equals(DELIMITER)) {
            return "";
        }
        if (prefix.endsWith(DELIMITER)) {
            return prefix;
        }
        return prefix + DELIMITER;
    }

    public static GcsUri createGcsUri(String bucket, String path) {
        return new GcsUri(GcsUri.createUri(bucket, GcsUri.toAbsolutePath(path)));
    }

    private static URI createUri(String bucket, String path) {
        try {
            return new URI(SCHEME, bucket, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toAbsolutePath(String path) {
        if (path.startsWith(DELIMITER)) {
            return path;
        }
        return DELIMITER + path;
    }

    private Path calculateAbsolutePath() {
        return Paths.get(GcsUri.toAbsolutePath(this.getPath()), new String[0]);
    }

    public GcsUri resolve(String path) {
        Path relativePath = Paths.get(path, new String[0]);
        Preconditions.checkState(!relativePath.isAbsolute(), "path is absolute");
        String resolvedPath = this._absolutePath.get().resolve(relativePath).toString();
        return GcsUri.createGcsUri(this.getBucketName(), resolvedPath);
    }

    public boolean hasSubpath(GcsUri subPath) {
        Path relativePath = this._absolutePath.get().relativize(subPath._absolutePath.get());
        return !relativePath.isAbsolute() && !relativePath.startsWith("..");
    }

    public String relativize(GcsUri subPath) {
        Path relativePath = this._absolutePath.get().relativize(subPath._absolutePath.get());
        Preconditions.checkState(!relativePath.isAbsolute() && !relativePath.startsWith(".."), "Path '%s' is not a subdirectory of '%s'", (Object)this._absolutePath.get(), (Object)subPath._absolutePath.get());
        return relativePath.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GcsUri)) {
            return false;
        }
        GcsUri that = (GcsUri)other;
        return this._uri.equals(that._uri);
    }

    public int hashCode() {
        return this._uri.hashCode();
    }

    public String toString() {
        return this._uri.toString();
    }
}

