/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.InternalLogId;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.StatusOr;
import io.grpc.SynchronizationContext;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.RoutingUtils;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.XdsConfig;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsRouteConfigureResource;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.client.XdsResourceType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.shaded.com.google.common.collect.Sets;

final class XdsDependencyManager
implements XdsConfig.XdsClusterSubscriptionRegistry {
    public static final XdsClusterResource CLUSTER_RESOURCE = XdsClusterResource.getInstance();
    public static final XdsEndpointResource ENDPOINT_RESOURCE = XdsEndpointResource.getInstance();
    private static final int MAX_CLUSTER_RECURSION_DEPTH = 16;
    private final XdsClient xdsClient;
    private final XdsConfigWatcher xdsConfigWatcher;
    private final SynchronizationContext syncContext;
    private final String dataPlaneAuthority;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private StatusOr<XdsConfig> lastUpdate = null;
    private final Map<XdsResourceType<?>, TypeWatchers<?>> resourceWatchers = new HashMap();

    XdsDependencyManager(XdsClient xdsClient, XdsConfigWatcher xdsConfigWatcher, SynchronizationContext syncContext, String dataPlaneAuthority, String listenerName, NameResolver.Args nameResolverArgs, ScheduledExecutorService scheduler) {
        this.logId = InternalLogId.allocate("xds-dependency-manager", listenerName);
        this.logger = XdsLogger.withLogId(this.logId);
        this.xdsClient = Preconditions.checkNotNull(xdsClient, "xdsClient");
        this.xdsConfigWatcher = Preconditions.checkNotNull(xdsConfigWatcher, "xdsConfigWatcher");
        this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
        this.dataPlaneAuthority = Preconditions.checkNotNull(dataPlaneAuthority, "dataPlaneAuthority");
        Preconditions.checkNotNull(nameResolverArgs, "nameResolverArgs");
        Preconditions.checkNotNull(scheduler, "scheduler");
        syncContext.execute(() -> this.addWatcher(new LdsWatcher(listenerName)));
    }

    public static String toContextStr(String typeName, String resourceName) {
        return typeName + " resource " + resourceName;
    }

    @Override
    public Closeable subscribeToCluster(String clusterName) {
        Preconditions.checkNotNull(clusterName, "clusterName");
        ClusterSubscription subscription = new ClusterSubscription(clusterName);
        this.syncContext.execute(() -> {
            this.addClusterWatcher(clusterName, subscription, 1);
            this.maybePublishConfig();
        });
        return subscription;
    }

    private <T extends XdsClient.ResourceUpdate> void addWatcher(XdsWatcherBase<T> watcher) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        XdsResourceType type = ((XdsWatcherBase)watcher).type;
        String resourceName = ((XdsWatcherBase)watcher).resourceName;
        TypeWatchers<Object> typeWatchers = this.resourceWatchers.get(type);
        if (typeWatchers == null) {
            typeWatchers = new TypeWatchers(type);
            this.resourceWatchers.put(type, typeWatchers);
        }
        typeWatchers.add(resourceName, watcher);
        this.xdsClient.watchXdsResource(type, resourceName, watcher, this.syncContext);
    }

    private void cancelCdsWatcher(CdsWatcher watcher, Object parentContext) {
        if (watcher == null) {
            return;
        }
        watcher.parentContexts.remove(parentContext);
        if (watcher.parentContexts.isEmpty()) {
            this.cancelWatcher(watcher);
        }
    }

    private void cancelEdsWatcher(EdsWatcher watcher, CdsWatcher parentContext) {
        if (watcher == null) {
            return;
        }
        watcher.parentContexts.remove(parentContext);
        if (watcher.parentContexts.isEmpty()) {
            this.cancelWatcher(watcher);
        }
    }

    private <T extends XdsClient.ResourceUpdate> void cancelWatcher(XdsWatcherBase<T> watcher) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (watcher == null) {
            return;
        }
        if (watcher instanceof CdsWatcher || watcher instanceof EdsWatcher) {
            XdsDependencyManager.throwIfParentContextsNotEmpty(watcher);
        }
        watcher.cancelled = true;
        XdsResourceType type = ((XdsWatcherBase)watcher).type;
        String resourceName = ((XdsWatcherBase)watcher).resourceName;
        TypeWatchers<?> typeWatchers = this.resourceWatchers.get(type);
        if (typeWatchers == null) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Trying to cancel watcher {0}, but type not watched", watcher);
            return;
        }
        typeWatchers.watchers.remove(resourceName);
        this.xdsClient.cancelXdsResourceWatch(type, resourceName, watcher);
    }

    private static void throwIfParentContextsNotEmpty(XdsWatcherBase<?> watcher) {
        EdsWatcher edsWatcher;
        if (watcher instanceof CdsWatcher) {
            CdsWatcher cdsWatcher = (CdsWatcher)watcher;
            if (!cdsWatcher.parentContexts.isEmpty()) {
                String msg = String.format("CdsWatcher %s has parent contexts %s", cdsWatcher.resourceName(), cdsWatcher.parentContexts.keySet());
                throw new IllegalStateException(msg);
            }
        } else if (watcher instanceof EdsWatcher && !(edsWatcher = (EdsWatcher)watcher).parentContexts.isEmpty()) {
            String msg = String.format("CdsWatcher %s has parent contexts %s", edsWatcher.resourceName(), edsWatcher.parentContexts);
            throw new IllegalStateException(msg);
        }
    }

    public void shutdown() {
        this.syncContext.execute(() -> {
            for (TypeWatchers<?> watchers : this.resourceWatchers.values()) {
                this.shutdownWatchersForType(watchers);
            }
            this.resourceWatchers.clear();
        });
    }

    private <T extends XdsClient.ResourceUpdate> void shutdownWatchersForType(TypeWatchers<T> watchers) {
        for (Map.Entry watcherEntry : watchers.watchers.entrySet()) {
            this.xdsClient.cancelXdsResourceWatch(watchers.resourceType, watcherEntry.getKey(), watcherEntry.getValue());
            watcherEntry.getValue().cancelled = true;
        }
    }

    private void releaseSubscription(ClusterSubscription subscription) {
        Preconditions.checkNotNull(subscription, "subscription");
        String clusterName = subscription.getClusterName();
        this.syncContext.execute(() -> {
            XdsWatcherBase cdsWatcher = this.resourceWatchers.get((Object)XdsDependencyManager.CLUSTER_RESOURCE).watchers.get(clusterName);
            if (cdsWatcher == null) {
                return;
            }
            this.cancelClusterWatcherTree((CdsWatcher)cdsWatcher, subscription);
            this.maybePublishConfig();
        });
    }

    private void cancelClusterWatcherTree(CdsWatcher root, Object parentContext) {
        Preconditions.checkNotNull(root, "root");
        this.cancelCdsWatcher(root, parentContext);
        if (!root.hasDataValue() || !root.parentContexts.isEmpty()) {
            return;
        }
        XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)root.getData().getValue();
        switch (cdsUpdate.clusterType()) {
            case EDS: {
                String edsServiceName = root.getEdsServiceName();
                EdsWatcher edsWatcher = (EdsWatcher)this.resourceWatchers.get((Object)XdsDependencyManager.ENDPOINT_RESOURCE).watchers.get(edsServiceName);
                this.cancelEdsWatcher(edsWatcher, root);
                break;
            }
            case AGGREGATE: {
                for (String cluster : cdsUpdate.prioritizedClusterNames()) {
                    CdsWatcher clusterWatcher = (CdsWatcher)this.resourceWatchers.get((Object)XdsDependencyManager.CLUSTER_RESOURCE).watchers.get(cluster);
                    if (clusterWatcher == null) continue;
                    this.cancelClusterWatcherTree(clusterWatcher, root);
                }
                break;
            }
            case LOGICAL_DNS: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown cluster type: " + (Object)((Object)cdsUpdate.clusterType())));
            }
        }
    }

    private void maybePublishConfig() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        boolean waitingOnResource = this.resourceWatchers.values().stream().flatMap(typeWatchers -> typeWatchers.watchers.values().stream()).anyMatch(XdsWatcherBase::missingResult);
        if (waitingOnResource) {
            return;
        }
        StatusOr<XdsConfig> newUpdate = this.buildUpdate();
        if (Objects.equals(newUpdate, this.lastUpdate)) {
            return;
        }
        assert (newUpdate.hasValue() || newUpdate.getStatus().getCode() == Status.Code.UNAVAILABLE || newUpdate.getStatus().getCode() == Status.Code.INTERNAL);
        this.lastUpdate = newUpdate;
        this.xdsConfigWatcher.onUpdate(this.lastUpdate);
    }

    @VisibleForTesting
    StatusOr<XdsConfig> buildUpdate() {
        XdsConfig.XdsConfigBuilder builder = new XdsConfig.XdsConfigBuilder();
        RdsUpdateSupplier routeSource = null;
        for (XdsWatcherBase<XdsListenerResource.LdsUpdate> ldsWatcher : this.getWatchers(XdsListenerResource.getInstance()).values()) {
            if (!ldsWatcher.getData().hasValue()) {
                return StatusOr.fromStatus(ldsWatcher.getData().getStatus());
            }
            XdsListenerResource.LdsUpdate ldsUpdate = ldsWatcher.getData().getValue();
            builder.setListener(ldsUpdate);
            routeSource = ((LdsWatcher)ldsWatcher).getRouteSource();
        }
        StatusOr<XdsRouteConfigureResource.RdsUpdate> statusOrRdsUpdate = routeSource.getRdsUpdate();
        if (!statusOrRdsUpdate.hasValue()) {
            return StatusOr.fromStatus(statusOrRdsUpdate.getStatus());
        }
        XdsRouteConfigureResource.RdsUpdate rdsUpdate = statusOrRdsUpdate.getValue();
        builder.setRoute(rdsUpdate);
        VirtualHost activeVirtualHost = RoutingUtils.findVirtualHostForHostName(rdsUpdate.virtualHosts, this.dataPlaneAuthority);
        if (activeVirtualHost == null) {
            String error = "Failed to find virtual host matching hostname: " + this.dataPlaneAuthority;
            return StatusOr.fromStatus(Status.UNAVAILABLE.withDescription(error));
        }
        builder.setVirtualHost(activeVirtualHost);
        Map<String, XdsWatcherBase<XdsEndpointResource.EdsUpdate>> edsWatchers = this.getWatchers(ENDPOINT_RESOURCE);
        Map<String, XdsWatcherBase<XdsClusterResource.CdsUpdate>> cdsWatchers = this.getWatchers(CLUSTER_RESOURCE);
        List<String> topLevelClusters = cdsWatchers.values().stream().filter(XdsDependencyManager::isTopLevelCluster).map(XdsWatcherBase::resourceName).distinct().collect(Collectors.toList());
        Set<String> leafNames = this.addTopLevelClustersToBuilder(builder, edsWatchers, cdsWatchers, topLevelClusters);
        this.addLeavesToBuilder(builder, edsWatchers, leafNames);
        return StatusOr.fromValue(builder.build());
    }

    private <T extends XdsClient.ResourceUpdate> Map<String, XdsWatcherBase<T>> getWatchers(XdsResourceType<T> resourceType) {
        TypeWatchers<?> typeWatchers = this.resourceWatchers.get(resourceType);
        if (typeWatchers == null) {
            return Collections.emptyMap();
        }
        assert (typeWatchers.resourceType == resourceType);
        TypeWatchers<?> tTypeWatchers = typeWatchers;
        return tTypeWatchers.watchers;
    }

    private void addLeavesToBuilder(XdsConfig.XdsConfigBuilder builder, Map<String, XdsWatcherBase<XdsEndpointResource.EdsUpdate>> edsWatchers, Set<String> leafNames) {
        for (String clusterName : leafNames) {
            CdsWatcher cdsWatcher = this.getCluster(clusterName);
            StatusOr cdsUpdateOr = cdsWatcher.getData();
            if (!cdsUpdateOr.hasValue()) {
                builder.addCluster(clusterName, StatusOr.fromStatus(cdsUpdateOr.getStatus()));
                continue;
            }
            XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)cdsUpdateOr.getValue();
            if (cdsUpdate.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS) {
                XdsWatcherBase<XdsEndpointResource.EdsUpdate> edsWatcher = edsWatchers.get(cdsWatcher.getEdsServiceName());
                XdsConfig.XdsClusterConfig.EndpointConfig child = edsWatcher != null ? new XdsConfig.XdsClusterConfig.EndpointConfig(edsWatcher.getData()) : new XdsConfig.XdsClusterConfig.EndpointConfig(StatusOr.fromStatus(Status.INTERNAL.withDescription("EDS resource not found for cluster " + clusterName)));
                builder.addCluster(clusterName, StatusOr.fromValue(new XdsConfig.XdsClusterConfig(clusterName, cdsUpdate, child)));
                continue;
            }
            if (cdsUpdate.clusterType() != XdsClusterResource.CdsUpdate.ClusterType.LOGICAL_DNS) continue;
            builder.addCluster(clusterName, StatusOr.fromStatus(Status.INTERNAL.withDescription("Logical DNS in dependency manager unsupported")));
        }
    }

    private Set<String> addTopLevelClustersToBuilder(XdsConfig.XdsConfigBuilder builder, Map<String, XdsWatcherBase<XdsEndpointResource.EdsUpdate>> edsWatchers, Map<String, XdsWatcherBase<XdsClusterResource.CdsUpdate>> cdsWatchers, List<String> topLevelClusters) {
        HashSet<String> leafClusterNames = new HashSet<String>();
        for (String clusterName : topLevelClusters) {
            XdsConfig.XdsClusterConfig.ClusterChild child;
            CdsWatcher cdsWatcher = (CdsWatcher)cdsWatchers.get(clusterName);
            StatusOr cdsWatcherDataOr = cdsWatcher.getData();
            if (!cdsWatcher.hasDataValue()) {
                builder.addCluster(clusterName, StatusOr.fromStatus(cdsWatcherDataOr.getStatus()));
                continue;
            }
            XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)cdsWatcherDataOr.getValue();
            switch (cdsUpdate.clusterType()) {
                case AGGREGATE: {
                    HashSet<String> leafNames = new HashSet<String>();
                    this.addLeafNames(leafNames, cdsUpdate);
                    child = new XdsConfig.XdsClusterConfig.AggregateConfig(leafNames);
                    leafClusterNames.addAll(leafNames);
                    break;
                }
                case EDS: {
                    XdsWatcherBase<XdsEndpointResource.EdsUpdate> edsWatcher = edsWatchers.get(cdsWatcher.getEdsServiceName());
                    if (edsWatcher != null) {
                        child = new XdsConfig.XdsClusterConfig.EndpointConfig(edsWatcher.getData());
                        break;
                    }
                    child = new XdsConfig.XdsClusterConfig.EndpointConfig(StatusOr.fromStatus(Status.INTERNAL.withDescription("EDS resource not found for cluster " + clusterName)));
                    break;
                }
                case LOGICAL_DNS: {
                    child = new XdsConfig.XdsClusterConfig.EndpointConfig(StatusOr.fromStatus(Status.INTERNAL.withDescription("Logical DNS in dependency manager unsupported")));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)cdsUpdate.clusterType()));
                }
            }
            builder.addCluster(clusterName, StatusOr.fromValue(new XdsConfig.XdsClusterConfig(clusterName, cdsUpdate, child)));
        }
        return leafClusterNames;
    }

    private void addLeafNames(Set<String> leafNames, XdsClusterResource.CdsUpdate cdsUpdate) {
        for (String cluster : cdsUpdate.prioritizedClusterNames()) {
            if (leafNames.contains(cluster)) continue;
            StatusOr data = this.getCluster(cluster).getData();
            if (data == null || !data.hasValue() || data.getValue() == null) {
                leafNames.add(cluster);
                continue;
            }
            if (((XdsClusterResource.CdsUpdate)data.getValue()).clusterType() == XdsClusterResource.CdsUpdate.ClusterType.AGGREGATE) {
                this.addLeafNames(leafNames, (XdsClusterResource.CdsUpdate)data.getValue());
                continue;
            }
            leafNames.add(cluster);
        }
    }

    private static boolean isTopLevelCluster(XdsWatcherBase<XdsClusterResource.CdsUpdate> cdsWatcher) {
        return ((CdsWatcher)cdsWatcher).parentContexts.values().stream().anyMatch(depth -> depth == 1);
    }

    public String toString() {
        return this.logId.toString();
    }

    private boolean addEdsWatcher(String edsServiceName, CdsWatcher parentContext) {
        TypeWatchers<?> typeWatchers = this.resourceWatchers.get(XdsEndpointResource.getInstance());
        if (typeWatchers == null || !typeWatchers.watchers.containsKey(edsServiceName)) {
            this.addWatcher(new EdsWatcher(edsServiceName, parentContext));
            return true;
        }
        EdsWatcher watcher = (EdsWatcher)typeWatchers.watchers.get(edsServiceName);
        watcher.addParentContext(parentContext);
        return false;
    }

    private void addClusterWatcher(String clusterName, Object parentContext, int depth) {
        CdsWatcher watcher;
        TypeWatchers<?> clusterWatchers = this.resourceWatchers.get(CLUSTER_RESOURCE);
        if (clusterWatchers != null && (watcher = (CdsWatcher)clusterWatchers.watchers.get(clusterName)) != null) {
            watcher.parentContexts.put(parentContext, depth);
            return;
        }
        this.addWatcher(new CdsWatcher(clusterName, parentContext, depth));
    }

    private void updateRoutes(List<VirtualHost> virtualHosts, Object newParentContext, List<VirtualHost> oldVirtualHosts, boolean sameParentContext) {
        VirtualHost oldVirtualHost = RoutingUtils.findVirtualHostForHostName(oldVirtualHosts, this.dataPlaneAuthority);
        VirtualHost virtualHost = RoutingUtils.findVirtualHostForHostName(virtualHosts, this.dataPlaneAuthority);
        Set<String> newClusters = XdsDependencyManager.getClusterNamesFromVirtualHost(virtualHost);
        Set<String> oldClusters = XdsDependencyManager.getClusterNamesFromVirtualHost(oldVirtualHost);
        if (sameParentContext) {
            Sets.SetView<String> addedClusters = Sets.difference(newClusters, oldClusters);
            Sets.SetView<String> deletedClusters = Sets.difference(oldClusters, newClusters);
            deletedClusters.forEach(watcher -> this.cancelClusterWatcherTree(this.getCluster((String)watcher), newParentContext));
            addedClusters.forEach(cluster -> this.addClusterWatcher((String)cluster, newParentContext, 1));
        } else {
            newClusters.forEach(cluster -> this.addClusterWatcher((String)cluster, newParentContext, 1));
        }
    }

    private String nodeInfo() {
        return " nodeID: " + this.xdsClient.getBootstrapInfo().node().getId();
    }

    private static Set<String> getClusterNamesFromVirtualHost(VirtualHost virtualHost) {
        if (virtualHost == null) {
            return Collections.emptySet();
        }
        HashSet<String> clusters = new HashSet<String>();
        for (VirtualHost.Route route : virtualHost.routes()) {
            VirtualHost.Route.RouteAction action = route.routeAction();
            if (action == null) continue;
            if (action.cluster() != null) {
                clusters.add(action.cluster());
                continue;
            }
            if (action.weightedClusters() == null) continue;
            for (VirtualHost.Route.RouteAction.ClusterWeight weighedCluster : action.weightedClusters()) {
                clusters.add(weighedCluster.name());
            }
        }
        return clusters;
    }

    private CdsWatcher getCluster(String clusterName) {
        return (CdsWatcher)this.resourceWatchers.get((Object)XdsDependencyManager.CLUSTER_RESOURCE).watchers.get(clusterName);
    }

    private class EdsWatcher
    extends XdsWatcherBase<XdsEndpointResource.EdsUpdate> {
        private final Set<CdsWatcher> parentContexts;

        private EdsWatcher(String resourceName, CdsWatcher parentContext) {
            super(ENDPOINT_RESOURCE, Preconditions.checkNotNull(resourceName, "resourceName"));
            this.parentContexts = new HashSet<CdsWatcher>();
            this.parentContexts.add(Preconditions.checkNotNull(parentContext, "parentContext"));
        }

        @Override
        public void onChanged(XdsEndpointResource.EdsUpdate update) {
            if (this.cancelled) {
                return;
            }
            this.setData(Preconditions.checkNotNull(update, "update"));
            XdsDependencyManager.this.maybePublishConfig();
        }

        void addParentContext(CdsWatcher parentContext) {
            this.parentContexts.add(Preconditions.checkNotNull(parentContext, "parentContext"));
        }
    }

    private class CdsWatcher
    extends XdsWatcherBase<XdsClusterResource.CdsUpdate> {
        Map<Object, Integer> parentContexts;

        CdsWatcher(String resourceName, Object parentContext, int depth) {
            super(CLUSTER_RESOURCE, Preconditions.checkNotNull(resourceName, "resourceName"));
            this.parentContexts = new HashMap<Object, Integer>();
            this.parentContexts.put(Preconditions.checkNotNull(parentContext, "parentContext"), depth);
        }

        @Override
        public void onChanged(XdsClusterResource.CdsUpdate update) {
            Preconditions.checkNotNull(update, "update");
            if (this.cancelled) {
                return;
            }
            switch (update.clusterType()) {
                case EDS: {
                    this.setData(update);
                    if (XdsDependencyManager.this.addEdsWatcher(this.getEdsServiceName(), this)) break;
                    XdsDependencyManager.this.maybePublishConfig();
                    break;
                }
                case LOGICAL_DNS: {
                    this.setData(update);
                    XdsDependencyManager.this.maybePublishConfig();
                    break;
                }
                case AGGREGATE: {
                    CdsWatcher parentContext = this;
                    int depth = this.parentContexts.values().stream().max(Integer::compare).orElse(0) + 1;
                    if (depth > 16) {
                        XdsDependencyManager.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Cluster recursion depth limit exceeded for cluster {0}", this.resourceName());
                        Status error = Status.UNAVAILABLE.withDescription("aggregate cluster graph exceeds max depth at " + this.resourceName() + XdsDependencyManager.this.nodeInfo());
                        this.setDataAsStatus(error);
                    }
                    if (this.hasDataValue()) {
                        HashSet<String> oldNames = ((XdsClusterResource.CdsUpdate)this.getData().getValue()).clusterType() == XdsClusterResource.CdsUpdate.ClusterType.AGGREGATE ? new HashSet<String>(((XdsClusterResource.CdsUpdate)this.getData().getValue()).prioritizedClusterNames()) : Collections.emptySet();
                        HashSet<String> newNames = new HashSet<String>(update.prioritizedClusterNames());
                        Sets.SetView<String> deletedClusters = Sets.difference(oldNames, newNames);
                        deletedClusters.forEach(cluster -> XdsDependencyManager.this.cancelClusterWatcherTree(XdsDependencyManager.this.getCluster(cluster), parentContext));
                        if (depth <= 16) {
                            this.setData(update);
                            Sets.SetView<String> addedClusters = Sets.difference(newNames, oldNames);
                            addedClusters.forEach(cluster -> XdsDependencyManager.this.addClusterWatcher(cluster, parentContext, depth));
                            if (!addedClusters.isEmpty()) break;
                            XdsDependencyManager.this.maybePublishConfig();
                            break;
                        }
                        XdsDependencyManager.this.maybePublishConfig();
                        break;
                    }
                    if (depth > 16) break;
                    this.setData(update);
                    update.prioritizedClusterNames().forEach(name -> XdsDependencyManager.this.addClusterWatcher(name, parentContext, depth));
                    XdsDependencyManager.this.maybePublishConfig();
                    break;
                }
                default: {
                    Status error = Status.UNAVAILABLE.withDescription("aggregate cluster graph exceeds max depth at " + this.resourceName() + XdsDependencyManager.this.nodeInfo());
                    this.setDataAsStatus(error);
                    XdsDependencyManager.this.maybePublishConfig();
                }
            }
        }

        public String getEdsServiceName() {
            XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)this.getData().getValue();
            assert (cdsUpdate.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS);
            String edsServiceName = cdsUpdate.edsServiceName();
            if (edsServiceName == null) {
                edsServiceName = cdsUpdate.clusterName();
            }
            return edsServiceName;
        }
    }

    private class RdsWatcher
    extends XdsWatcherBase<XdsRouteConfigureResource.RdsUpdate>
    implements RdsUpdateSupplier {
        public RdsWatcher(String resourceName) {
            super(XdsRouteConfigureResource.getInstance(), Preconditions.checkNotNull(resourceName, "resourceName"));
        }

        @Override
        public void onChanged(XdsRouteConfigureResource.RdsUpdate update) {
            Preconditions.checkNotNull(update, "update");
            if (this.cancelled) {
                return;
            }
            List oldVirtualHosts = this.hasDataValue() ? ((XdsRouteConfigureResource.RdsUpdate)this.getData().getValue()).virtualHosts : Collections.emptyList();
            this.setData(update);
            XdsDependencyManager.this.updateRoutes(update.virtualHosts, this, oldVirtualHosts, true);
            XdsDependencyManager.this.maybePublishConfig();
        }

        @Override
        public StatusOr<XdsRouteConfigureResource.RdsUpdate> getRdsUpdate() {
            if (this.missingResult()) {
                return StatusOr.fromStatus(Status.UNAVAILABLE.withDescription("Not yet loaded"));
            }
            return this.getData();
        }
    }

    private class LdsWatcher
    extends XdsWatcherBase<XdsListenerResource.LdsUpdate>
    implements RdsUpdateSupplier {
        String rdsName;

        private LdsWatcher(String resourceName) {
            super(XdsListenerResource.getInstance(), resourceName);
        }

        @Override
        public void onChanged(XdsListenerResource.LdsUpdate update) {
            boolean changedRdsName;
            String rdsName;
            List virtualHosts;
            Preconditions.checkNotNull(update, "update");
            if (this.cancelled) {
                return;
            }
            HttpConnectionManager httpConnectionManager = update.httpConnectionManager();
            if (httpConnectionManager == null) {
                virtualHosts = Collections.emptyList();
                rdsName = null;
            } else {
                virtualHosts = httpConnectionManager.virtualHosts();
                rdsName = httpConnectionManager.rdsName();
            }
            StatusOr<XdsRouteConfigureResource.RdsUpdate> activeRdsUpdate = this.getRouteSource().getRdsUpdate();
            List activeVirtualHosts = activeRdsUpdate.hasValue() ? activeRdsUpdate.getValue().virtualHosts : Collections.emptyList();
            boolean bl = changedRdsName = !Objects.equals(rdsName, this.rdsName);
            if (changedRdsName) {
                this.cleanUpRdsWatcher();
            }
            if (virtualHosts != null) {
                XdsDependencyManager.this.updateRoutes(virtualHosts, this, activeVirtualHosts, this.rdsName == null);
                this.rdsName = null;
            } else if (changedRdsName) {
                this.rdsName = rdsName;
                XdsDependencyManager.this.addWatcher(new RdsWatcher(rdsName));
                XdsDependencyManager.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching RDS resource {0}", rdsName);
            }
            this.setData(update);
            XdsDependencyManager.this.maybePublishConfig();
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkArgument(this.resourceName().equals(resourceName), "Resource name does not match");
            this.setDataAsStatus(Status.UNAVAILABLE.withDescription(this.toContextString() + " does not exist" + XdsDependencyManager.this.nodeInfo()));
            this.cleanUpRdsWatcher();
            this.rdsName = null;
            XdsDependencyManager.this.maybePublishConfig();
        }

        private void cleanUpRdsWatcher() {
            RdsWatcher oldRdsWatcher = this.getRdsWatcher();
            if (oldRdsWatcher != null) {
                XdsDependencyManager.this.cancelWatcher(oldRdsWatcher);
                XdsDependencyManager.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Stop watching RDS resource {0}", this.rdsName);
                if (!oldRdsWatcher.hasDataValue() || XdsDependencyManager.this.resourceWatchers.get(CLUSTER_RESOURCE) == null) {
                    return;
                }
                for (XdsWatcherBase watcher : ((TypeWatchers)((XdsDependencyManager)XdsDependencyManager.this).resourceWatchers.get((Object)XdsDependencyManager.CLUSTER_RESOURCE)).watchers.values()) {
                    XdsDependencyManager.this.cancelCdsWatcher((CdsWatcher)watcher, oldRdsWatcher);
                }
            }
        }

        private RdsWatcher getRdsWatcher() {
            if (this.rdsName == null) {
                return null;
            }
            TypeWatchers watchers = (TypeWatchers)XdsDependencyManager.this.resourceWatchers.get(XdsRouteConfigureResource.getInstance());
            if (watchers == null) {
                return null;
            }
            return (RdsWatcher)watchers.watchers.get(this.rdsName);
        }

        public RdsUpdateSupplier getRouteSource() {
            if (!this.hasDataValue()) {
                return this;
            }
            HttpConnectionManager hcm = ((XdsListenerResource.LdsUpdate)this.getData().getValue()).httpConnectionManager();
            if (hcm == null) {
                return this;
            }
            ImmutableList<VirtualHost> virtualHosts = hcm.virtualHosts();
            if (virtualHosts != null) {
                return this;
            }
            RdsWatcher rdsWatcher = this.getRdsWatcher();
            assert (rdsWatcher != null);
            return rdsWatcher;
        }

        @Override
        public StatusOr<XdsRouteConfigureResource.RdsUpdate> getRdsUpdate() {
            if (this.missingResult()) {
                return StatusOr.fromStatus(Status.UNAVAILABLE.withDescription("Not yet loaded"));
            }
            if (!this.getData().hasValue()) {
                return StatusOr.fromStatus(this.getData().getStatus());
            }
            HttpConnectionManager hcm = ((XdsListenerResource.LdsUpdate)this.getData().getValue()).httpConnectionManager();
            if (hcm == null) {
                return StatusOr.fromStatus(Status.UNAVAILABLE.withDescription("Not an API listener" + XdsDependencyManager.this.nodeInfo()));
            }
            ImmutableList<VirtualHost> virtualHosts = hcm.virtualHosts();
            if (virtualHosts == null) {
                return StatusOr.fromStatus(Status.INTERNAL.withDescription("Routes are in RDS, not LDS"));
            }
            return StatusOr.fromValue(new XdsRouteConfigureResource.RdsUpdate(virtualHosts));
        }
    }

    private static interface RdsUpdateSupplier {
        public StatusOr<XdsRouteConfigureResource.RdsUpdate> getRdsUpdate();
    }

    private abstract class XdsWatcherBase<T extends XdsClient.ResourceUpdate>
    implements XdsClient.ResourceWatcher<T> {
        private final XdsResourceType<T> type;
        private final String resourceName;
        boolean cancelled;
        @Nullable
        private StatusOr<T> data;

        private XdsWatcherBase(XdsResourceType<T> type, String resourceName) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.resourceName = Preconditions.checkNotNull(resourceName, "resourceName");
        }

        @Override
        public void onError(Status error) {
            Preconditions.checkNotNull(error, "error");
            if (this.cancelled) {
                return;
            }
            if (!this.hasDataValue()) {
                this.setDataAsStatus(Status.UNAVAILABLE.withDescription(String.format("Error retrieving %s: %s: %s", new Object[]{this.toContextString(), error.getCode(), error.getDescription()})));
                XdsDependencyManager.this.maybePublishConfig();
            }
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkArgument(this.resourceName.equals(resourceName), "Resource name does not match");
            this.setDataAsStatus(Status.UNAVAILABLE.withDescription(this.toContextString() + " does not exist" + XdsDependencyManager.this.nodeInfo()));
            XdsDependencyManager.this.maybePublishConfig();
        }

        boolean missingResult() {
            return this.data == null;
        }

        @Nullable
        StatusOr<T> getData() {
            return this.data;
        }

        boolean hasDataValue() {
            return this.data != null && this.data.hasValue();
        }

        String resourceName() {
            return this.resourceName;
        }

        protected void setData(T data) {
            Preconditions.checkNotNull(data, "data");
            this.data = StatusOr.fromValue(data);
        }

        protected void setDataAsStatus(Status status) {
            Preconditions.checkNotNull(status, "status");
            this.data = StatusOr.fromStatus(status);
        }

        public String toContextString() {
            return XdsDependencyManager.toContextStr(this.type.typeName(), this.resourceName);
        }
    }

    private class ClusterSubscription
    implements Closeable {
        String clusterName;

        public ClusterSubscription(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        @Override
        public void close() throws IOException {
            XdsDependencyManager.this.releaseSubscription(this);
        }
    }

    public static interface XdsConfigWatcher {
        public void onUpdate(StatusOr<XdsConfig> var1);
    }

    private static class TypeWatchers<T extends XdsClient.ResourceUpdate> {
        final Map<String, XdsWatcherBase<T>> watchers = new HashMap<String, XdsWatcherBase<T>>();
        final XdsResourceType<T> resourceType;

        TypeWatchers(XdsResourceType<T> resourceType) {
            this.resourceType = resourceType;
        }

        public void add(String resourceName, XdsWatcherBase<T> watcher) {
            this.watchers.put(resourceName, watcher);
        }
    }
}

