/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import io.grpc.ExperimentalApi;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

public final class StreamObservers {
    private StreamObservers() {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10957")
    public static <T> void nextAndComplete(StreamObserver<T> responseObserver, T response) {
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(target, "target");
        final class FlowControllingOnReadyHandler
        implements Runnable {
            private boolean completed;

            FlowControllingOnReadyHandler() {
            }

            @Override
            public void run() {
                if (this.completed) {
                    return;
                }
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    this.completed = true;
                    target.onCompleted();
                }
            }
        }
        target.setOnReadyHandler(new FlowControllingOnReadyHandler());
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

