/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import io.grpc.Metadata;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.io.BaseEncoding;

final class MetadataSetter
implements TextMapSetter<Metadata> {
    private static final Logger logger = Logger.getLogger(MetadataSetter.class.getName());
    private static final MetadataSetter INSTANCE = new MetadataSetter();

    MetadataSetter() {
    }

    public static MetadataSetter getInstance() {
        return INSTANCE;
    }

    @Override
    public void set(@Nullable Metadata carrier, String key, String value) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, setting no data");
            return;
        }
        try {
            if (key.equals("grpc-trace-bin")) {
                carrier.put(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER), BaseEncoding.base64().decode(value));
            } else {
                carrier.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.format("Failed to set metadata, key=%s", key), e);
        }
    }

    void set(@Nullable Metadata carrier, String key, byte[] value) {
        if (carrier == null) {
            logger.log(Level.FINE, "Carrier is null, setting no data");
            return;
        }
        if (!key.equals("grpc-trace-bin")) {
            logger.log(Level.INFO, "Only support 'grpc-trace-bin' binary header. Set no data");
            return;
        }
        try {
            carrier.put(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER), value);
        }
        catch (Exception e) {
            logger.log(Level.INFO, String.format("Failed to set metadata key=%s", key), e);
        }
    }
}

