/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;

final class StorageOptionsUtil {
    static final String USER_AGENT_ENTRY_NAME = "gcloud-java-nio";
    static final String USER_AGENT_ENTRY_VERSION = StorageOptionsUtil.getVersion();
    private static final String USER_AGENT_ENTRY = String.format("%s/%s", "gcloud-java-nio", USER_AGENT_ENTRY_VERSION);
    private static final FixedHeaderProvider DEFAULT_HEADER_PROVIDER = FixedHeaderProvider.create("user-agent", USER_AGENT_ENTRY);
    private static final StorageOptions DEFAULT_STORAGE_OPTIONS_INSTANCE = ((StorageOptions.Builder)StorageOptions.newBuilder().setHeaderProvider(DEFAULT_HEADER_PROVIDER)).build();
    private static final FixedHeaderProvider EMTPY_HEADER_PROVIDER = FixedHeaderProvider.create(Collections.emptyMap());

    private StorageOptionsUtil() {
    }

    static StorageOptions getDefaultInstance() {
        return DEFAULT_STORAGE_OPTIONS_INSTANCE;
    }

    static StorageOptions mergeOptionsWithUserAgent(StorageOptions providedStorageOptions) {
        if (providedStorageOptions == DEFAULT_STORAGE_OPTIONS_INSTANCE) {
            return providedStorageOptions;
        }
        String userAgent = providedStorageOptions.getUserAgent();
        if (userAgent == null) {
            return StorageOptionsUtil.nullSafeSet(providedStorageOptions, DEFAULT_HEADER_PROVIDER);
        }
        if (!userAgent.contains(USER_AGENT_ENTRY_NAME)) {
            HeaderProvider providedHeaderProvider = StorageOptionsUtil.getHeaderProvider(providedStorageOptions);
            HashMap<String, String> newHeaders = new HashMap<String, String>(providedHeaderProvider.getHeaders());
            newHeaders.put("user-agent", String.format("%s %s", userAgent, USER_AGENT_ENTRY));
            FixedHeaderProvider headerProvider = FixedHeaderProvider.create(ImmutableMap.copyOf(newHeaders));
            return StorageOptionsUtil.nullSafeSet(providedStorageOptions, headerProvider);
        }
        return providedStorageOptions;
    }

    private static StorageOptions nullSafeSet(StorageOptions storageOptions, HeaderProvider headerProvider) {
        StorageOptions.Builder builder = storageOptions.toBuilder();
        if (builder == null) {
            return storageOptions;
        }
        return ((StorageOptions.Builder)builder.setHeaderProvider(headerProvider)).build();
    }

    private static String getVersion() {
        String version = "";
        try (InputStream inputStream = CloudStorageFileSystemProvider.class.getResourceAsStream("/META-INF/maven/com.google.cloud/google-cloud-nio/pom.properties");){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                version = properties.getProperty("version");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    @VisibleForTesting
    static HeaderProvider getHeaderProvider(StorageOptions options) {
        return options.getMergedHeaderProvider(EMTPY_HEADER_PROVIDER);
    }
}

