/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.refreshsegment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class RefreshSegmentTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshSegmentTaskGenerator.class);

    public String getTaskType() {
        return "RefreshSegmentTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
            if (tableTaskConfig == null) {
                LOGGER.warn("Failed to find task config for table: {}", (Object)tableConfig.getTableName());
                continue;
            }
            Map taskConfigs = tableTaskConfig.getConfigsForTaskType("RefreshSegmentTask");
            pinotTaskConfigs.addAll(this.generateTasksForTable(tableConfig, taskConfigs));
        }
        return pinotTaskConfigs;
    }

    public List<PinotTaskConfig> generateTasks(TableConfig tableConfig, Map<String, String> taskConfigs) throws Exception {
        return this.generateTasksForTable(tableConfig, taskConfigs);
    }

    private List<PinotTaskConfig> generateTasksForTable(TableConfig tableConfig, Map<String, String> taskConfigs) {
        String tableNameWithType = tableConfig.getTableName();
        Preconditions.checkNotNull(taskConfigs, (String)"Task config shouldn't be null for Table: %s", (Object)tableNameWithType);
        String taskType = "RefreshSegmentTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        PinotHelixResourceManager pinotHelixResourceManager = this._clusterInfoAccessor.getPinotHelixResourceManager();
        LOGGER.info("Start generating RefreshSegment tasks for table: {}", (Object)tableNameWithType);
        int tableNumTasks = 0;
        int tableMaxNumTasks = 20;
        String tableMaxNumTasksConfig = taskConfigs.get("tableMaxNumTasks");
        if (tableMaxNumTasksConfig != null) {
            try {
                tableMaxNumTasks = Integer.parseInt(tableMaxNumTasksConfig);
            }
            catch (Exception e) {
                tableMaxNumTasks = 20;
                LOGGER.warn("MaxNumTasks have been wrongly set for table : {}, and task {}", (Object)tableNameWithType, (Object)taskType);
            }
        }
        Stat tableStat = pinotHelixResourceManager.getTableStat(tableNameWithType);
        Schema schema = pinotHelixResourceManager.getTableSchema(tableNameWithType);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)tableNameWithType);
        Stat schemaStat = pinotHelixResourceManager.getSchemaStat(schema.getSchemaName());
        Set runningSegments = TaskGeneratorUtils.getRunningSegments((String)"RefreshSegmentTask", (ClusterInfoAccessor)this._clusterInfoAccessor);
        List allSegments = tableConfig.getTableType() == TableType.OFFLINE ? this.getSegmentsZKMetadataForTable(tableNameWithType) : this.getNonConsumingSegmentsZKMetadataForRealtimeTable(tableNameWithType);
        for (SegmentZKMetadata segmentZKMetadata : allSegments) {
            if (tableNumTasks >= tableMaxNumTasks) break;
            if (runningSegments.contains(new Segment(tableNameWithType, segmentZKMetadata.getSegmentName()))) continue;
            String segmentName = segmentZKMetadata.getSegmentName();
            if (!this.shouldRefreshSegment(segmentZKMetadata, tableConfig, tableStat, schemaStat)) continue;
            HashMap<String, Object> configs = new HashMap<String, Object>(this.getBaseTaskConfigs(tableConfig, List.of(segmentName)));
            configs.put("downloadURL", segmentZKMetadata.getDownloadUrl());
            configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
            configs.put("crc", String.valueOf(segmentZKMetadata.getCrc()));
            pinotTaskConfigs.add(new PinotTaskConfig(taskType, configs));
            ++tableNumTasks;
        }
        LOGGER.info("Finished generating {} tasks configs for table: {} for task: {}", new Object[]{tableNumTasks, tableNameWithType, taskType});
        return pinotTaskConfigs;
    }

    private boolean shouldRefreshSegment(SegmentZKMetadata segmentZKMetadata, TableConfig tableConfig, Stat tableStat, Stat schemaStat) {
        String tableNameWithType = tableConfig.getTableName();
        String timestampKey = "RefreshSegmentTask.time";
        long lastProcessedTime = 0L;
        if (segmentZKMetadata.getCustomMap() != null && segmentZKMetadata.getCustomMap().containsKey(timestampKey)) {
            lastProcessedTime = MinionTaskUtils.fromUTCString((String)segmentZKMetadata.getCustomMap().get(timestampKey));
        }
        if (tableStat == null || schemaStat == null) {
            LOGGER.warn("Table or schema stat is null for table: {}", (Object)tableNameWithType);
            return false;
        }
        long tableMTime = tableStat.getMtime();
        long schemaMTime = schemaStat.getMtime();
        boolean segmentProcessedBeforeUpdate = tableMTime > lastProcessedTime || schemaMTime > lastProcessedTime;
        return segmentProcessedBeforeUpdate;
    }
}

