/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.MinionMeter;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.minion.MinionConf;
import org.apache.pinot.minion.event.MinionEventObserver;
import org.apache.pinot.minion.event.MinionEventObservers;
import org.apache.pinot.minion.exception.TaskCancelledException;
import org.apache.pinot.plugin.minion.tasks.BaseTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionUtils;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.TableSpec;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMultipleSegmentsConversionExecutor
extends BaseTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMultipleSegmentsConversionExecutor.class);
    private static final String CUSTOM_SEGMENT_UPLOAD_CONTEXT_LINEAGE_ENTRY_ID = "lineageEntryId";
    private static final int DEFAULT_PUSH_ATTEMPTS = 5;
    private static final int DEFAULT_PUSH_PARALLELISM = 1;
    private static final long DEFAULT_PUSH_RETRY_INTERVAL_MILLIS = 1000L;
    protected MinionConf _minionConf;
    protected PinotTaskConfig _pinotTaskConfig;
    protected MinionEventObserver _eventObserver;

    public BaseMultipleSegmentsConversionExecutor(MinionConf minionConf) {
        this._minionConf = minionConf;
    }

    protected abstract List<SegmentConversionResult> convert(PinotTaskConfig var1, List<File> var2, File var3) throws Exception;

    protected void preProcess(PinotTaskConfig pinotTaskConfig) throws Exception {
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String inputSegmentNames = (String)configs.get("segmentName");
        String uploadURL = (String)configs.get("uploadURL");
        AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
        Set<String> segmentNamesForTable = SegmentConversionUtils.getSegmentNamesForTable(tableNameWithType, FileUploadDownloadClient.extractBaseURI((URI)new URI(uploadURL)), authProvider);
        HashSet<String> nonExistingSegmentNames = new HashSet<String>(Arrays.asList(inputSegmentNames.split(",")));
        nonExistingSegmentNames.removeAll(segmentNamesForTable);
        if (!CollectionUtils.isEmpty(nonExistingSegmentNames)) {
            throw new RuntimeException("table: " + tableNameWithType + " does not have the following segments to process: " + String.valueOf(nonExistingSegmentNames));
        }
    }

    protected void postProcess(PinotTaskConfig pinotTaskConfig) throws Exception {
    }

    protected void preUploadSegments(SegmentUploadContext context) throws Exception {
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Prepare to upload segments: " + context.getSegmentConversionResults().size()));
        if (context.isReplaceSegmentsEnabled()) {
            List segmentsFrom = Arrays.stream(StringUtils.split((String)context.getInputSegmentNames(), (String)",")).map(String::trim).collect(Collectors.toList());
            List segmentsTo = context.getSegmentConversionResults().stream().map(SegmentConversionResult::getSegmentName).collect(Collectors.toList());
            String lineageEntryId = SegmentConversionUtils.startSegmentReplace(context.getTableNameWithType(), context.getUploadURL(), new StartReplaceSegmentsRequest(segmentsFrom, segmentsTo), context.getAuthProvider());
            context.setCustomContext(CUSTOM_SEGMENT_UPLOAD_CONTEXT_LINEAGE_ENTRY_ID, lineageEntryId);
        }
    }

    protected void postUploadSegments(SegmentUploadContext context) throws Exception {
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Finishing uploading segments: " + context.getSegmentConversionResults().size()));
        if (context.isReplaceSegmentsEnabled()) {
            String lineageEntryId = (String)context.getCustomContext(CUSTOM_SEGMENT_UPLOAD_CONTEXT_LINEAGE_ENTRY_ID);
            SegmentConversionUtils.endSegmentReplace(context.getTableNameWithType(), context.getUploadURL(), lineageEntryId, this._minionConf.getEndReplaceSegmentsTimeoutMs(), context.getAuthProvider());
        }
    }

    @VisibleForTesting
    public void setMinionEventObserver(MinionEventObserver observer) {
        this._eventObserver = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SegmentConversionResult> executeTask(PinotTaskConfig pinotTaskConfig) throws Exception {
        this.preProcess(pinotTaskConfig);
        this._pinotTaskConfig = pinotTaskConfig;
        this._eventObserver = MinionEventObservers.getInstance().getMinionEventObserver(pinotTaskConfig.getTaskId());
        String taskType = pinotTaskConfig.getTaskType();
        Map taskConfigs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)taskConfigs.get("tableName");
        String inputSegmentNames = (String)taskConfigs.get("segmentName");
        String[] segmentNames = inputSegmentNames.split(",");
        String uploadURL = (String)taskConfigs.get("uploadURL");
        String downloadURLString = (String)taskConfigs.get("downloadURL");
        String[] downloadURLs = downloadURLString.split(",");
        AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)((String)taskConfigs.get("authToken")));
        File tempDataDir = new File(new File(MINION_CONTEXT.getDataDir(), taskType), "tmp-" + String.valueOf(UUID.randomUUID()));
        Preconditions.checkState((boolean)tempDataDir.mkdirs());
        ArrayList<File> inputSegmentDirs = new ArrayList<File>(downloadURLs.length);
        Map<String, SegmentMetadata> segmentMetadataMap = Collections.synchronizedMap(new HashMap(downloadURLs.length));
        int nThreads = Math.min(this.getParallelism(taskConfigs), downloadURLs.length);
        LOGGER.info("Start executing {} on table: {}, input segments: {} with downloadURLs: {}, uploadURL: {}, thread pool size:{}", new Object[]{taskType, tableNameWithType, inputSegmentNames, downloadURLString, uploadURL, nThreads});
        try {
            if (nThreads <= 1) {
                for (int index = 0; index < downloadURLs.length; ++index) {
                    this.downloadAndUntarSegment(tableNameWithType, taskType, segmentNames[index], downloadURLs[index], tempDataDir, index, segmentMetadataMap, segmentNames.length);
                }
            } else {
                this.parallelDownloadAndUntarSegments(nThreads, tableNameWithType, taskType, segmentNames, downloadURLs, tempDataDir, segmentMetadataMap);
            }
            int numRecords = this.processSegmentMetadata(segmentNames, segmentMetadataMap, inputSegmentDirs);
            File workingDir = new File(tempDataDir, "workingDir");
            Preconditions.checkState((boolean)workingDir.mkdir());
            List<SegmentConversionResult> segmentConversionResults = this.convert(pinotTaskConfig, inputSegmentDirs, workingDir);
            this.reportTaskProcessingMetrics(tableNameWithType, taskType, numRecords);
            File convertedTarredSegmentDir = new File(tempDataDir, "convertedTarredSegmentDir");
            Preconditions.checkState((boolean)convertedTarredSegmentDir.mkdir());
            int numOutputSegments = segmentConversionResults.size();
            ArrayList<File> tarredSegmentFiles = new ArrayList<File>(numOutputSegments);
            int count = 1;
            for (SegmentConversionResult segmentConversionResult : segmentConversionResults) {
                File convertedSegmentDir = segmentConversionResult.getFile();
                this.reportSegmentUploadMetrics(convertedSegmentDir, tableNameWithType, taskType);
                this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Compressing segment: " + segmentConversionResult.getSegmentName() + " (" + count++ + " out of " + numOutputSegments + ")"));
                File convertedSegmentTarFile = new File(convertedTarredSegmentDir, segmentConversionResult.getSegmentName() + ".tar.gz");
                TarCompressionUtils.createCompressedTarFile((File)convertedSegmentDir, (File)convertedSegmentTarFile);
                tarredSegmentFiles.add(convertedSegmentTarFile);
                if (FileUtils.deleteQuietly((File)convertedSegmentDir)) continue;
                LOGGER.warn("Failed to delete converted segment: {}", (Object)convertedSegmentDir.getAbsolutePath());
            }
            for (File inputSegmentDir : inputSegmentDirs) {
                if (!inputSegmentDir.exists() || FileUtils.deleteQuietly((File)inputSegmentDir)) continue;
                LOGGER.warn("Failed to delete input segment: {}", (Object)inputSegmentDir.getAbsolutePath());
            }
            if (this._cancelled) {
                LOGGER.info("{} on table: {}, segments: {} got cancelled", new Object[]{taskType, tableNameWithType, inputSegmentNames});
                throw new TaskCancelledException(taskType + " on table: " + tableNameWithType + ", segments: " + inputSegmentNames + " got cancelled");
            }
            SegmentUploadContext segmentUploadContext = new SegmentUploadContext(pinotTaskConfig, segmentConversionResults);
            this.preUploadSegments(segmentUploadContext);
            HashMap<String, String> segmentUriToTarPathMap = new HashMap<String, String>();
            PushJobSpec pushJobSpec = this.getPushJobSpec(taskConfigs);
            boolean batchSegmentUpload = pushJobSpec.isBatchSegmentUpload();
            for (int i = 0; i < numOutputSegments; ++i) {
                URI outputSegmentTarURI;
                File convertedTarredSegmentFile = (File)tarredSegmentFiles.get(i);
                SegmentConversionResult segmentConversionResult = segmentConversionResults.get(i);
                String resultSegmentName = segmentConversionResult.getSegmentName();
                this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Uploading segment: " + resultSegmentName + " (" + (i + 1) + " out of " + numOutputSegments + ")"));
                String pushMode = taskConfigs.getOrDefault("push.mode", BatchConfigProperties.SegmentPushType.TAR.name());
                if (BatchConfigProperties.SegmentPushType.valueOf((String)pushMode.toUpperCase()) != BatchConfigProperties.SegmentPushType.TAR) {
                    outputSegmentTarURI = this.moveSegmentToOutputPinotFS(taskConfigs, convertedTarredSegmentFile);
                    LOGGER.info("Moved generated segment from [{}] to location: [{}]", (Object)convertedTarredSegmentFile, (Object)outputSegmentTarURI);
                } else {
                    outputSegmentTarURI = convertedTarredSegmentFile.toURI();
                }
                List<Header> httpHeaders = this.getSegmentPushCommonHeaders(pinotTaskConfig, authProvider, segmentConversionResults);
                List<NameValuePair> parameters = this.getSegmentPushCommonParams(tableNameWithType);
                if ("RealtimeToOfflineSegmentsTask".equals(taskType)) {
                    Iterator<NameValuePair> paramItr = parameters.iterator();
                    while (paramItr.hasNext()) {
                        NameValuePair nameValuePair = paramItr.next();
                        if (!"tableType".equals(nameValuePair.getName())) continue;
                        paramItr.remove();
                        break;
                    }
                    parameters.add((NameValuePair)new BasicNameValuePair("tableType", TableType.OFFLINE.toString()));
                }
                if (batchSegmentUpload) {
                    this.updateSegmentUriToTarPathMap(taskConfigs, outputSegmentTarURI, segmentConversionResult, segmentUriToTarPathMap, pushJobSpec);
                    continue;
                }
                String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
                this.pushSegment(rawTableName, taskConfigs, outputSegmentTarURI, httpHeaders, parameters, segmentConversionResult);
                if (FileUtils.deleteQuietly((File)convertedTarredSegmentFile)) continue;
                LOGGER.warn("Failed to delete tarred converted segment: {}", (Object)convertedTarredSegmentFile.getAbsolutePath());
            }
            if (batchSegmentUpload) {
                try {
                    this.pushSegments(tableNameWithType, taskConfigs, pinotTaskConfig, segmentUriToTarPathMap, pushJobSpec, authProvider, segmentConversionResults);
                }
                finally {
                    for (File convertedTarredSegmentFile : tarredSegmentFiles) {
                        if (FileUtils.deleteQuietly((File)convertedTarredSegmentFile)) continue;
                        LOGGER.warn("Failed to delete converted tarred segment file: {}", (Object)convertedTarredSegmentFile.getAbsolutePath());
                    }
                }
            }
            this.postUploadSegments(segmentUploadContext);
            String outputSegmentNames = segmentConversionResults.stream().map(SegmentConversionResult::getSegmentName).collect(Collectors.joining(","));
            this.postProcess(pinotTaskConfig);
            LOGGER.info("Done executing {} on table: {}, input segments: {}, output segments: {}", new Object[]{taskType, tableNameWithType, inputSegmentNames, outputSegmentNames});
            List<SegmentConversionResult> list = segmentConversionResults;
            return list;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDataDir);
        }
    }

    private int processSegmentMetadata(String[] segmentNames, Map<String, SegmentMetadata> segmentMetadataMap, List<File> inputSegmentDirs) {
        int numRecords = 0;
        for (String segmentName : segmentNames) {
            SegmentMetadata segmentMetadata = segmentMetadataMap.get(segmentName);
            Preconditions.checkState((segmentMetadata != null ? 1 : 0) != 0, (String)"Segment metadata for segment: %s is null, please check the download and untar process", (Object)segmentName);
            inputSegmentDirs.add(segmentMetadata.getIndexDir());
            numRecords += segmentMetadata.getTotalDocs();
        }
        return numRecords;
    }

    private int getParallelism(Map<String, String> taskConfigs) {
        int nThreads = this._minionConf.getSegmentDownloadParallelism();
        nThreads = Integer.parseInt(taskConfigs.getOrDefault("segmentDownloadParallelism", String.valueOf(nThreads)));
        return nThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parallelDownloadAndUntarSegments(int nThreads, String tableNameWithType, String taskType, String[] segmentNames, String[] downloadURLs, File tempDataDir, Map<String, SegmentMetadata> segmentMetadataMap) throws Exception {
        ExecutorService executorService = null;
        int length = downloadURLs.length;
        try {
            executorService = Executors.newFixedThreadPool(nThreads);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(length);
            int i = 0;
            while (i < length) {
                int n = i++;
                futures.add(executorService.submit(() -> {
                    this.downloadAndUntarSegment(tableNameWithType, taskType, segmentNames[n], downloadURLs[n], tempDataDir, n, segmentMetadataMap, segmentNames.length);
                    return null;
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    for (Future future2 : futures) {
                        future2.cancel(true);
                    }
                    throw e;
                    return;
                }
            }
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    private void downloadAndUntarSegment(String tableNameWithType, String taskType, String segmentName, String downloadURL, File tempDataDir, int index, Map<String, SegmentMetadata> segmentMetadataMap, int numOfSegments) throws Exception {
        try {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Downloading and decompressing segment from: " + downloadURL + " (" + (index + 1) + " out of " + numOfSegments + ")"));
            File indexDir = this.downloadSegmentToLocalAndUntar(tableNameWithType, segmentName, downloadURL, taskType, tempDataDir, "_" + index);
            this.reportSegmentDownloadMetrics(indexDir, tableNameWithType, taskType);
            SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
            segmentMetadataMap.put(segmentName, (SegmentMetadata)segmentMetadata);
        }
        catch (Exception e) {
            LOGGER.error("Failed to download segment from download url: {}", (Object)downloadURL, (Object)e);
            this._minionMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)MinionMeter.SEGMENT_DOWNLOAD_FAIL_COUNT, 1L);
            this._eventObserver.notifyTaskError(this._pinotTaskConfig, e);
            throw e;
        }
    }

    @VisibleForTesting
    void updateSegmentUriToTarPathMap(Map<String, String> taskConfigs, URI outputSegmentTarURI, SegmentConversionResult segmentConversionResult, Map<String, String> segmentUriToTarPathMap, PushJobSpec pushJobSpec) {
        String segmentName = segmentConversionResult.getSegmentName();
        if (!taskConfigs.containsKey("output.segment.dir.uri")) {
            throw new RuntimeException("Output dir URI missing for metadata push while processing segment: " + segmentName);
        }
        URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
        Map localSegmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputSegmentDirURI, (PushJobSpec)pushJobSpec, (String[])new String[]{outputSegmentTarURI.toString()});
        if (!localSegmentUriToTarPathMap.isEmpty()) {
            segmentUriToTarPathMap.putAll(localSegmentUriToTarPathMap);
        }
    }

    @VisibleForTesting
    PushJobSpec getPushJobSpec(Map<String, String> taskConfigs) {
        PushJobSpec pushJobSpec = new PushJobSpec();
        pushJobSpec.setPushAttempts(5);
        pushJobSpec.setPushParallelism(1);
        pushJobSpec.setPushRetryIntervalMillis(1000L);
        pushJobSpec.setSegmentUriPrefix(taskConfigs.get("push.segmentUriPrefix"));
        pushJobSpec.setSegmentUriSuffix(taskConfigs.get("push.segmentUriSuffix"));
        boolean batchSegmentUpload = Boolean.parseBoolean(taskConfigs.getOrDefault("batchSegmentUpload", "false"));
        if (batchSegmentUpload) {
            pushJobSpec.setBatchSegmentUpload(true);
        }
        return pushJobSpec;
    }

    @VisibleForTesting
    List<Header> getSegmentPushCommonHeaders(PinotTaskConfig pinotTaskConfig, AuthProvider authProvider, List<SegmentConversionResult> segmentConversionResults) {
        SegmentConversionResult segmentConversionResult = segmentConversionResults.size() == 1 ? segmentConversionResults.get(0) : null;
        SegmentZKMetadataCustomMapModifier segmentZKMetadataCustomMapModifier = this.getSegmentZKMetadataCustomMapModifier(pinotTaskConfig, segmentConversionResult);
        BasicHeader segmentZKMetadataCustomMapModifierHeader = new BasicHeader("Pinot-SegmentZKMetadataCustomMapModifier", (Object)segmentZKMetadataCustomMapModifier.toJsonString());
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)segmentZKMetadataCustomMapModifierHeader);
        headers.addAll(AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider));
        return headers;
    }

    @VisibleForTesting
    List<NameValuePair> getSegmentPushCommonParams(String tableNameWithType) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("enableParallelPushProtection", "true"));
        params.add((NameValuePair)new BasicNameValuePair("tableName", TableNameBuilder.extractRawTableName((String)tableNameWithType)));
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        if (tableType == null) {
            throw new RuntimeException("Failed to determine the tableType from name: " + tableNameWithType);
        }
        params.add((NameValuePair)new BasicNameValuePair("tableType", tableType.toString()));
        return params;
    }

    private void pushSegments(String tableNameWithType, Map<String, String> taskConfigs, PinotTaskConfig pinotTaskConfig, Map<String, String> segmentUriToTarPathMap, PushJobSpec pushJobSpec, AuthProvider authProvider, List<SegmentConversionResult> segmentConversionResults) throws Exception {
        String tableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        SegmentGenerationJobSpec spec = this.generateSegmentGenerationJobSpec(tableName, taskConfigs, pushJobSpec);
        List<Header> headers = this.getSegmentPushCommonHeaders(pinotTaskConfig, authProvider, segmentConversionResults);
        List<NameValuePair> parameters = this.getSegmentPushCommonParams(tableNameWithType);
        URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
        try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
            SegmentPushUtils.sendSegmentsUriAndMetadata((SegmentGenerationJobSpec)spec, (PinotFS)outputFileFS, segmentUriToTarPathMap, headers, parameters);
        }
    }

    private void pushSegment(String tableName, Map<String, String> taskConfigs, URI outputSegmentTarURI, List<Header> headers, List<NameValuePair> parameters, SegmentConversionResult segmentConversionResult) throws Exception {
        String pushMode = taskConfigs.getOrDefault("push.mode", BatchConfigProperties.SegmentPushType.TAR.name());
        LOGGER.info("Trying to push Pinot segment with push mode {} from {}", (Object)pushMode, (Object)outputSegmentTarURI);
        PushJobSpec pushJobSpec = new PushJobSpec();
        pushJobSpec.setPushAttempts(5);
        pushJobSpec.setPushParallelism(1);
        pushJobSpec.setPushRetryIntervalMillis(1000L);
        pushJobSpec.setSegmentUriPrefix(taskConfigs.get("push.segmentUriPrefix"));
        pushJobSpec.setSegmentUriSuffix(taskConfigs.get("push.segmentUriSuffix"));
        SegmentGenerationJobSpec spec = this.generateSegmentGenerationJobSpec(tableName, taskConfigs, pushJobSpec);
        switch (BatchConfigProperties.SegmentPushType.valueOf((String)pushMode.toUpperCase())) {
            case TAR: {
                File tarFile = new File(outputSegmentTarURI);
                String segmentName = segmentConversionResult.getSegmentName();
                String tableNameWithType = segmentConversionResult.getTableNameWithType();
                String uploadURL = taskConfigs.get("uploadURL");
                SegmentConversionUtils.uploadSegment(taskConfigs, headers, parameters, tableNameWithType, segmentName, uploadURL, tarFile);
                break;
            }
            case METADATA: {
                if (taskConfigs.containsKey("output.segment.dir.uri")) {
                    URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
                    try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
                        Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputSegmentDirURI, (PushJobSpec)pushJobSpec, (String[])new String[]{outputSegmentTarURI.toString()});
                        SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)spec, (PinotFS)outputFileFS, (Map)segmentUriToTarPathMap, headers, parameters);
                        break;
                    }
                }
                throw new RuntimeException("Output dir URI missing for metadata push");
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized push mode - " + pushMode);
            }
        }
    }

    private SegmentGenerationJobSpec generateSegmentGenerationJobSpec(String tableName, Map<String, String> taskConfigs, PushJobSpec pushJobSpec) {
        TableSpec tableSpec = new TableSpec();
        tableSpec.setTableName(tableName);
        PinotClusterSpec pinotClusterSpec = new PinotClusterSpec();
        pinotClusterSpec.setControllerURI(taskConfigs.get("push.controllerUri"));
        PinotClusterSpec[] pinotClusterSpecs = new PinotClusterSpec[]{pinotClusterSpec};
        SegmentGenerationJobSpec spec = new SegmentGenerationJobSpec();
        spec.setPushJobSpec(pushJobSpec);
        spec.setTableSpec(tableSpec);
        spec.setPinotClusterSpecs(pinotClusterSpecs);
        spec.setAuthToken(taskConfigs.get("authToken"));
        return spec;
    }

    private URI moveSegmentToOutputPinotFS(Map<String, String> taskConfigs, File localSegmentTarFile) throws Exception {
        URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
        try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
            URI outputSegmentTarURI = URI.create(MinionTaskUtils.normalizeDirectoryURI(outputSegmentDirURI) + localSegmentTarFile.getName());
            if (!Boolean.parseBoolean(taskConfigs.get("overwriteOutput")) && outputFileFS.exists(outputSegmentTarURI)) {
                throw new RuntimeException("Output file: " + String.valueOf(outputSegmentTarURI) + " already exists. Set 'overwriteOutput' to true to ignore this error");
            }
            outputFileFS.copyFromLocalFile(localSegmentTarFile, outputSegmentTarURI);
            URI uRI = outputSegmentTarURI;
            return uRI;
        }
    }

    protected static class SegmentUploadContext {
        private final PinotTaskConfig _pinotTaskConfig;
        private final List<SegmentConversionResult> _segmentConversionResults;
        private final String _tableNameWithType;
        private final String _uploadURL;
        private final AuthProvider _authProvider;
        private final String _inputSegmentNames;
        private final boolean _replaceSegmentsEnabled;
        private final Map<String, Object> _customMap;

        public SegmentUploadContext(PinotTaskConfig pinotTaskConfig, List<SegmentConversionResult> segmentConversionResults) {
            this._pinotTaskConfig = pinotTaskConfig;
            this._segmentConversionResults = segmentConversionResults;
            Map configs = pinotTaskConfig.getConfigs();
            this._tableNameWithType = (String)configs.get("tableName");
            this._uploadURL = (String)configs.get("uploadURL");
            this._authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
            this._inputSegmentNames = (String)configs.get("segmentName");
            String replaceSegmentsString = (String)configs.get("enableReplaceSegments");
            this._replaceSegmentsEnabled = Boolean.parseBoolean(replaceSegmentsString);
            this._customMap = new HashMap<String, Object>();
        }

        public PinotTaskConfig getPinotTaskConfig() {
            return this._pinotTaskConfig;
        }

        public List<SegmentConversionResult> getSegmentConversionResults() {
            return this._segmentConversionResults;
        }

        public String getTableNameWithType() {
            return this._tableNameWithType;
        }

        public String getUploadURL() {
            return this._uploadURL;
        }

        public AuthProvider getAuthProvider() {
            return this._authProvider;
        }

        public String getInputSegmentNames() {
            return this._inputSegmentNames;
        }

        public boolean isReplaceSegmentsEnabled() {
            return this._replaceSegmentsEnabled;
        }

        public Object getCustomContext(String key) {
            return this._customMap.get(key);
        }

        public void setCustomContext(String key, Object value) {
            this._customMap.put(key, value);
        }
    }
}

