/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractor;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractorConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class KafkaAvroMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaAvroMessageDecoder.class);
    private static final String SCHEMA_REGISTRY_REST_URL = "schema.registry.rest.url";
    private static final String SCHEMA_REGISTRY_SCHEMA_NAME = "schema.registry.schema.name";
    private Schema _defaultAvroSchema;
    private MD5AvroSchemaMap _md5ToAvroSchemaMap;
    private static final Map<String, Schema> GLOBAL_SCHEMA_CACHE = new HashMap<String, Schema>();
    private static final String LATEST = "-latest";
    private final byte[] _reusableMD5Bytes = new byte[16];
    private DecoderFactory _decoderFactory;
    private RecordExtractor<GenericData.Record> _avroRecordExtractor;
    private static final int MAGIC_BYTE_LENGTH = 1;
    private static final int SCHEMA_HASH_LENGTH = 16;
    private static final int HEADER_LENGTH = 17;
    private static final int SCHEMA_HASH_START_OFFSET = 1;
    private static final int MAXIMUM_SCHEMA_FETCH_RETRY_COUNT = 5;
    private static final int MINIMUM_SCHEMA_FETCH_RETRY_TIME_MILLIS = 500;
    private static final float SCHEMA_FETCH_RETRY_EXPONENTIAL_BACKOFF_FACTOR = 2.0f;
    private String[] _schemaRegistryUrls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        this._schemaRegistryUrls = this.parseSchemaRegistryUrls(props.get(SCHEMA_REGISTRY_REST_URL));
        String avroSchemaName = topicName;
        if (props.containsKey(SCHEMA_REGISTRY_SCHEMA_NAME) && props.get(SCHEMA_REGISTRY_SCHEMA_NAME) != null && !props.get(SCHEMA_REGISTRY_SCHEMA_NAME).isEmpty()) {
            avroSchemaName = props.get(SCHEMA_REGISTRY_SCHEMA_NAME);
        }
        Map<String, Schema> map = GLOBAL_SCHEMA_CACHE;
        synchronized (map) {
            String hashKey = avroSchemaName + LATEST;
            this._defaultAvroSchema = GLOBAL_SCHEMA_CACHE.get(hashKey);
            if (this._defaultAvroSchema == null) {
                this._defaultAvroSchema = this.fetchSchema("/latest_with_type=" + avroSchemaName);
                GLOBAL_SCHEMA_CACHE.put(hashKey, this._defaultAvroSchema);
                LOGGER.info("Populated schema cache with schema for {}", (Object)hashKey);
            }
        }
        String recordExtractorClass = props.get("recordExtractorClass");
        String recordExtractorConfigClass = props.get("recordExtractorConfigClass");
        if (recordExtractorClass == null) {
            recordExtractorClass = AvroRecordExtractor.class.getName();
            recordExtractorConfigClass = AvroRecordExtractorConfig.class.getName();
        }
        RecordExtractorConfig config = null;
        if (recordExtractorConfigClass != null) {
            config = (RecordExtractorConfig)PluginManager.get().createInstance(recordExtractorConfigClass);
            config.init(props);
        }
        this._avroRecordExtractor = (RecordExtractor)PluginManager.get().createInstance(recordExtractorClass);
        this._avroRecordExtractor.init(fieldsToRead, config);
        this._decoderFactory = new DecoderFactory();
        this._md5ToAvroSchemaMap = new MD5AvroSchemaMap();
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        return this.decode(payload, 0, payload.length, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        if (payload == null || payload.length == 0 || length == 0) {
            return null;
        }
        System.arraycopy(payload, 1 + offset, this._reusableMD5Bytes, 0, 16);
        boolean schemaUpdateFailed = false;
        Schema schema = this._md5ToAvroSchemaMap.getSchema(this._reusableMD5Bytes);
        if (schema == null) {
            Map<String, Schema> map = GLOBAL_SCHEMA_CACHE;
            synchronized (map) {
                String hashKey = this.hex(this._reusableMD5Bytes);
                schema = GLOBAL_SCHEMA_CACHE.get(hashKey);
                if (schema == null) {
                    String schemaUri = "/id=" + this.hex(this._reusableMD5Bytes);
                    try {
                        schema = this.fetchSchema(schemaUri);
                        GLOBAL_SCHEMA_CACHE.put(hashKey, schema);
                        this._md5ToAvroSchemaMap.addSchema(this._reusableMD5Bytes, schema);
                    }
                    catch (Exception e) {
                        schema = this._defaultAvroSchema;
                        LOGGER.error("Error fetching schema using url {}. Attempting to continue with previous schema", (Object)schemaUri, (Object)e);
                        schemaUpdateFailed = true;
                    }
                } else {
                    LOGGER.info("Found schema for {} in cache", (Object)hashKey);
                    this._md5ToAvroSchemaMap.addSchema(this._reusableMD5Bytes, schema);
                }
            }
        }
        GenericDatumReader reader = new GenericDatumReader(schema);
        try {
            GenericData.Record avroRecord = (GenericData.Record)reader.read(null, (Decoder)this._decoderFactory.createBinaryDecoder(payload, 17 + offset, length - 17, null));
            return this._avroRecordExtractor.extract((Object)avroRecord, destination);
        }
        catch (IOException e) {
            LOGGER.error("Caught exception while reading message using schema {}{}", new Object[]{schema == null ? "null" : schema.getName(), schemaUpdateFailed ? "(possibly due to schema update failure)" : "", e});
            return null;
        }
    }

    private String hex(byte[] bytes) {
        StringBuilder builder = new StringBuilder(2 * bytes.length);
        for (byte aByte : bytes) {
            Object hexString = Integer.toHexString(0xFF & aByte);
            if (((String)hexString).length() < 2) {
                hexString = "0" + (String)hexString;
            }
            builder.append((String)hexString);
        }
        return builder.toString();
    }

    private Schema fetchSchema(String reference) throws Exception {
        SchemaFetcher schemaFetcher = new SchemaFetcher(this.makeRandomUrl(reference));
        RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)500L, (double)2.0).attempt((Callable)schemaFetcher);
        return schemaFetcher.getSchema();
    }

    protected URL makeRandomUrl(String reference) throws MalformedURLException {
        Random rand = new Random();
        int randomInteger = rand.nextInt(this._schemaRegistryUrls.length);
        return new URL(this._schemaRegistryUrls[randomInteger] + reference);
    }

    protected String[] parseSchemaRegistryUrls(String schemaConfig) {
        return schemaConfig.split(",");
    }

    private static class MD5AvroSchemaMap {
        private List<byte[]> _md5s = new ArrayList<byte[]>();
        private List<Schema> _schemas = new ArrayList<Schema>();

        private MD5AvroSchemaMap() {
        }

        private Schema getSchema(byte[] md5ForSchema) {
            for (int i = 0; i < this._md5s.size(); ++i) {
                if (!Arrays.equals(this._md5s.get(i), md5ForSchema)) continue;
                return this._schemas.get(i);
            }
            return null;
        }

        private void addSchema(byte[] md5, Schema schema) {
            this._md5s.add(Arrays.copyOf(md5, md5.length));
            this._schemas.add(schema);
        }
    }

    private static class SchemaFetcher
    implements Callable<Boolean> {
        private Schema _schema;
        private URL _url;
        private boolean _isSuccessful = false;

        SchemaFetcher(URL url) {
            this._url = url;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                URLConnection conn = this._url.openConnection();
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
                LOGGER.info("Fetching schema using url {}", (Object)this._url.toString());
                StringBuilder queryResp = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    while (line != null) {
                        queryResp.append(line);
                        line = reader.readLine();
                    }
                }
                this._schema = Schema.parse((String)queryResp.toString());
                LOGGER.info("Schema fetch succeeded on url {}", (Object)this._url.toString());
                return Boolean.TRUE;
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while fetching schema", (Throwable)e);
                return Boolean.FALSE;
            }
        }

        public Schema getSchema() {
            return this._schema;
        }
    }
}

