/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.json;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONMessageDecoder.class);
    private static final String JSON_RECORD_EXTRACTOR_CLASS = "org.apache.pinot.plugin.inputformat.json.JSONRecordExtractor";
    private RecordExtractor<Map<String, Object>> _jsonRecordExtractor;

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        String recordExtractorClass = null;
        if (props != null) {
            recordExtractorClass = props.get("recordExtractorClass");
        }
        if (recordExtractorClass == null) {
            recordExtractorClass = JSON_RECORD_EXTRACTOR_CLASS;
        }
        this._jsonRecordExtractor = (RecordExtractor)PluginManager.get().createInstance(recordExtractorClass);
        this._jsonRecordExtractor.init(fieldsToRead, null);
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            JsonNode message = JsonUtils.bytesToJsonNode((byte[])payload);
            Map from = JsonUtils.jsonNodeToMap((JsonNode)message);
            this._jsonRecordExtractor.extract((Object)from, destination);
            return destination;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while decoding row, discarding row. Payload is {}", (Object)new String(payload), (Object)e);
            return null;
        }
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }
}

