/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.schema;

import com.github.erosb.jsonsKema.AdditionalPropertiesSchema;
import com.github.erosb.jsonsKema.AllOfSchema;
import com.github.erosb.jsonsKema.AnyOfSchema;
import com.github.erosb.jsonsKema.CompositeSchema;
import com.github.erosb.jsonsKema.ConstSchema;
import com.github.erosb.jsonsKema.ContainsSchema;
import com.github.erosb.jsonsKema.DependentRequiredSchema;
import com.github.erosb.jsonsKema.DependentSchemasSchema;
import com.github.erosb.jsonsKema.ExclusiveMaximumSchema;
import com.github.erosb.jsonsKema.ExclusiveMinimumSchema;
import com.github.erosb.jsonsKema.FormatSchema;
import com.github.erosb.jsonsKema.IJsonArray;
import com.github.erosb.jsonsKema.IJsonBoolean;
import com.github.erosb.jsonsKema.IJsonNull;
import com.github.erosb.jsonsKema.IJsonNumber;
import com.github.erosb.jsonsKema.IJsonObject;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.IfThenElseSchema;
import com.github.erosb.jsonsKema.ItemsSchema;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonVisitor;
import com.github.erosb.jsonsKema.MaxItemsSchema;
import com.github.erosb.jsonsKema.MaxLengthSchema;
import com.github.erosb.jsonsKema.MaxPropertiesSchema;
import com.github.erosb.jsonsKema.MaximumSchema;
import com.github.erosb.jsonsKema.MinItemsSchema;
import com.github.erosb.jsonsKema.MinLengthSchema;
import com.github.erosb.jsonsKema.MinPropertiesSchema;
import com.github.erosb.jsonsKema.MinimumSchema;
import com.github.erosb.jsonsKema.MultiTypeSchema;
import com.github.erosb.jsonsKema.MultipleOfSchema;
import com.github.erosb.jsonsKema.OneOfSchema;
import com.github.erosb.jsonsKema.PatternSchema;
import com.github.erosb.jsonsKema.PrefixItemsSchema;
import com.github.erosb.jsonsKema.PropertyNamesSchema;
import com.github.erosb.jsonsKema.ReadOnlySchema;
import com.github.erosb.jsonsKema.ReferenceSchema;
import com.github.erosb.jsonsKema.Regexp;
import com.github.erosb.jsonsKema.RequiredSchema;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SchemaVisitor;
import com.github.erosb.jsonsKema.TypeSchema;
import com.github.erosb.jsonsKema.UnevaluatedItemsSchema;
import com.github.erosb.jsonsKema.UnevaluatedPropertiesSchema;
import com.github.erosb.jsonsKema.UniqueItemsSchema;
import com.github.erosb.jsonsKema.WriteOnlySchema;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.json.schema.SchemaUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class SchemaTranslator
extends SchemaVisitor<SchemaContext> {
    private static final Object NONE_MARKER = new Object();
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();
    private final Map<Schema, Schema.Builder<?>> schemaMapping = new IdentityHashMap();
    private final Deque<Pair<org.everit.json.schema.ReferenceSchema, Schema>> refMapping = new ArrayDeque<Pair<org.everit.json.schema.ReferenceSchema, Schema>>();

    @Override
    public SchemaContext accumulate(Schema parent, SchemaContext previous, SchemaContext current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        return previous.join(parent, current);
    }

    @Override
    public SchemaContext identity(Schema parent) {
        if (parent instanceof AllOfSchema) {
            return new SchemaContext(parent, CombinedSchema.allOf(Collections.emptyList()));
        }
        if (parent instanceof AnyOfSchema) {
            return new SchemaContext(parent, CombinedSchema.anyOf(Collections.emptyList()));
        }
        if (parent instanceof OneOfSchema) {
            return new SchemaContext(parent, CombinedSchema.oneOf(Collections.emptyList()));
        }
        return (SchemaContext)super.identity(parent);
    }

    @Override
    public SchemaContext visitAdditionalPropertiesSchema(AdditionalPropertiesSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitAdditionalPropertiesSchema(schema2);
        assert (ctx2 != null);
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        if (ctx2.schemaBuilder() instanceof FalseSchema.Builder) {
            builder.additionalProperties(false);
        } else if (!(ctx2.schemaBuilder() instanceof TrueSchema.Builder)) {
            builder.schemaOfAdditionalProperties(ctx2.schema());
        }
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitAllOfSchema(AllOfSchema schema2) {
        return (SchemaContext)super.visitAllOfSchema(schema2);
    }

    @Override
    public SchemaContext visitAnyOfSchema(AnyOfSchema schema2) {
        return (SchemaContext)super.visitAnyOfSchema(schema2);
    }

    @Override
    public SchemaContext visitChildren(Schema parent) {
        SchemaContext ctx2 = (SchemaContext)super.visitChildren(parent);
        return ctx2 != null ? ctx2 : new SchemaContext(parent, CombinedSchema.allOf(Collections.emptyList()).isSynthetic(true));
    }

    @Override
    public SchemaContext visitCompositeSchema(CompositeSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitCompositeSchema(schema2);
        if (ctx2 == null) {
            return new SchemaContext(schema2, CombinedSchema.allOf(Collections.emptyList()).isSynthetic(true));
        }
        org.everit.json.schema.Schema ctxSchema = ctx2.schema();
        if (SchemaUtils.isSyntheticAll(ctxSchema)) {
            CombinedSchema combinedSchema = (CombinedSchema)ctxSchema;
            if (combinedSchema.getSubschemas().isEmpty()) {
                ctx2 = new SchemaContext(ctx2.source(), EmptySchema.builder());
            } else if (combinedSchema.getSubschemas().size() == 1) {
                ctx2 = new SchemaContext(ctx2.source(), SchemaUtils.schemaToBuilder(combinedSchema.getSubschemas().iterator().next()));
            }
        }
        if (SchemaUtils.isSyntheticAny(ctxSchema)) {
            ((CombinedSchema.Builder)ctx2.schemaBuilder()).isSynthetic(false);
        }
        if (schema2.getId() != null) {
            ctx2.schemaBuilder().id(schema2.getId().getValue());
        }
        if (schema2.getTitle() != null) {
            ctx2.schemaBuilder().title(schema2.getTitle().getValue());
        }
        if (schema2.getDescription() != null) {
            ctx2.schemaBuilder().description(schema2.getDescription().getValue());
        }
        if (schema2.getDefault() != null) {
            ctx2.schemaBuilder().defaultValue(schema2.getDefault().accept(new JsonValueVisitor()));
        }
        HashMap<String, Object> unprocessed = new HashMap<String, Object>();
        if (!schema2.getUnprocessedProperties().isEmpty()) {
            for (Map.Entry<IJsonString, IJsonValue> entry : schema2.getUnprocessedProperties().entrySet()) {
                String key = entry.getKey().getValue();
                IJsonValue value = entry.getValue();
                Object primitiveValue = NONE_MARKER;
                if (value instanceof JsonBoolean) {
                    primitiveValue = ((JsonBoolean)value).getValue();
                } else if (value instanceof JsonNull) {
                    primitiveValue = null;
                } else if (value instanceof JsonNumber) {
                    primitiveValue = ((JsonNumber)value).getValue();
                } else if (value instanceof JsonString) {
                    primitiveValue = ((JsonString)value).getValue();
                }
                if (primitiveValue != NONE_MARKER) {
                    unprocessed.put(key, primitiveValue);
                    continue;
                }
                if (value instanceof JsonArray) {
                    unprocessed.put(key, OrgJsonUtil.toList(objectMapper.convertValue((Object)value, JSONArray.class)));
                    continue;
                }
                unprocessed.put(key, OrgJsonUtil.toMap(objectMapper.convertValue((Object)value, JSONObject.class)));
            }
        }
        if (!schema2.getDefinedSubschemas().isEmpty()) {
            HashMap<String, org.everit.json.schema.Schema> defs = new HashMap<String, org.everit.json.schema.Schema>();
            for (Map.Entry<String, Schema> entry : schema2.getDefinedSubschemas().entrySet()) {
                String defName = entry.getKey();
                Schema subschema = entry.getValue();
                SchemaContext subctx = subschema.accept(new SchemaTranslator());
                subctx.close();
                defs.put(defName, subctx.schema());
            }
            unprocessed.put("$defs", defs);
        }
        if (!unprocessed.isEmpty()) {
            ctx2.schemaBuilder().unprocessedProperties(unprocessed);
        }
        return ctx2;
    }

    @Override
    public SchemaContext visitConstSchema(ConstSchema schema2) {
        return new SchemaContext(schema2, org.everit.json.schema.ConstSchema.builder().permittedValue(schema2.getConstant().accept(new JsonValueVisitor())));
    }

    @Override
    public SchemaContext visitContainsSchema(ContainsSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitContainsSchema(schema2);
        assert (ctx2 != null);
        return new SchemaContext(schema2, ArraySchema.builder().requiresArray(false).containsItemSchema(ctx2.schema()));
    }

    @Override
    public SchemaContext visitDependentRequiredSchema(DependentRequiredSchema schema2) {
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        for (Map.Entry<String, List<String>> entry : schema2.getDependentRequired().entrySet()) {
            for (String s2 : entry.getValue()) {
                builder.propertyDependency(entry.getKey(), s2);
            }
        }
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitDependentSchemas(DependentSchemasSchema schema2) {
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        for (Map.Entry<String, Schema> entry : schema2.getDependentSchemas().entrySet()) {
            SchemaContext ctx2 = entry.getValue().accept(this);
            assert (ctx2 != null);
            builder.schemaDependency(entry.getKey(), ctx2.schema());
        }
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitEnumSchema(com.github.erosb.jsonsKema.EnumSchema schema2) {
        return new SchemaContext(schema2, EnumSchema.builder().possibleValues(schema2.getPotentialValues().stream().map(v -> v.accept(new JsonValueVisitor())).collect(Collectors.toList())));
    }

    @Override
    public SchemaContext visitExclusiveMaximumSchema(ExclusiveMaximumSchema schema2) {
        return new SchemaContext(schema2, NumberSchema.builder().requiresNumber(false).exclusiveMaximum(schema2.getMaximum()));
    }

    @Override
    public SchemaContext visitExclusiveMinimumSchema(ExclusiveMinimumSchema schema2) {
        return new SchemaContext(schema2, NumberSchema.builder().requiresNumber(false).exclusiveMinimum(schema2.getMinimum()));
    }

    @Override
    public SchemaContext visitFalseSchema(com.github.erosb.jsonsKema.FalseSchema schema2) {
        return new SchemaContext(schema2, FalseSchema.builder());
    }

    @Override
    public SchemaContext visitFormatSchema(FormatSchema schema2) {
        return (SchemaContext)super.visitFormatSchema(schema2);
    }

    @Override
    public SchemaContext visitIfThenElseSchema(IfThenElseSchema schema2) {
        org.everit.json.schema.Schema ifSchema = null;
        if (schema2.getIfSchema() != null) {
            SchemaContext ctx2 = schema2.getIfSchema().accept(this);
            assert (ctx2 != null);
            ifSchema = ctx2.schema();
        }
        org.everit.json.schema.Schema thenSchema = null;
        if (schema2.getThenSchema() != null) {
            SchemaContext ctx3 = schema2.getThenSchema().accept(this);
            assert (ctx3 != null);
            thenSchema = ctx3.schema();
        }
        org.everit.json.schema.Schema elseSchema = null;
        if (schema2.getElseSchema() != null) {
            SchemaContext ctx4 = schema2.getElseSchema().accept(this);
            assert (ctx4 != null);
            elseSchema = ctx4.schema();
        }
        return new SchemaContext(schema2, ConditionalSchema.builder().ifSchema(ifSchema).thenSchema(thenSchema).elseSchema(elseSchema));
    }

    @Override
    public SchemaContext visitItemsSchema(ItemsSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitItemsSchema(schema2);
        assert (ctx2 != null);
        ArraySchema.Builder builder = ArraySchema.builder().requiresArray(false);
        if (ctx2.schemaBuilder() instanceof FalseSchema.Builder) {
            builder.additionalItems(false);
        } else if (!(ctx2.schemaBuilder() instanceof TrueSchema.Builder)) {
            if (schema2.getPrefixItemCount() == 0) {
                builder.allItemSchema(ctx2.schema());
            } else {
                builder.schemaOfAdditionalItems(ctx2.schema());
            }
        }
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitMaxItemsSchema(MaxItemsSchema schema2) {
        return new SchemaContext(schema2, ArraySchema.builder().requiresArray(false).maxItems(schema2.getMaxItems().intValue()));
    }

    @Override
    public SchemaContext visitMaxLengthSchema(MaxLengthSchema schema2) {
        return new SchemaContext(schema2, StringSchema.builder().requiresString(false).maxLength(schema2.getMaxLength()));
    }

    @Override
    public SchemaContext visitMaxPropertiesSchema(MaxPropertiesSchema schema2) {
        return new SchemaContext(schema2, ObjectSchema.builder().requiresObject(false).maxProperties(schema2.getMaxProperties().intValue()));
    }

    @Override
    public SchemaContext visitMaximumSchema(MaximumSchema schema2) {
        return new SchemaContext(schema2, NumberSchema.builder().requiresNumber(false).maximum(schema2.getMaximum()));
    }

    @Override
    public SchemaContext visitMinItemsSchema(MinItemsSchema schema2) {
        return new SchemaContext(schema2, ArraySchema.builder().requiresArray(false).minItems(schema2.getMinItems().intValue()));
    }

    @Override
    public SchemaContext visitMinLengthSchema(MinLengthSchema schema2) {
        return new SchemaContext(schema2, StringSchema.builder().requiresString(false).minLength(schema2.getMinLength()));
    }

    @Override
    public SchemaContext visitMinPropertiesSchema(MinPropertiesSchema schema2) {
        return new SchemaContext(schema2, ObjectSchema.builder().requiresObject(false).minProperties(schema2.getMinProperties().intValue()));
    }

    @Override
    public SchemaContext visitMinimumSchema(MinimumSchema schema2) {
        return new SchemaContext(schema2, NumberSchema.builder().requiresNumber(false).minimum(schema2.getMinimum()));
    }

    @Override
    public SchemaContext visitMultiTypeSchema(MultiTypeSchema schema2) {
        List<org.everit.json.schema.Schema> schemas = schema2.getTypes().getElements().stream().map(json -> this.typeToSchema(json.requireString().getValue()).build()).collect(Collectors.toList());
        return new SchemaContext(schema2, CombinedSchema.anyOf(schemas).isSynthetic(true));
    }

    @Override
    public SchemaContext visitMultipleOfSchema(MultipleOfSchema schema2) {
        return new SchemaContext(schema2, NumberSchema.builder().requiresNumber(false).multipleOf(schema2.getDenominator()));
    }

    @Override
    public SchemaContext visitNotSchema(com.github.erosb.jsonsKema.NotSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitNotSchema(schema2);
        assert (ctx2 != null);
        return new SchemaContext(schema2, NotSchema.builder().mustNotMatch(ctx2.schema()));
    }

    @Override
    public SchemaContext visitOneOfSchema(OneOfSchema schema2) {
        return (SchemaContext)super.visitOneOfSchema(schema2);
    }

    @Override
    public SchemaContext visitPatternPropertySchema(Regexp pattern, Schema schema2) {
        SchemaContext ctx2 = schema2.accept(this);
        assert (ctx2 != null);
        return new SchemaContext(schema2, ObjectSchema.builder().requiresObject(false).patternProperty(pattern.toString(), ctx2.schema()));
    }

    @Override
    public SchemaContext visitPatternSchema(PatternSchema schema2) {
        return new SchemaContext(schema2, StringSchema.builder().requiresString(false).pattern(schema2.getPattern().toString()));
    }

    @Override
    public SchemaContext visitPrefixItemsSchema(PrefixItemsSchema schema2) {
        ArraySchema.Builder builder = ArraySchema.builder().requiresArray(false);
        for (Schema s2 : schema2.getPrefixSchemas()) {
            SchemaContext ctx2 = s2.accept(this);
            assert (ctx2 != null);
            builder.addItemSchema(ctx2.schema());
        }
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitPropertyNamesSchema(PropertyNamesSchema propertyNamesSchema) {
        SchemaContext ctx2 = (SchemaContext)super.visitPropertyNamesSchema(propertyNamesSchema);
        assert (ctx2 != null);
        return new SchemaContext(propertyNamesSchema, ObjectSchema.builder().requiresObject(false).propertyNameSchema(ctx2.schema()));
    }

    @Override
    public SchemaContext visitPropertySchema(String property, Schema schema2) {
        SchemaContext ctx2 = schema2.accept(this);
        assert (ctx2 != null);
        return new SchemaContext(schema2, ObjectSchema.builder().requiresObject(false).addPropertySchema(property, ctx2.schema()));
    }

    @Override
    public SchemaContext visitReadOnlySchema(ReadOnlySchema schema2) {
        return (SchemaContext)super.visitReadOnlySchema(schema2);
    }

    @Override
    public SchemaContext visitReferenceSchema(ReferenceSchema schema2) {
        Schema referredSchema = schema2.getReferredSchema();
        String refValue = schema2.getRef();
        if (refValue.startsWith("mem://input")) {
            refValue = refValue.substring("mem://input".length());
        }
        ReferenceSchema.Builder ref = org.everit.json.schema.ReferenceSchema.builder().refValue(refValue);
        this.refMapping.offer(new Pair<org.everit.json.schema.ReferenceSchema, Schema>(ref.build(), referredSchema));
        return new SchemaContext(schema2, ref);
    }

    @Override
    public SchemaContext visitRequiredSchema(RequiredSchema schema2) {
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        for (String p : schema2.getRequiredProperties()) {
            builder.addRequiredProperty(p);
        }
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitTrueSchema(com.github.erosb.jsonsKema.TrueSchema schema2) {
        return new SchemaContext(schema2, TrueSchema.builder());
    }

    @Override
    public SchemaContext visitTypeSchema(TypeSchema schema2) {
        return new SchemaContext(schema2, this.typeToSchema(schema2.getType().getValue()));
    }

    @Override
    public SchemaContext visitUnevaluatedItemsSchema(UnevaluatedItemsSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitUnevaluatedItemsSchema(schema2);
        assert (ctx2 != null);
        ArraySchema.Builder builder = ArraySchema.builder().requiresArray(false);
        builder.unprocessedProperties(Collections.singletonMap("unevaluatedItems", ctx2.schema()));
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitUnevaluatedPropertiesSchema(UnevaluatedPropertiesSchema schema2) {
        SchemaContext ctx2 = (SchemaContext)super.visitUnevaluatedPropertiesSchema(schema2);
        assert (ctx2 != null);
        ObjectSchema.Builder builder = ObjectSchema.builder().requiresObject(false);
        builder.unprocessedProperties(Collections.singletonMap("unevaluatedProperties", ctx2.schema()));
        return new SchemaContext(schema2, builder);
    }

    @Override
    public SchemaContext visitUniqueItemsSchema(UniqueItemsSchema schema2) {
        return new SchemaContext(schema2, ArraySchema.builder().requiresArray(false).uniqueItems(schema2.getUnique()));
    }

    @Override
    public SchemaContext visitWriteOnlySchema(WriteOnlySchema schema2) {
        return (SchemaContext)super.visitWriteOnlySchema(schema2);
    }

    private Schema.Builder<?> typeToSchema(String type) {
        switch (type) {
            case "string": {
                return StringSchema.builder();
            }
            case "integer": {
                return NumberSchema.builder().requiresInteger(true);
            }
            case "number": {
                return NumberSchema.builder();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return ArraySchema.builder();
            }
            case "object": {
                return ObjectSchema.builder();
            }
        }
        throw new IllegalArgumentException();
    }

    public class SchemaContext
    implements AutoCloseable {
        private final Schema source;
        private final Schema.Builder<?> target;

        public SchemaContext(Schema source, Schema.Builder<?> target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.source = source;
            this.target = target;
            SchemaTranslator.this.schemaMapping.put(source, target);
        }

        public Schema source() {
            return this.source;
        }

        public Schema.Builder<?> schemaBuilder() {
            return this.target;
        }

        public org.everit.json.schema.Schema schema() {
            return this.target.build();
        }

        public SchemaContext join(Schema parent, SchemaContext ctx2) {
            return new SchemaContext(parent, this.join(parent, ctx2.schema()));
        }

        public Schema.Builder<?> join(Schema parent, org.everit.json.schema.Schema current) {
            org.everit.json.schema.Schema schema2 = this.schema();
            if (schema2 instanceof ArraySchema && current instanceof ArraySchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((ArraySchema)schema2), (ArraySchema)current);
            }
            if (schema2 instanceof NumberSchema && current instanceof NumberSchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((NumberSchema)schema2), (NumberSchema)current);
            }
            if (schema2 instanceof ObjectSchema && current instanceof ObjectSchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((ObjectSchema)schema2), (ObjectSchema)current);
            }
            if (schema2 instanceof StringSchema && current instanceof StringSchema) {
                return SchemaUtils.merge(SchemaUtils.toBuilder((StringSchema)schema2), (StringSchema)current);
            }
            if (SchemaUtils.isSyntheticAny(schema2) && SchemaUtils.containsType((CombinedSchema)schema2, current)) {
                return CombinedSchema.anyOf(this.accumulate(new ArrayList<org.everit.json.schema.Schema>(((CombinedSchema)schema2).getSubschemas()), current)).isSynthetic(true);
            }
            if (SchemaUtils.isSyntheticAny(current) && SchemaUtils.containsType((CombinedSchema)current, schema2)) {
                return CombinedSchema.anyOf(this.accumulate(new ArrayList<org.everit.json.schema.Schema>(((CombinedSchema)current).getSubschemas()), schema2)).isSynthetic(true);
            }
            if (parent instanceof AllOfSchema && schema2 instanceof CombinedSchema) {
                return CombinedSchema.allOf(this.concat(((CombinedSchema)schema2).getSubschemas(), this.flatten(current)));
            }
            if (parent instanceof AnyOfSchema && schema2 instanceof CombinedSchema) {
                return CombinedSchema.anyOf(this.concat(((CombinedSchema)schema2).getSubschemas(), this.flatten(current)));
            }
            if (parent instanceof OneOfSchema && schema2 instanceof CombinedSchema) {
                return CombinedSchema.oneOf(this.concat(((CombinedSchema)schema2).getSubschemas(), this.flatten(current)));
            }
            return CombinedSchema.allOf(this.accumulate(this.concat(this.flatten(schema2), this.flatten(current)))).isSynthetic(true);
        }

        private List<org.everit.json.schema.Schema> accumulate(List<org.everit.json.schema.Schema> schemas) {
            List<org.everit.json.schema.Schema> result = new ArrayList<org.everit.json.schema.Schema>();
            for (org.everit.json.schema.Schema schema2 : schemas) {
                result = this.accumulate(result, schema2);
            }
            return result;
        }

        private List<org.everit.json.schema.Schema> accumulate(List<org.everit.json.schema.Schema> product, org.everit.json.schema.Schema current) {
            for (int i = 0; i < product.size(); ++i) {
                org.everit.json.schema.Schema schema2 = product.get(i);
                if (schema2.getClass() != current.getClass()) continue;
                if (schema2 instanceof ArraySchema) {
                    product.set(i, SchemaUtils.merge(SchemaUtils.toBuilder((ArraySchema)schema2), (ArraySchema)current).build());
                    return product;
                }
                if (schema2 instanceof NumberSchema) {
                    product.set(i, SchemaUtils.merge(SchemaUtils.toBuilder((NumberSchema)schema2), (NumberSchema)current).build());
                    return product;
                }
                if (schema2 instanceof ObjectSchema) {
                    product.set(i, SchemaUtils.merge(SchemaUtils.toBuilder((ObjectSchema)schema2), (ObjectSchema)current).build());
                    return product;
                }
                if (!(schema2 instanceof StringSchema)) continue;
                product.set(i, SchemaUtils.merge(SchemaUtils.toBuilder((StringSchema)schema2), (StringSchema)current).build());
                return product;
            }
            product.add(current);
            return product;
        }

        private List<org.everit.json.schema.Schema> concat(Collection<org.everit.json.schema.Schema> previous, Collection<org.everit.json.schema.Schema> current) {
            ArrayList<org.everit.json.schema.Schema> schemas = new ArrayList<org.everit.json.schema.Schema>(previous);
            schemas.addAll(current);
            return schemas;
        }

        private List<org.everit.json.schema.Schema> flatten(org.everit.json.schema.Schema schema2) {
            if (SchemaUtils.isSyntheticAll(schema2)) {
                CombinedSchema combinedSchema = (CombinedSchema)schema2;
                return new ArrayList<org.everit.json.schema.Schema>(combinedSchema.getSubschemas());
            }
            return Collections.singletonList(schema2);
        }

        @Override
        public void close() {
            while (!SchemaTranslator.this.refMapping.isEmpty()) {
                Pair pair = (Pair)SchemaTranslator.this.refMapping.poll();
                org.everit.json.schema.ReferenceSchema refSchema = (org.everit.json.schema.ReferenceSchema)pair.component1();
                Schema oldReferredSchema = (Schema)pair.component2();
                Schema.Builder referredSchema = (Schema.Builder)SchemaTranslator.this.schemaMapping.get(oldReferredSchema);
                if (referredSchema != null) {
                    refSchema.setReferredSchema((org.everit.json.schema.Schema)referredSchema.build());
                    continue;
                }
                SchemaContext ctx2 = oldReferredSchema.accept(SchemaTranslator.this);
                assert (ctx2 != null);
                ctx2.close();
                refSchema.setReferredSchema(ctx2.schema());
            }
        }
    }

    static class JsonValueVisitor
    implements JsonVisitor<Object> {
        JsonValueVisitor() {
        }

        @Override
        public Object accumulate(Object previous, Object current) {
            return current != null ? current : previous;
        }

        @Override
        public Object identity() {
            return null;
        }

        @Override
        public Object visitArray(IJsonArray<?> arr) {
            return objectMapper.convertValue(arr, JSONArray.class);
        }

        @Override
        public Object visitBoolean(IJsonBoolean bool) {
            return bool.getValue();
        }

        @Override
        public Object visitNull(IJsonNull nil) {
            return null;
        }

        @Override
        public Object visitNumber(IJsonNumber num) {
            return num.getValue();
        }

        @Override
        public Object visitObject(IJsonObject<?, ?> obj) {
            return objectMapper.convertValue(obj, JSONObject.class);
        }

        @Override
        public Object visitString(IJsonString str) {
            return str.getValue();
        }
    }
}

