/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import io.confluent.kafka.schemaregistry.json.JsonSchemaComparator;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import java.util.Comparator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;

public class JsonNodeComparator
implements Comparator<JsonNode> {
    private static final JsonSchemaComparator jsonSchemaComparator = new JsonSchemaComparator();
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    @Override
    public int compare(JsonNode o1, JsonNode o2) {
        if (o1 == null) {
            if (o2 != null) {
                return -1;
            }
            return 0;
        }
        if (o2 == null) {
            return 1;
        }
        try {
            Object schema1 = SchemaLoader.builder().schemaJson(objectMapper.readValue(o1.toString(), JSONObject.class)).build().load().build();
            Object schema2 = SchemaLoader.builder().schemaJson(objectMapper.readValue(o2.toString(), JSONObject.class)).build().load().build();
            return jsonSchemaComparator.compare((Schema)schema1, (Schema)schema2);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot parse Json Schema from JsonNode", e);
        }
    }
}

