/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.json;

import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import kafka.common.MessageReader;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.everit.json.schema.ValidationException;

public class JsonSchemaMessageReader
extends SchemaMessageReader<JsonNode>
implements MessageReader {
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    public JsonSchemaMessageReader() {
    }

    JsonSchemaMessageReader(String url, JsonSchema keySchema, JsonSchema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean normalizeSchema, boolean autoRegister, boolean useLatest) {
        super(url, keySchema, valueSchema, topic, parseKey, reader, normalizeSchema, autoRegister, useLatest);
    }

    @Override
    protected SchemaMessageSerializer<JsonNode> createSerializer(Serializer keySerializer) {
        return new JsonSchemaMessageSerializer(keySerializer);
    }

    @Override
    protected SchemaProvider getProvider() {
        return new JsonSchemaProvider();
    }

    @Override
    protected JsonNode readFrom(String jsonString, ParsedSchema schema2) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (IOException | ValidationException e) {
            throw new SerializationException(String.format("Error serializing json %s", jsonString), e);
        }
    }

    static class JsonSchemaMessageSerializer
    extends AbstractKafkaJsonSchemaSerializer<JsonNode>
    implements SchemaMessageSerializer<JsonNode> {
        protected final Serializer keySerializer;

        JsonSchemaMessageSerializer(Serializer keySerializer) {
            this.keySerializer = keySerializer;
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            if (!configs.containsKey("json.fail.invalid.schema")) {
                configs.put("json.fail.invalid.schema", "true");
            }
            this.configure(new KafkaJsonSchemaSerializerConfig(configs));
        }

        @Override
        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        @Override
        public byte[] serializeKey(String topic, Headers headers, Object payload) {
            return this.keySerializer.serialize(topic, headers, payload);
        }

        @Override
        public byte[] serialize(String subject, String topic, boolean isKey, Headers headers, JsonNode object, ParsedSchema schema2) {
            return super.serializeImpl(subject, topic, headers, object, (JsonSchema)schema2);
        }

        @Override
        public SchemaRegistryClient getSchemaRegistryClient() {
            return this.schemaRegistry;
        }

        @Override
        public void close() throws IOException {
            if (this.keySerializer != null) {
                this.keySerializer.close();
            }
            super.close();
        }
    }
}

