/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.FormatKt;
import com.github.erosb.jsonsKema.FormatSchema;
import com.github.erosb.jsonsKema.FormatValidationFailure;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.LoadingContext;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.ValidationFailure;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"J\u0010\n\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"J\u0010\u0016\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"J\u0010\u0018\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"J\u0010\u001a\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\"5\u0010\u001c\u001a#\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001dj\u0002`!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\"J\u0010$\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0015\"J\u0010&\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015\"J\u0010(\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0015\"J\u0010*\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0015\"J\u0010,\u001a8\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0015*n\u00102\"4\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b24\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b\u00a8\u00063"}, d2={"DATE_TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "MAX_OFFSET_MIN", "", "MIN_OFFSET_MIN", "TIME_FORMATTER", "kotlin.jvm.PlatformType", "allowedIpv6Chars", "", "", "dateFormatValidator", "Lkotlin/Function2;", "Lcom/github/erosb/jsonsKema/IJsonValue;", "Lkotlin/ParameterName;", "name", "instance", "Lcom/github/erosb/jsonsKema/FormatSchema;", "schema", "Lcom/github/erosb/jsonsKema/ValidationFailure;", "Lcom/github/erosb/jsonsKema/FormatValidator;", "getDateFormatValidator", "()Lkotlin/jvm/functions/Function2;", "dateTimeFormatValidator", "getDateTimeFormatValidator", "durationFormatValidator", "getDurationFormatValidator", "emailFormatValidator", "getEmailFormatValidator", "formatLoader", "Lkotlin/Function1;", "Lcom/github/erosb/jsonsKema/LoadingContext;", "context", "Lcom/github/erosb/jsonsKema/Schema;", "Lcom/github/erosb/jsonsKema/KeywordLoader;", "getFormatLoader", "()Lkotlin/jvm/functions/Function1;", "ipv4FormatValidator", "getIpv4FormatValidator", "ipv6FormatValidator", "getIpv6FormatValidator", "timeFormatValidator", "getTimeFormatValidator", "uriFormatValidator", "getUriFormatValidator", "uuidFormatValidator", "getUuidFormatValidator", "validateDateTime", "Lcom/github/erosb/jsonsKema/FormatValidationFailure;", "str", "Lcom/github/erosb/jsonsKema/IJsonString;", "FormatValidator", "json-sKema"})
public final class FormatKt {
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> dateFormatValidator = dateFormatValidator.1.INSTANCE;
    @NotNull
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> dateTimeFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> uriFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> emailFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> ipv4FormatValidator;
    @NotNull
    private static final Set<Character> allowedIpv6Chars;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> ipv6FormatValidator;
    private static final DateTimeFormatter TIME_FORMATTER;
    private static final int MAX_OFFSET_MIN = 1439;
    private static final int MIN_OFFSET_MIN = -1439;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> timeFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> uuidFormatValidator;
    @NotNull
    private static final Function2<IJsonValue, FormatSchema, ValidationFailure> durationFormatValidator;
    @NotNull
    private static final Function1<LoadingContext, Schema> formatLoader;

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getDateFormatValidator() {
        return dateFormatValidator;
    }

    private static final FormatValidationFailure validateDateTime(IJsonString str, FormatSchema schema2) {
        try {
            String string = str.getValue().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            DATE_TIME_FORMATTER.parse(string);
            ZonedDateTime.parse(str.getValue());
        }
        catch (DateTimeParseException e) {
            String string = e.getMessage();
            if ((string != null ? StringsKt.indexOf$default((CharSequence)string, "Invalid value for SecondOfMinute", 0, false, 6, null) : -1) > -1 && StringsKt.indexOf$default((CharSequence)str.getValue(), "23:59:60", 0, false, 6, null) > -1) {
                JsonString sanitized = new JsonString(StringsKt.replace$default(str.getValue(), "23:59:60", "23:59:59", false, 4, null), str.getLocation());
                return FormatKt.validateDateTime(sanitized, schema2);
            }
            return new FormatValidationFailure(schema2, str);
        }
        return null;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getDateTimeFormatValidator() {
        return dateTimeFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getUriFormatValidator() {
        return uriFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getEmailFormatValidator() {
        return emailFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getIpv4FormatValidator() {
        return ipv4FormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getIpv6FormatValidator() {
        return ipv6FormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getTimeFormatValidator() {
        return timeFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getUuidFormatValidator() {
        return uuidFormatValidator;
    }

    @NotNull
    public static final Function2<IJsonValue, FormatSchema, ValidationFailure> getDurationFormatValidator() {
        return durationFormatValidator;
    }

    @NotNull
    public static final Function1<LoadingContext, Schema> getFormatLoader() {
        return formatLoader;
    }

    public static final /* synthetic */ FormatValidationFailure access$validateDateTime(IJsonString str, FormatSchema schema2) {
        return FormatKt.validateDateTime(str, schema2);
    }

    public static final /* synthetic */ Set access$getAllowedIpv6Chars$p() {
        return allowedIpv6Chars;
    }

    public static final /* synthetic */ DateTimeFormatter access$getTIME_FORMATTER$p() {
        return TIME_FORMATTER;
    }

    static {
        boolean bl = false;
        DateTimeFormatter secondsFractionFormatter = new DateTimeFormatterBuilder().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).toFormatter();
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendOptional(secondsFractionFormatter).appendPattern("XXX").toFormatter().withResolverStyle(ResolverStyle.STRICT);
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "run(...)");
        DATE_TIME_FORMATTER = dateTimeFormatter;
        dateTimeFormatValidator = dateTimeFormatValidator.1.INSTANCE;
        uriFormatValidator = uriFormatValidator.1.INSTANCE;
        emailFormatValidator = emailFormatValidator.1.INSTANCE;
        ipv4FormatValidator = ipv4FormatValidator.1.INSTANCE;
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf(':')};
        allowedIpv6Chars = SetsKt.plus(SetsKt.plus(SetsKt.plus(SetsKt.setOf(characterArray), new CharRange('0', '9')), new CharRange('a', 'f')), new CharRange('A', 'F'));
        ipv6FormatValidator = ipv6FormatValidator.1.INSTANCE;
        TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:MM", "Z").parseLenient().toFormatter();
        timeFormatValidator = timeFormatValidator.1.INSTANCE;
        uuidFormatValidator = uuidFormatValidator.1.INSTANCE;
        durationFormatValidator = durationFormatValidator.1.INSTANCE;
        formatLoader = formatLoader.1.INSTANCE;
    }
}

