/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.standalone;

import java.util.ArrayList;
import java.util.Map;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.plugin.ingestion.batch.common.BaseSegmentPushJobRunner;
import org.apache.pinot.segment.local.utils.ConsistentDataPushUtils;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;

public class SegmentTarPushJobRunner
extends BaseSegmentPushJobRunner {
    public SegmentTarPushJobRunner() {
    }

    public SegmentTarPushJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    @Override
    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
        if (this._spec.getTableSpec() == null) {
            throw new RuntimeException("Missing tableSpec");
        }
        if (this._spec.getTableSpec().getTableConfigURI() != null) {
            this._tableConfig = SegmentGenerationUtils.getTableConfig((String)this._spec.getTableSpec().getTableConfigURI(), (String)spec.getAuthToken());
            this._consistentPushEnabled = ConsistentDataPushUtils.consistentDataPushEnabled((TableConfig)this._tableConfig);
        }
    }

    @Override
    public void uploadSegments(Map<String, String> segmentsUriToTarPathMap) throws AttemptsExceededException, RetriableOperationException {
        SegmentPushUtils.pushSegments((SegmentGenerationJobSpec)this._spec, (PinotFS)this._outputDirFS, new ArrayList<String>(segmentsUriToTarPathMap.values()));
    }
}

