/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XPath
extends EvalFunc<String> {
    private javax.xml.xpath.XPath xpath = null;
    private String xml = null;
    private Document document;
    private static boolean cache = true;
    private static boolean ignoreNamespace = true;

    public String exec(Tuple input) throws IOException {
        if (!this.isArgsValid(input)) {
            return null;
        }
        try {
            String xml = (String)input.get(0);
            if (xml == null) {
                return null;
            }
            if (input.size() > 2) {
                cache = (Boolean)input.get(2);
            }
            if (input.size() > 3) {
                ignoreNamespace = (Boolean)input.get(3);
            }
            if (!cache || this.xpath == null || !xml.equals(this.xml)) {
                InputSource source = new InputSource(new StringReader(xml));
                this.xml = xml;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(!ignoreNamespace);
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.document = db.parse(source);
                XPathFactory xpathFactory = XPathFactory.newInstance();
                this.xpath = xpathFactory.newXPath();
                if (!ignoreNamespace) {
                    this.xpath.setNamespaceContext(new NamespaceContext(){

                        @Override
                        public String getNamespaceURI(String prefix) {
                            if (prefix.equals("")) {
                                return XPath.this.document.lookupNamespaceURI(null);
                            }
                            return XPath.this.document.lookupNamespaceURI(prefix);
                        }

                        @Override
                        public String getPrefix(String namespaceURI) {
                            return XPath.this.document.lookupPrefix(namespaceURI);
                        }

                        public Iterator getPrefixes(String namespaceURI) {
                            return null;
                        }
                    });
                }
            }
            String xpathString = (String)input.get(1);
            String value = this.xpath.evaluate(xpathString, this.document);
            return value;
        }
        catch (Exception e) {
            this.warn("Error processing input " + input.getType(0), (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
    }

    private boolean isArgsValid(Tuple input) {
        if (input == null || input.size() <= 1) {
            this.warn("Error processing input, not enough parameters or null input" + input, (Enum)PigWarning.UDF_WARNING_1);
            return false;
        }
        if (input.size() > 4) {
            this.warn("Error processing input, too many parameters" + input, (Enum)PigWarning.UDF_WARNING_1);
            return false;
        }
        try {
            if (input.size() > 2 && !(input.get(2) instanceof Boolean)) {
                this.warn("Error processing input, invalid value in 3rd parameter" + input, (Enum)PigWarning.UDF_WARNING_1);
                return false;
            }
            if (input.size() > 3 && !(input.get(3) instanceof Boolean)) {
                this.warn("Error processing input, invalid value in 4th parameter" + input, (Enum)PigWarning.UDF_WARNING_1);
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>();
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 55));
        Schema twoArgInSchema = new Schema(fields);
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), twoArgInSchema));
        fields = new ArrayList();
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 5));
        Schema threeArgInSchema = new Schema(fields);
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), threeArgInSchema));
        fields = new ArrayList();
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 5));
        fields.add(new Schema.FieldSchema(null, 5));
        Schema fourArgInSchema = new Schema(fields);
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), fourArgInSchema));
        return funcList;
    }
}

