/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.monitoring;

import opennlp.tools.monitoring.StopCriteria;
import opennlp.tools.util.Parameters;

public class IterDeltaAccuracyUnderTolerance
implements StopCriteria<Double> {
    public static final String STOP = "Stopping: change in training set accuracy less than {%s}";
    private final Parameters trainingParameters;

    public IterDeltaAccuracyUnderTolerance(Parameters trainingParameters) {
        this.trainingParameters = trainingParameters;
    }

    public String getMessageIfSatisfied() {
        return String.format(STOP, this.getTolerance());
    }

    public boolean test(Double deltaAccuracy) {
        return StrictMath.abs(deltaAccuracy) < this.getTolerance();
    }

    private double getTolerance() {
        return this.trainingParameters != null ? this.trainingParameters.getDoubleParameter("Tolerance", 1.0E-5) : 1.0E-5;
    }
}

