/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.netpreserve.jwarc.ConcurrentRecordSet;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;

public class ExtractTool {
    private static void writeWarcHeaders(WritableByteChannel out, WarcRecord record) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(record.version().toString()).append("\r\n");
        record.headers().appendTo(sb);
        sb.append("\r\n");
        out.write(ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static void writeHttpHeaders(WritableByteChannel out, WarcRecord record) throws IOException {
        if (record instanceof WarcResponse) {
            HttpResponse response = ((WarcResponse)record).http();
            out.write(ByteBuffer.wrap(response.serializeHeader()));
        } else if (record instanceof WarcRequest) {
            HttpRequest request = ((WarcRequest)record).http();
            out.write(ByteBuffer.wrap(request.serializeHeader()));
        }
    }

    private static void writePayload(WritableByteChannel out, WarcRecord record) throws IOException {
        try {
            MessageBody payload;
            if (record instanceof WarcResponse) {
                if (record.contentType().base().equals(MediaType.HTTP)) {
                    HttpResponse response = ((WarcResponse)record).http();
                    payload = response.bodyDecoded();
                } else {
                    payload = ((WarcResponse)record).payload().map(WarcPayload::body).orElse(MessageBody.empty());
                }
            } else if (record instanceof WarcRequest) {
                if (record.contentType().base().equals(MediaType.HTTP)) {
                    HttpRequest request = ((WarcRequest)record).http();
                    payload = request.bodyDecoded();
                } else {
                    payload = ((WarcRequest)record).payload().map(WarcPayload::body).orElse(MessageBody.empty());
                }
            } else {
                payload = record.body();
            }
            ExtractTool.writeBody(out, payload);
        }
        catch (IOException e) {
            System.err.println("Failed to read payload: " + e.getMessage());
        }
    }

    private static void writeBody(WritableByteChannel out, ReadableByteChannel body) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while (body.read(buffer) > -1) {
            buffer.flip();
            out.write(buffer);
            buffer.compact();
        }
    }

    private static void usage(int exitValue) {
        System.err.println();
        System.err.println("ExtractTool [-h] [--payload | --headers] filename offset ...");
        System.err.println();
        System.err.println("Options:");
        System.err.println();
        System.err.println(" --concurrent\talso outputs any immediately following concurrent records");
        System.err.println(" --headers\toutput only record (and HTTP) headers");
        System.err.println(" --payload\toutput only record payload, if necessary");
        System.err.println("          \tdecode transfer and/or content encoding");
        System.exit(exitValue);
    }

    public static void main(String[] args) throws IOException {
        ExtractAction action = ExtractAction.RECORD;
        Path warcFile = null;
        ArrayList<Long> offsets = new ArrayList<Long>();
        boolean extractConcurrent = false;
        String[] stringArray = args;
        int n = stringArray.length;
        block25: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-h": 
                case "--help": {
                    ExtractTool.usage(0);
                    continue block25;
                }
                case "--concurrent": {
                    extractConcurrent = true;
                    continue block25;
                }
                case "--headers": {
                    action = ExtractAction.HEADERS;
                    continue block25;
                }
                case "--payload": {
                    action = ExtractAction.PAYLOAD;
                    continue block25;
                }
                default: {
                    if (warcFile == null) {
                        warcFile = Paths.get(arg, new String[0]);
                        if (warcFile.toFile().canRead()) continue block25;
                        System.err.println("Cannot read WARC file: " + warcFile);
                        ExtractTool.usage(1);
                        continue block25;
                    }
                    if (arg.startsWith("-")) {
                        System.err.println("Unknown argument: " + arg);
                        ExtractTool.usage(1);
                        continue block25;
                    }
                    try {
                        offsets.add(Long.parseLong(arg));
                        continue block25;
                    }
                    catch (NumberFormatException e) {
                        System.err.println(e.getMessage());
                        ExtractTool.usage(1);
                    }
                }
            }
        }
        if (warcFile == null || offsets.isEmpty()) {
            ExtractTool.usage(1);
            return;
        }
        WritableByteChannel out = Channels.newChannel(System.out);
        Iterator iterator = offsets.iterator();
        block26: while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            FileChannel channel = FileChannel.open(warcFile, new OpenOption[0]);
            try (WarcReader reader = new WarcReader(channel.position(offset));){
                Optional<WarcRecord> record = reader.next();
                if (!record.isPresent()) {
                    System.err.println("No record found at position " + offset);
                    System.exit(1);
                }
                ExtractTool.writeRecord(record.get(), out, action);
                if (!extractConcurrent) continue;
                ConcurrentRecordSet concurrentSet = new ConcurrentRecordSet();
                while (true) {
                    concurrentSet.add(record.get());
                    record = reader.next();
                    if (!record.isPresent() || !concurrentSet.contains(record.get())) continue block26;
                    ExtractTool.writeRecord(record.get(), out, action);
                }
            }
            finally {
                if (channel == null) continue;
                channel.close();
            }
        }
    }

    private static void writeRecord(WarcRecord record, WritableByteChannel out, ExtractAction action) throws IOException {
        switch (action.ordinal()) {
            case 0: {
                ExtractTool.writeWarcHeaders(out, record);
                ExtractTool.writeBody(out, record.body());
                out.write(ByteBuffer.wrap("\r\n\r\n".getBytes(StandardCharsets.US_ASCII)));
                break;
            }
            case 1: {
                ExtractTool.writeWarcHeaders(out, record);
                ExtractTool.writeHttpHeaders(out, record);
                break;
            }
            case 2: {
                ExtractTool.writePayload(out, record);
            }
        }
    }

    private static enum ExtractAction {
        RECORD,
        HEADERS,
        PAYLOAD;

    }
}

