/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.email;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.basic.MailMessageDao;
import org.apache.openmeetings.db.entity.basic.MailMessage;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.email.EmailForm;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class EmailPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer list = new WebMarkupContainer("list");
    private final EmailForm form;

    public EmailPanel(String id) {
        super(id);
        SearchableDataView<MailMessage> dataView = new SearchableDataView<MailMessage>("email", new SearchableDataProvider(MailMessageDao.class)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<MailMessage> item) {
                MailMessage m = (MailMessage)item.getModelObject();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new Label("status", (Serializable)((Object)this.getString("admin.email.status." + m.getStatus().name())))});
                item.add(new Component[]{new Label("subject")});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    EmailPanel.this.form.setModelObject(m);
                    target.add(new Component[]{EmailPanel.this.form, EmailPanel.this.list});
                })});
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)EmailPanel.this.getRowClass(m))});
            }
        };
        this.add(new Component[]{this.list.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{EmailPanel.this.list});
            }
        };
        DataViewContainer<MailMessage> container = new DataViewContainer<MailMessage>(this.list, dataView, navigator);
        container.addLink(new OmOrderByBorder<MailMessage>("orderById", "id", container)).addLink(new OmOrderByBorder<MailMessage>("orderBySubject", "subject", container)).addLink(new OmOrderByBorder<MailMessage>("orderByStatus", "status", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
        this.form = new EmailForm("form", this.list, new MailMessage());
        this.add(new Component[]{this.form});
    }

    private StringBuilder getRowClass(MailMessage m) {
        StringBuilder sb = this.getRowClass(m.getId(), ((MailMessage)this.form.getModelObject()).getId());
        if (MailMessage.Status.ERROR == m.getStatus()) {
            sb.append(" bg-warning");
        }
        return sb;
    }
}

