/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.cancel;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelRequestContainer;
import org.apache.directory.api.ldap.extras.extended.cancel.CancelRequest;
import org.apache.directory.api.ldap.extras.extended.cancel.CancelRequestImpl;
import org.apache.directory.api.ldap.extras.extended.cancel.CancelResponse;
import org.apache.directory.api.ldap.extras.extended.cancel.CancelResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;

public class CancelFactory
extends AbstractExtendedOperationFactory {
    public CancelFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.1.8");
    }

    @Override
    public CancelRequest newRequest() {
        return new CancelRequestImpl();
    }

    @Override
    public CancelRequest newRequest(byte[] encodedValue) throws DecoderException {
        CancelRequestImpl cancelRequest = new CancelRequestImpl();
        this.decodeValue(cancelRequest, encodedValue);
        return cancelRequest;
    }

    @Override
    public CancelResponse newResponse() {
        return new CancelResponseImpl();
    }

    @Override
    public void decodeValue(ExtendedRequest extendedRequest, byte[] requestValue) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(requestValue);
        CancelRequestContainer container = new CancelRequestContainer();
        container.setCancelRequest((CancelRequest)extendedRequest);
        Asn1Decoder.decode(bb, container);
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, ExtendedRequest extendedRequest) {
        int start = buffer.getPos();
        CancelRequest cancelRequest = (CancelRequest)extendedRequest;
        BerValue.encodeInteger(buffer, cancelRequest.getCancelId());
        BerValue.encodeSequence(buffer, start);
    }
}

