/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileSinkBuilder<T> {
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    public static final long DISABLE_ROLLING = Long.MAX_VALUE;
    private final String directoryName;
    private FunctionEx<? super T, String> toStringFn = Object::toString;
    private Charset charset = StandardCharsets.UTF_8;
    private String datePattern;
    private long maxFileSize = Long.MAX_VALUE;
    private boolean exactlyOnce = true;

    FileSinkBuilder(@Nonnull String directoryName) {
        this.directoryName = directoryName;
    }

    @Nonnull
    public FileSinkBuilder<T> toStringFn(@Nonnull FunctionEx<? super T, String> toStringFn) {
        this.toStringFn = toStringFn;
        return this;
    }

    @Nonnull
    public FileSinkBuilder<T> charset(@Nonnull Charset charset) {
        this.charset = charset;
        return this;
    }

    @Nonnull
    public FileSinkBuilder<T> rollByDate(@Nullable String datePattern) {
        this.datePattern = datePattern;
        return this;
    }

    @Nonnull
    public FileSinkBuilder<T> rollByFileSize(long maxFileSize) {
        Preconditions.checkPositive(1.0, "rolling size must be a positive number");
        this.maxFileSize = maxFileSize;
        return this;
    }

    @Nonnull
    public FileSinkBuilder<T> exactlyOnce(boolean enable) {
        this.exactlyOnce = enable;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        return Sinks.fromProcessor("filesSink(" + this.directoryName + ")", SinkProcessors.writeFileP(this.directoryName, this.charset, this.datePattern, this.maxFileSize, this.exactlyOnce, this.toStringFn));
    }
}

