/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.concurrent.ManyToOneConcurrentArrayQueue;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.impl.processor.AbstractAsyncTransformUsingServiceP;
import com.hazelcast.jet.impl.processor.ProcessorSupplierWithService;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AsyncTransformUsingServiceUnorderedP<C, S, T, K, R>
extends AbstractAsyncTransformUsingServiceP<C, S> {
    private final BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<Traverser<R>>> callAsyncFn;
    private final Function<? super T, ? extends K> extractKeyFn;
    private ManyToOneConcurrentArrayQueue<Tuple3<T, long[], Object>> resultQueue;
    private SortedMap<Long, Integer>[] watermarkCounts = new SortedMap[0];
    private final Map<T, Integer> inFlightItems = new IdentityHashMap<T, Integer>();
    private Traverser<Object> currentTraverser = Traversers.empty();
    private Traverser<Map.Entry> snapshotTraverser;
    private byte[] wmKeys = new byte[0];
    private byte[] wmKeysInv = new byte[0];
    private long[] lastReceivedWms = new long[0];
    private long[] lastEmittedWms = new long[0];
    private long[] minRestoredWms = new long[0];
    private int asyncOpsCounter;
    private ArrayDeque<T> restoredObjects = new ArrayDeque();
    @Probe(name="numInFlightOps")
    private final Counter asyncOpsCounterMetric = SwCounter.newSwCounter();

    private AsyncTransformUsingServiceUnorderedP(@Nonnull ServiceFactory<C, S> serviceFactory, @Nullable C serviceContext, int maxConcurrentOps, @Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<Traverser<R>>> callAsyncFn, @Nonnull Function<? super T, ? extends K> extractKeyFn) {
        super(serviceFactory, serviceContext, maxConcurrentOps, false);
        this.callAsyncFn = callAsyncFn;
        this.extractKeyFn = extractKeyFn;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        super.init(context);
        this.resultQueue = new ManyToOneConcurrentArrayQueue(this.maxConcurrentOps);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        if (this.getOutbox().hasUnfinishedItem() && !this.emitFromTraverser(this.currentTraverser)) {
            return false;
        }
        this.asyncOpsCounterMetric.set(this.asyncOpsCounter);
        Object castItem = item;
        if (!this.processItem(castItem)) {
            this.tryFlushQueue();
            return false;
        }
        return true;
    }

    @CheckReturnValue
    private boolean processItem(@Nonnull T item) {
        if (this.asyncOpsCounter == this.maxConcurrentOps) {
            return false;
        }
        CompletableFuture<Traverser<R>> future = this.callAsyncFn.apply(this.service, item);
        if (future == null) {
            return true;
        }
        ++this.asyncOpsCounter;
        for (int i = 0; i < this.wmKeys.length; ++i) {
            this.watermarkCounts[i].merge(this.lastReceivedWms[i], 1, Integer::sum);
        }
        long[] lastWatermarksAtReceiveTime = this.lastReceivedWms;
        future.whenComplete(ExceptionUtil.withTryCatch(this.getLogger(), (r, e) -> this.resultQueue.add(Tuple3.tuple3(item, lastWatermarksAtReceiveTime, r != null ? r : e))));
        this.inFlightItems.merge(item, 1, Integer::sum);
        return true;
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        if (!this.emitFromTraverser(this.currentTraverser)) {
            return false;
        }
        int wmIndex = this.getWmIndex(watermark.key());
        assert (this.lastEmittedWms[wmIndex] <= this.lastReceivedWms[wmIndex]) : "lastEmittedWm=" + this.lastEmittedWms[wmIndex] + ", lastReceivedWm=" + this.lastReceivedWms[wmIndex];
        if (watermark.timestamp() <= this.lastReceivedWms[wmIndex]) {
            return true;
        }
        if (AsyncTransformUsingServiceUnorderedP.allEmpty((Map[])this.watermarkCounts)) {
            if (!this.tryEmit(watermark)) {
                return false;
            }
            this.lastEmittedWms[wmIndex] = watermark.timestamp();
        }
        this.lastReceivedWms = (long[])this.lastReceivedWms.clone();
        this.lastReceivedWms[wmIndex] = watermark.timestamp();
        return true;
    }

    private int getWmIndex(byte wmKey0) {
        int wmIndex;
        int newLength;
        int wmKey = wmKey0 & 0xFF;
        if (this.wmKeysInv.length <= wmKey) {
            int oldLength = this.wmKeysInv.length;
            newLength = wmKey + 1;
            this.wmKeysInv = Arrays.copyOf(this.wmKeysInv, newLength);
            for (int i = oldLength; i < newLength; ++i) {
                this.wmKeysInv[i] = -1;
            }
        }
        if ((wmIndex = this.wmKeysInv[wmKey]) < 0) {
            wmIndex = this.wmKeys.length;
            this.wmKeysInv[wmIndex] = wmKey0;
            newLength = this.wmKeys.length + 1;
            this.wmKeys = Arrays.copyOf(this.wmKeys, newLength);
            this.wmKeys[wmIndex] = (byte)wmKey;
            this.lastReceivedWms = Arrays.copyOf(this.lastReceivedWms, newLength);
            this.lastReceivedWms[wmIndex] = Long.MIN_VALUE;
            this.lastEmittedWms = Arrays.copyOf(this.lastEmittedWms, newLength);
            this.lastEmittedWms[wmIndex] = Long.MIN_VALUE;
            this.watermarkCounts = Arrays.copyOf(this.watermarkCounts, newLength);
            this.watermarkCounts[wmIndex] = new TreeMap<Long, Integer>();
            if (this.asyncOpsCounter > 0) {
                this.watermarkCounts[wmIndex].put(Long.MIN_VALUE, this.asyncOpsCounter);
            }
            this.minRestoredWms = Arrays.copyOf(this.minRestoredWms, newLength);
            this.minRestoredWms[wmIndex] = Long.MAX_VALUE;
        }
        return wmIndex;
    }

    @Override
    public boolean tryProcess() {
        this.tryFlushQueue();
        this.asyncOpsCounterMetric.set(this.asyncOpsCounter);
        return true;
    }

    @Override
    public boolean complete() {
        return this.tryFlushQueue();
    }

    @Override
    public boolean saveToSnapshot() {
        assert (this.restoredObjects.isEmpty()) : "restoredObjects not empty";
        if (!this.emitFromTraverser(this.currentTraverser)) {
            return false;
        }
        if (this.snapshotTraverser == null) {
            HashMap<Byte, Long> lastReceivedWmsMap = new HashMap<Byte, Long>();
            for (int i = 0; i < this.lastReceivedWms.length; ++i) {
                lastReceivedWmsMap.put(this.wmKeys[i], this.lastReceivedWms[i]);
            }
            this.getLogger().finest("Saving to snapshot: %s, lastReceivedWm=%s", this.inFlightItems, lastReceivedWmsMap);
            this.snapshotTraverser = Traversers.traverseIterable(this.inFlightItems.entrySet()).map(en -> Util.entry(this.extractKeyFn.apply(en.getKey()), Tuple2.tuple2(en.getKey(), (Integer)en.getValue()))).append(Util.entry(BroadcastKey.broadcastKey(Keys.LAST_RECEIVED_WMS), lastReceivedWmsMap)).onFirstNull(() -> {
                this.snapshotTraverser = null;
            });
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    @Override
    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (key instanceof BroadcastKey) {
            BroadcastKey broadcastKey = (BroadcastKey)key;
            assert (broadcastKey.key().equals((Object)Keys.LAST_RECEIVED_WMS)) : "Unexpected key: " + key;
            for (Map.Entry en : ((Map)value).entrySet()) {
                int wmIndex = this.getWmIndex((Byte)en.getKey());
                this.minRestoredWms[wmIndex] = Math.min(this.minRestoredWms[wmIndex], (Long)en.getValue());
            }
            return;
        }
        Tuple2 value1 = (Tuple2)value;
        assert (value1.f0() != null && value1.f1() != null);
        for (int i = 0; i < (Integer)value1.f1(); ++i) {
            this.restoredObjects.add(value1.f0());
            this.getLogger().finest("Restored: %s", value1.f0());
        }
    }

    @Override
    public boolean finishSnapshotRestore() {
        T t;
        while ((t = this.restoredObjects.peek()) != null && this.processItem(t)) {
            this.restoredObjects.remove();
        }
        if (this.restoredObjects.isEmpty()) {
            if (!this.emitFromTraverser(this.currentTraverser)) {
                return false;
            }
            this.restoredObjects = new ArrayDeque(0);
            this.lastReceivedWms = this.minRestoredWms;
            return true;
        }
        this.tryFlushQueue();
        return false;
    }

    private boolean tryFlushQueue() {
        block0: while (this.emitFromTraverser(this.currentTraverser)) {
            Tuple3<T, long[], Object> tuple = this.resultQueue.poll();
            if (tuple == null) {
                return this.asyncOpsCounter == 0;
            }
            assert (this.asyncOpsCounter > 0);
            --this.asyncOpsCounter;
            Integer inFlightItemsCount = this.inFlightItems.compute(tuple.f0(), (k, v) -> v == 1 ? null : Integer.valueOf(v - 1));
            assert (inFlightItemsCount == null || inFlightItemsCount > 0) : "inFlightItemsCount=" + inFlightItemsCount;
            Object object = tuple.f2();
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                throw new JetException("Async operation completed exceptionally: " + throwable, throwable);
            }
            this.currentTraverser = (Traverser)tuple.f2();
            if (this.currentTraverser == null) {
                this.currentTraverser = Traversers.empty();
            }
            int i = 0;
            while (true) {
                if (i >= this.watermarkCounts.length) continue block0;
                SortedMap<Long, Integer> watermarkCount = this.watermarkCounts[i];
                assert (tuple.f1() != null);
                long wmAtReceiveTime = tuple.f1().length > i ? tuple.f1()[i] : Long.MIN_VALUE;
                int count = watermarkCount.merge(wmAtReceiveTime, -1, Integer::sum);
                assert (count >= 0) : "count=" + count;
                if (count <= 0) {
                    long wmToEmit = Long.MIN_VALUE;
                    Iterator<Map.Entry<Long, Integer>> it = watermarkCount.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Long, Integer> entry = it.next();
                        if (entry.getValue() != 0) {
                            wmToEmit = entry.getKey();
                            break;
                        }
                        it.remove();
                    }
                    if (watermarkCount.isEmpty() && this.lastReceivedWms[i] > this.lastEmittedWms[i]) {
                        wmToEmit = this.lastReceivedWms[i];
                    }
                    if (wmToEmit > Long.MIN_VALUE && wmToEmit > this.lastEmittedWms[i]) {
                        this.lastEmittedWms[i] = wmToEmit;
                        this.currentTraverser = this.currentTraverser.append(new Watermark(wmToEmit, this.wmKeys[i]));
                    }
                }
                ++i;
            }
            break;
        }
        return false;
    }

    public static <C, S, T, K, R> ProcessorSupplier supplier(@Nonnull ServiceFactory<C, S> serviceFactory, int maxConcurrentOps, @Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<Traverser<R>>> callAsyncFn, @Nonnull FunctionEx<? super T, ? extends K> extractKeyFn) {
        return ProcessorSupplierWithService.supplierWithService(serviceFactory, (serviceFn, context) -> new AsyncTransformUsingServiceUnorderedP(serviceFn, context, maxConcurrentOps, callAsyncFn, extractKeyFn));
    }

    private static <T extends Map<?, ?>> boolean allEmpty(T[] collections) {
        for (T c : collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static enum Keys {
        LAST_RECEIVED_WMS;

    }
}

