/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.internal.util.Preconditions;
import java.io.File;
import java.util.Objects;

public class JavaKeyStoreSecureStoreConfig
extends SecureStoreConfig {
    public static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    public static final int DEFAULT_POLLING_INTERVAL = 0;
    private File path;
    private String type = "PKCS12";
    private String password;
    private String currentKeyAlias;
    private int pollingInterval = 0;

    public JavaKeyStoreSecureStoreConfig() {
    }

    public JavaKeyStoreSecureStoreConfig(File path) {
        Preconditions.checkNotNull(path, "Java Key Store path cannot be null!");
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public JavaKeyStoreSecureStoreConfig setType(String type) {
        Preconditions.checkNotNull(type, "Java Key Store type cannot be null!");
        this.type = type;
        return this;
    }

    public File getPath() {
        return this.path;
    }

    public JavaKeyStoreSecureStoreConfig setPath(File path) {
        Preconditions.checkNotNull(path, "Java Key Store path cannot be null!");
        this.path = path;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public JavaKeyStoreSecureStoreConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getCurrentKeyAlias() {
        return this.currentKeyAlias;
    }

    public JavaKeyStoreSecureStoreConfig setCurrentKeyAlias(String currentKeyAlias) {
        this.currentKeyAlias = currentKeyAlias;
        return this;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public JavaKeyStoreSecureStoreConfig setPollingInterval(int pollingInterval) {
        Preconditions.checkNotNegative(pollingInterval, "Polling interval cannot be negative!");
        this.pollingInterval = pollingInterval;
        return this;
    }

    public String toString() {
        return "JavaKeyStoreSecureStoreConfig{path='" + this.path + "', type='" + this.type + "', pollingInterval='" + this.pollingInterval + "', currentKeyAlias='" + this.currentKeyAlias + "', password='***'}";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaKeyStoreSecureStoreConfig)) {
            return false;
        }
        JavaKeyStoreSecureStoreConfig other = (JavaKeyStoreSecureStoreConfig)o;
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.password, other.password)) {
            return false;
        }
        if (!Objects.equals(this.currentKeyAlias, other.currentKeyAlias)) {
            return false;
        }
        return this.pollingInterval == other.pollingInterval;
    }

    public final int hashCode() {
        int result = this.path == null ? 0 : this.path.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.currentKeyAlias == null ? 0 : this.currentKeyAlias.hashCode());
        result = 31 * result + this.pollingInterval;
        return result;
    }
}

