/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.QueryCacheEventDataCodec;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.querycache.event.DefaultQueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public final class ContinuousQueryAddListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1442816;
    public static final int RESPONSE_MESSAGE_TYPE = 1442817;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_QUERY_CACHE_SINGLE_INITIAL_FRAME_SIZE = 16;
    private static final int EVENT_QUERY_CACHE_SINGLE_MESSAGE_TYPE = 1442818;
    private static final int EVENT_QUERY_CACHE_BATCH_PARTITION_ID_FIELD_OFFSET = 16;
    private static final int EVENT_QUERY_CACHE_BATCH_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_QUERY_CACHE_BATCH_MESSAGE_TYPE = 1442819;

    private ContinuousQueryAddListenerCodec() {
    }

    public static ClientMessage encodeRequest(String listenerName, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("ContinuousQuery.AddListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1442816);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, listenerName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.listenerName = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1442817);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeQueryCacheSingleEvent(QueryCacheEventData data) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1442818);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        QueryCacheEventDataCodec.encode(clientMessage, data);
        return clientMessage;
    }

    public static ClientMessage encodeQueryCacheBatchEvent(Collection<QueryCacheEventData> events, String source, int partitionId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1442819);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, partitionId);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, events, QueryCacheEventDataCodec::encode);
        StringCodec.encode(clientMessage, source);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String listenerName;
        public boolean localOnly;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 1442818) {
                iterator.next();
                DefaultQueryCacheEventData data = QueryCacheEventDataCodec.decode(iterator);
                this.handleQueryCacheSingleEvent(data);
                return;
            }
            if (messageType == 1442819) {
                ClientMessage.Frame initialFrame = iterator.next();
                int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                List<QueryCacheEventData> events = ListMultiFrameCodec.decode(iterator, QueryCacheEventDataCodec::decode);
                String source = StringCodec.decode(iterator);
                this.handleQueryCacheBatchEvent(events, source, partitionId);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleQueryCacheSingleEvent(QueryCacheEventData var1);

        public abstract void handleQueryCacheBatchEvent(Collection<QueryCacheEventData> var1, String var2, int var3);
    }
}

