/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.IUpdatable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class InvitationPasswordDialog
extends Modal<Invitation> {
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final Form<Void> form = new Form("form");
    private final PasswordTextField password = new PasswordTextField("password", (IModel)Model.of((Serializable)((Object)((String)null))));
    private final IUpdatable comp;

    public InvitationPasswordDialog(String id, IUpdatable comp) {
        super(id);
        this.comp = comp;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("230"));
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        this.password.add((IValidator)new IValidator<String>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<String> validatable) {
                if (!CryptProvider.get().verify((String)validatable.getValue(), WebSession.get().getInvitation().getPassword())) {
                    validatable.error((IValidationError)new ValidationError(InvitationPasswordDialog.this.getString("error.bad.password")));
                }
            }
        });
        this.add(new Component[]{this.form.add(new Component[]{this.password, this.feedback.setOutputMarkupId(true)})});
        AjaxButton ab = new AjaxButton("submit", this.form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                InvitationPasswordDialog.this.onSubmit(target);
            }

            protected void onError(AjaxRequestTarget target) {
                InvitationPasswordDialog.this.onError(target);
            }
        };
        this.form.add(new Component[]{ab});
        this.form.setDefaultButton((IFormSubmittingComponent)ab);
        this.password.setLabel((IModel)new ResourceModel("110"));
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("537"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                InvitationPasswordDialog.this.onError(target);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                InvitationPasswordDialog.this.onSubmit(target);
            }
        });
        super.onInitialize();
        Invitation i = WebSession.get().getInvitation();
        this.show(i != null && i.isPasswordProtected());
    }

    public Modal<Invitation> show(IPartialPageRequestHandler handler) {
        this.password.setModelObject(null);
        return super.show(handler);
    }

    protected void onError(AjaxRequestTarget target) {
        target.add(new Component[]{this.feedback});
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.comp.update(target);
        this.close((IPartialPageRequestHandler)target);
    }
}

