/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.interaction.draggable;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.interaction.draggable.IDraggableListener;
import org.wicketstuff.jquery.ui.interaction.droppable.DroppableBehavior;

public class DraggableBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "draggable";
    private final IDraggableListener listener;
    private JQueryAjaxBehavior onDragStartAjaxBehavior;
    private JQueryAjaxBehavior onDragStopAjaxBehavior = null;
    private Component component = null;

    public DraggableBehavior(IDraggableListener listener) {
        this(null, new Options(), listener);
    }

    public DraggableBehavior(String selector, IDraggableListener listener) {
        this(selector, new Options(), listener);
    }

    public DraggableBehavior(Options options, IDraggableListener listener) {
        this(null, options, listener);
    }

    public DraggableBehavior(String selector, Options options, IDraggableListener listener) {
        super(selector, METHOD, options);
        this.listener = (IDraggableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.component != null) {
            throw new WicketRuntimeException("Behavior is already bound to another component.");
        }
        this.component = component;
        if (this.selector == null) {
            this.selector = IJQueryWidget.JQueryWidget.getSelector((Component)this.component);
        }
        this.onDragStartAjaxBehavior = this.newOnDragStartAjaxBehavior(this);
        this.component.add(new Behavior[]{this.onDragStartAjaxBehavior});
        if (this.listener.isStopEventEnabled()) {
            this.onDragStopAjaxBehavior = this.newOnDragStopAjaxBehavior(this);
            this.component.add(new Behavior[]{this.onDragStopAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("start", this.onDragStartAjaxBehavior.getCallbackFunction());
        if (this.onDragStopAjaxBehavior != null) {
            this.setOption("stop", this.onDragStopAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DraggableEvent) {
            DraggableEvent ev = (DraggableEvent)event;
            if (ev instanceof DragStartEvent) {
                Visits.visit((Iterable)target.getPage(), this.newDroppableBehaviorVisitor());
                this.listener.onDragStart(target, ev.getTop(), ev.getLeft());
            } else if (ev instanceof DragStopEvent) {
                this.listener.onDragStop(target, ev.getTop(), ev.getLeft());
            }
        }
    }

    private IVisitor<Component, ?> newDroppableBehaviorVisitor() {
        return (c, v) -> {
            for (DroppableBehavior behavior : c.getBehaviors(DroppableBehavior.class)) {
                behavior.setDraggable(this.component);
            }
        };
    }

    protected JQueryAjaxBehavior newOnDragStartAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDragStartAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnDragStopAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDragStopAjaxBehavior(source);
    }

    protected static class DraggableEvent
    extends JQueryEvent {
        private final int top = RequestCycleUtils.getQueryParameterValue((String)"top").toInt(-1);
        private final int left = RequestCycleUtils.getQueryParameterValue((String)"left").toInt(-1);
        private final int offsetTop = RequestCycleUtils.getQueryParameterValue((String)"offsetTop").toInt(-1);
        private final int offsetLeft = RequestCycleUtils.getQueryParameterValue((String)"offsetLeft").toInt(-1);

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getOffsetTop() {
            return this.offsetTop;
        }

        public int getOffsetLeft() {
            return this.offsetLeft;
        }
    }

    protected static class DragStartEvent
    extends DraggableEvent {
        protected DragStartEvent() {
        }
    }

    protected static class DragStopEvent
    extends DraggableEvent {
        protected DragStopEvent() {
        }
    }

    protected static class OnDragStartAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDragStartAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"top", (String)"ui.position.top | 0"), CallbackParameter.resolved((String)"left", (String)"ui.position.left | 0"), CallbackParameter.resolved((String)"offsetTop", (String)"ui.offset.top | 0"), CallbackParameter.resolved((String)"offsetLeft", (String)"ui.offset.left | 0")};
        }

        protected JQueryEvent newEvent() {
            return new DragStartEvent();
        }
    }

    protected static class OnDragStopAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDragStopAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"top", (String)"ui.position.top | 0"), CallbackParameter.resolved((String)"left", (String)"ui.position.left | 0"), CallbackParameter.resolved((String)"offsetTop", (String)"ui.offset.top | 0"), CallbackParameter.resolved((String)"offsetLeft", (String)"ui.offset.left | 0")};
        }

        protected JQueryEvent newEvent() {
            return new DragStopEvent();
        }
    }
}

