/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.JsonFileFormat;
import com.hazelcast.jet.pipeline.file.LinesTextFileFormat;
import com.hazelcast.jet.pipeline.file.TextFileFormat;
import com.hazelcast.jet.pipeline.file.impl.FileSourceConfiguration;
import com.hazelcast.jet.pipeline.file.impl.FileSourceFactory;
import com.hazelcast.jet.pipeline.file.impl.ReadFileFnProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class LocalFileSourceFactory
implements FileSourceFactory {
    private static Map<String, ReadFileFnProvider> readFileFnProviders;

    private static void addMapFnProvider(Map<String, ReadFileFnProvider> mapFns, ReadFileFnProvider provider) {
        mapFns.put(provider.format(), provider);
    }

    @Override
    @Nonnull
    public <T> ProcessorMetaSupplier create(@Nonnull FileSourceConfiguration<T> fsc) {
        FileFormat<T> format = Objects.requireNonNull(fsc.getFormat());
        ReadFileFnProvider readFileFnProvider = readFileFnProviders.get(format.format());
        if (readFileFnProvider == null) {
            throw new JetException("Could not find ReadFileFnProvider for FileFormat: " + format.format() + ". Did you provide correct modules on classpath?");
        }
        FunctionEx<Path, Stream<T>> mapFn = readFileFnProvider.createReadFileFn(format);
        return SourceProcessors.readFilesP(fsc.getPath(), fsc.getGlob(), fsc.isSharedFileSystem(), fsc.isIgnoreFileNotFound(), mapFn);
    }

    static {
        HashMap<String, ReadFileFnProvider> mapFns = new HashMap<String, ReadFileFnProvider>();
        LocalFileSourceFactory.addMapFnProvider(mapFns, new JsonReadFileFnProvider());
        LocalFileSourceFactory.addMapFnProvider(mapFns, new LinesReadFileFnProvider());
        LocalFileSourceFactory.addMapFnProvider(mapFns, new ParquetReadFileFnProvider());
        LocalFileSourceFactory.addMapFnProvider(mapFns, new RawBytesReadFileFnProvider());
        LocalFileSourceFactory.addMapFnProvider(mapFns, new TextReadFileFnProvider());
        ServiceLoader<ReadFileFnProvider> loader = ServiceLoader.load(ReadFileFnProvider.class);
        for (ReadFileFnProvider readFileFnProvider : loader) {
            LocalFileSourceFactory.addMapFnProvider(mapFns, readFileFnProvider);
        }
        readFileFnProviders = Collections.unmodifiableMap(mapFns);
    }

    private static class JsonReadFileFnProvider
    implements ReadFileFnProvider {
        private JsonReadFileFnProvider() {
        }

        @Override
        @Nonnull
        public <T> FunctionEx<Path, Stream<T>> createReadFileFn(@Nonnull FileFormat<T> format) {
            JsonFileFormat jsonFileFormat = (JsonFileFormat)format;
            Class formatClazz = jsonFileFormat.clazz();
            return path -> {
                if (path.toFile().length() == 0L) {
                    return Stream.empty();
                }
                if (formatClazz == null) {
                    return JsonUtil.mapSequenceFrom(path);
                }
                return JsonUtil.beanSequenceFrom(path, formatClazz);
            };
        }

        @Override
        @Nonnull
        public String format() {
            return "json";
        }
    }

    private static class LinesReadFileFnProvider
    extends AbstractReadFileFnProvider {
        private LinesReadFileFnProvider() {
        }

        @Override
        @Nonnull
        <T> FunctionEx<InputStream, Stream<T>> mapInputStreamFn(FileFormat<T> format) {
            LinesTextFileFormat linesTextFileFormat = (LinesTextFileFormat)format;
            String thisCharset = linesTextFileFormat.charset().name();
            return is -> {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, thisCharset));
                return (Stream)reader.lines().onClose(() -> Util.uncheckRun(reader::close));
            };
        }

        @Override
        @Nonnull
        public String format() {
            return "lines";
        }
    }

    private static class ParquetReadFileFnProvider
    implements ReadFileFnProvider {
        private ParquetReadFileFnProvider() {
        }

        @Override
        @Nonnull
        public <T> FunctionEx<Path, Stream<T>> createReadFileFn(@Nonnull FileFormat<T> format) {
            throw new UnsupportedOperationException("Reading Parquet files is not supported in local filesystem mode. Use Jet Hadoop module with FileSourceBuilder.useHadoopForLocalFiles option instead.");
        }

        @Override
        @Nonnull
        public String format() {
            return "parquet";
        }
    }

    private static class RawBytesReadFileFnProvider
    extends AbstractReadFileFnProvider {
        private RawBytesReadFileFnProvider() {
        }

        @Override
        @Nonnull
        <T> FunctionEx<InputStream, Stream<T>> mapInputStreamFn(FileFormat<T> format) {
            return is -> Stream.of(is.readAllBytes());
        }

        @Override
        @Nonnull
        public String format() {
            return "bin";
        }
    }

    private static class TextReadFileFnProvider
    extends AbstractReadFileFnProvider {
        private TextReadFileFnProvider() {
        }

        @Override
        @Nonnull
        <T> FunctionEx<InputStream, Stream<T>> mapInputStreamFn(FileFormat<T> format) {
            TextFileFormat textFileFormat = (TextFileFormat)format;
            String thisCharset = textFileFormat.charset().name();
            return is -> Stream.of(new String(is.readAllBytes(), Charset.forName(thisCharset)));
        }

        @Override
        @Nonnull
        public String format() {
            return "txt";
        }
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private static abstract class AbstractReadFileFnProvider
    implements ReadFileFnProvider {
        private AbstractReadFileFnProvider() {
        }

        @Override
        @Nonnull
        public <T> FunctionEx<Path, Stream<T>> createReadFileFn(@Nonnull FileFormat<T> format) {
            FunctionEx mapInputStreamFn = this.mapInputStreamFn(format);
            return path -> {
                FileInputStream fis = new FileInputStream(path.toFile());
                return (Stream)((Stream)mapInputStreamFn.apply(fis)).onClose(() -> Util.uncheckRun(fis::close));
            };
        }

        @Nonnull
        abstract <T> FunctionEx<InputStream, Stream<T>> mapInputStreamFn(FileFormat<T> var1);
    }
}

