/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public class PublisherMetricsCollector
implements MetricsCollector {
    private final ILogger logger = Logger.getLogger(PublisherMetricsCollector.class);
    private final MetricsPublisher[] publishers;

    public PublisherMetricsCollector(MetricsPublisher ... publishers) {
        this.publishers = publishers;
    }

    public void publishCollectedMetrics() {
        for (int i = 0; i < this.publishers.length; ++i) {
            try {
                this.publishers[i].whenComplete();
                continue;
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                continue;
            }
            catch (Throwable throwable) {
                this.logger.severe("Error completing publication for publisher " + this.publishers[i].name(), throwable);
            }
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.publishers.length; ++i) {
            try {
                this.publishers[i].shutdown();
                continue;
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                continue;
            }
            catch (Throwable throwable) {
                this.logger.severe("Error shutting down metrics publisher " + this.publishers[i].name(), throwable);
            }
        }
    }

    @Override
    public void collectLong(MetricDescriptor descriptor, long value) {
        for (int i = 0; i < this.publishers.length; ++i) {
            try {
                this.publishers[i].publishLong(descriptor, value);
                continue;
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                continue;
            }
            catch (Throwable throwable) {
                this.logError(descriptor, value, this.publishers[i], throwable);
            }
        }
    }

    @Override
    public void collectDouble(MetricDescriptor descriptor, double value) {
        for (int i = 0; i < this.publishers.length; ++i) {
            try {
                this.publishers[i].publishDouble(descriptor, value);
                continue;
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                continue;
            }
            catch (Throwable throwable) {
                this.logError(descriptor, value, this.publishers[i], throwable);
            }
        }
    }

    @Override
    public void collectException(MetricDescriptor descriptor, Exception e) {
        this.logger.warning("Error when collecting '" + descriptor.toString() + "'", e);
    }

    @Override
    public void collectNoValue(MetricDescriptor descriptor) {
    }

    private void logError(MetricDescriptor descriptor, Object value, MetricsPublisher publisher, Throwable throwable) {
        this.logger.fine("Error publishing metric to: " + publisher.name() + ", metric=" + descriptor.toString() + ", value=" + value, throwable);
    }
}

