/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.auditlog.AuditlogService;
import com.hazelcast.auditlog.impl.NoOpAuditlogService;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.ClusterViewListenerService;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.AuditlogConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemStubImpl;
import com.hazelcast.cp.internal.persistence.CPPersistenceService;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.IntegrityChecker;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.TextCommandServiceImpl;
import com.hazelcast.internal.cluster.ClusterStateListener;
import com.hazelcast.internal.cluster.ClusterVersionListener;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.VersionMismatchException;
import com.hazelcast.internal.diagnostics.BuildInfoPlugin;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.EventQueuePlugin;
import com.hazelcast.internal.diagnostics.InvocationProfilerPlugin;
import com.hazelcast.internal.diagnostics.InvocationSamplePlugin;
import com.hazelcast.internal.diagnostics.MemberHazelcastInstanceInfoPlugin;
import com.hazelcast.internal.diagnostics.MemberHeartbeatPlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.NetworkingImbalancePlugin;
import com.hazelcast.internal.diagnostics.OperationHeartbeatPlugin;
import com.hazelcast.internal.diagnostics.OperationProfilerPlugin;
import com.hazelcast.internal.diagnostics.OperationThreadSamplerPlugin;
import com.hazelcast.internal.diagnostics.OverloadedConnectionsPlugin;
import com.hazelcast.internal.diagnostics.PendingInvocationsPlugin;
import com.hazelcast.internal.diagnostics.SlowOperationPlugin;
import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.EmptyDynamicConfigListener;
import com.hazelcast.internal.hotrestart.InternalHotRestartService;
import com.hazelcast.internal.hotrestart.NoOpHotRestartService;
import com.hazelcast.internal.hotrestart.NoopInternalHotRestartService;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.management.TimedMemberStateFactory;
import com.hazelcast.internal.memory.DefaultMemoryStats;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.namespace.UserCodeNamespaceService;
import com.hazelcast.internal.namespace.impl.NoOpUserCodeNamespaceService;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.CodebaseClusterVersionAware;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.ChannelInitializerFunction;
import com.hazelcast.internal.server.tcp.PacketDecoder;
import com.hazelcast.internal.server.tcp.PacketEncoder;
import com.hazelcast.internal.tpc.TpcServerBootstrap;
import com.hazelcast.internal.tpc.TpcServerBootstrapImpl;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InstanceTrackingUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobEventService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceConstructor;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceManager;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import com.hazelcast.wan.impl.WanReplicationService;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DefaultNodeExtension
implements NodeExtension {
    private static final String PLATFORM_LOGO = "o    o     o     o---o   o--o o      o---o     o     o----o o--o--o\n|    |    / \\       /         |     /         / \\    |         |\no----o       o     o   o----o |    o             o   o----o    |\n|    |  *     \\   /           |     \\       *     \\       |    |\no    o *       o o---o   o--o o----o o---o *       o o----o    o\n".indent(4);
    private static final String COPYRIGHT_LINE = "Copyright (c) 2008-2024, Hazelcast, Inc. All Rights Reserved.";
    protected final Node node;
    protected final ILogger logger;
    protected final ILogger logoLogger;
    protected final ILogger systemLogger;
    protected final List<ClusterVersionListener> clusterVersionListeners = new CopyOnWriteArrayList<ClusterVersionListener>();
    protected JetServiceBackend jetServiceBackend;
    protected IntegrityChecker integrityChecker;
    private final MemoryStats memoryStats = new DefaultMemoryStats();

    public DefaultNodeExtension(Node node) {
        this.node = node;
        this.logger = node.getLogger(NodeExtension.class);
        this.logoLogger = node.getLogger("com.hazelcast.system.logo");
        this.systemLogger = node.getLogger("com.hazelcast.system");
        this.checkCPSubsystemAllowed();
        this.checkSecurityAllowed();
        this.checkPersistenceAllowed();
        this.checkLosslessRestartAllowed();
        this.checkDynamicConfigurationPersistenceAllowed();
        this.checkSqlCatalogPersistenceAllowed();
        if (node.getConfig().getJetConfig().isEnabled()) {
            this.jetServiceBackend = this.createService(JetServiceBackend.class, new Object[0]);
        }
        this.integrityChecker = new IntegrityChecker(node.getConfig().getIntegrityCheckerConfig(), this.systemLogger);
    }

    private void checkCPSubsystemAllowed() {
        CPSubsystemConfig cpSubsystemConfig = this.node.getConfig().getCPSubsystemConfig();
        if (cpSubsystemConfig != null && cpSubsystemConfig.getCPMemberCount() != 0 && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("CP subsystem is a licensed feature. Please ensure you have an Enterprise license that enables CP.");
        }
    }

    private void checkPersistenceAllowed() {
        PersistenceConfig persistenceConfig = this.node.getConfig().getPersistenceConfig();
        if (persistenceConfig != null && persistenceConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Hot Restart requires Hazelcast Enterprise Edition");
        }
    }

    private void checkSecurityAllowed() {
        SecurityConfig securityConfig = this.node.getConfig().getSecurityConfig();
        if (securityConfig != null && securityConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Security requires Hazelcast Enterprise Edition");
        }
        SymmetricEncryptionConfig symmetricEncryptionConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.node.getConfig()).getSymmetricEncryptionConfig();
        if (symmetricEncryptionConfig != null && symmetricEncryptionConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Symmetric Encryption requires Hazelcast Enterprise Edition");
        }
        AuditlogConfig auditlogConfig = this.node.getConfig().getAuditlogConfig();
        if (auditlogConfig != null && auditlogConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Auditlog requires Hazelcast Enterprise Edition");
        }
    }

    private void checkLosslessRestartAllowed() {
        JetConfig jetConfig = this.node.getConfig().getJetConfig();
        if (jetConfig.isLosslessRestartEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Lossless Restart requires Hazelcast Enterprise Edition");
        }
    }

    protected void checkDynamicConfigurationPersistenceAllowed() {
        Config config = this.node.getConfig();
        if (config.getDynamicConfigurationConfig().isPersistenceEnabled()) {
            if (!BuildInfoProvider.getBuildInfo().isEnterprise()) {
                throw new IllegalStateException("Dynamic Configuration Persistence requires Hazelcast Enterprise Edition");
            }
            if (config.getConfigurationFile() == null || !config.getConfigurationFile().exists()) {
                throw new InvalidConfigurationException("Dynamic Configuration Persistence is enabled but config file couldn't be found. This is probably because declarative configuration isn't used.");
            }
        }
    }

    protected void checkSqlCatalogPersistenceAllowed() {
        Config config = this.node.getConfig();
        if (config.getSqlConfig().isCatalogPersistenceEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("SQL Catalog Persistence requires Hazelcast Enterprise Edition");
        }
    }

    @Override
    public void beforeStart() {
        this.integrityChecker.checkIntegrity();
        if (this.jetServiceBackend != null) {
            this.systemLogger.info("Jet is enabled");
            this.jetServiceBackend.configureJetInternalObjects(this.node.config.getStaticConfig(), this.node.getProperties());
        } else {
            this.systemLogger.info(Util.JET_IS_DISABLED_MESSAGE);
        }
    }

    @Override
    public void printNodeInfo() {
        BuildInfo buildInfo = this.node.getBuildInfo();
        this.printBannersBeforeNodeInfo();
        String build = this.constructBuildString(buildInfo);
        this.printNodeInfoInternal(buildInfo, build);
    }

    @Override
    public void logInstanceTrackingMetadata() {
        InstanceTrackingConfig trackingConfig = this.node.getConfig().getInstanceTrackingConfig();
        if (trackingConfig.isEnabled()) {
            InstanceTrackingUtil.writeInstanceTrackingFile(trackingConfig.getFileName(), trackingConfig.getFormatPattern(), this.getTrackingFileProperties(this.node.getBuildInfo()), this.systemLogger);
        }
    }

    protected Map<String, Object> getTrackingFileProperties(BuildInfo buildInfo) {
        Map<String, Object> props = MapUtil.createHashMap(6);
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.PRODUCT.getPropertyName(), InstanceTrackingConfig.InstanceProductName.HAZELCAST.getProductName());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.VERSION.getPropertyName(), buildInfo.getVersion());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.MODE.getPropertyName(), Boolean.getBoolean("hazelcast.tracking.server") ? InstanceTrackingConfig.InstanceMode.SERVER.getModeName() : InstanceTrackingConfig.InstanceMode.EMBEDDED.getModeName());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.START_TIMESTAMP.getPropertyName(), System.currentTimeMillis());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.LICENSED.getPropertyName(), 0);
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.PID.getPropertyName(), JVMUtil.getPid());
        return props;
    }

    protected void printBannersBeforeNodeInfo() {
        this.logoLogger.info("\n" + PLATFORM_LOGO);
        this.systemLogger.info(COPYRIGHT_LINE);
    }

    protected String constructBuildString(BuildInfo buildInfo) {
        Object build = buildInfo.getBuild();
        String revision = buildInfo.getRevision();
        if (!revision.isEmpty()) {
            build = (String)build + " - " + revision;
        }
        return build;
    }

    private void printNodeInfoInternal(BuildInfo buildInfo, String build) {
        this.systemLogger.info(this.getEditionString() + " " + buildInfo.getVersion() + " (" + build + ") starting at " + this.node.getThisAddress());
        this.systemLogger.info("Cluster name: " + this.node.getConfig().getClusterName());
        this.systemLogger.fine("Configured Hazelcast Serialization version: " + buildInfo.getSerializationVersion());
    }

    protected String getEditionString() {
        return "Hazelcast Platform";
    }

    @Override
    public void afterStart() {
        if (this.jetServiceBackend != null) {
            this.jetServiceBackend.startScanningForJobs();
        }
    }

    @Override
    public boolean isStartCompleted() {
        return this.node.getClusterService().isJoined();
    }

    @Override
    public boolean isReady() {
        return this.node.getClusterService().isJoined();
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public InternalSerializationService createSerializationService() {
        return this.createSerializationService(false);
    }

    @Override
    public InternalSerializationService createCompatibilitySerializationService() {
        return this.createSerializationService(true);
    }

    @Override
    public MemberSchemaService createSchemaService() {
        return new MemberSchemaService();
    }

    private InternalSerializationService createSerializationService(boolean isCompatibility) {
        InternalSerializationService ss;
        try {
            Config config = this.node.getConfig();
            ClassLoader configClassLoader = this.node.getConfigClassLoader();
            HazelcastInstanceImpl hazelcastInstance = this.node.hazelcastInstance;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            byte version = (byte)this.node.getProperties().getInteger(ClusterProperty.SERIALIZATION_VERSION);
            ss = (InternalSerializationService)builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(hazelcastInstance.managedContext).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).setVersion(version).setSchemaService(this.node.getSchemaService()).setNotActiveExceptionSupplier(HazelcastInstanceNotActiveException::new).setVersionedSerializationEnabled(true).setClusterVersionAware(new CodebaseClusterVersionAware()).isCompatibility(isCompatibility).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = this.node.getProperties().getString(ClusterProperty.PARTITIONING_STRATEGY_CLASS);
        if (!StringUtil.isNullOrEmpty(partitioningStrategyClassName)) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public <T> T createService(Class<T> clazz, Object ... params) {
        if (WanReplicationService.class.isAssignableFrom(clazz)) {
            return (T)new WanReplicationServiceImpl(this.node);
        }
        if (ICacheService.class.isAssignableFrom(clazz)) {
            return (T)new CacheService();
        }
        if (MapService.class.isAssignableFrom(clazz)) {
            return this.createMapService();
        }
        if (JetServiceBackend.class.isAssignableFrom(clazz)) {
            return (T)new JetServiceBackend(this.node);
        }
        if (ClusterWideConfigurationService.class.isAssignableFrom(clazz)) {
            return this.createConfigurationService(params[0]);
        }
        throw new IllegalArgumentException("Unknown service class: " + clazz);
    }

    private <T> T createMapService() {
        ConstructorFunction<NodeEngine, MapService> constructor = MapServiceConstructor.getDefaultMapServiceConstructor();
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        return (T)constructor.createNew(nodeEngine);
    }

    private <T> T createConfigurationService(Object nodeEngine) {
        if (!(nodeEngine instanceof NodeEngine)) {
            throw new IllegalArgumentException("While creating ConfigurationService expected NodeEngine as a parameter, but found: " + nodeEngine.getClass().getName());
        }
        return (T)new ClusterWideConfigurationService((NodeEngine)nodeEngine, new EmptyDynamicConfigListener());
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        if (this.jetServiceBackend != null) {
            HashMap<String, Object> services = new HashMap<String, Object>();
            services.put("hz:impl:jetService", this.jetServiceBackend);
            services.put("hz:impl:jobEventService", new JobEventService(this.node.getNodeEngine()));
            return services;
        }
        return Collections.emptyMap();
    }

    @Override
    public MemberSocketInterceptor getSocketInterceptor(EndpointQualifier endpointQualifier) {
        this.logger.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public InboundHandler[] createInboundHandlers(EndpointQualifier qualifier, ServerConnection connection, ServerContext serverContext) {
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        PacketDecoder decoder = new PacketDecoder(connection, nodeEngine.getPacketDispatcher());
        return new InboundHandler[]{decoder};
    }

    @Override
    public OutboundHandler[] createOutboundHandlers(EndpointQualifier qualifier, ServerConnection connection, ServerContext serverContext) {
        return new OutboundHandler[]{new PacketEncoder()};
    }

    @Override
    public Function<EndpointQualifier, ChannelInitializer> createChannelInitializerFn(ServerContext serverContext) {
        ChannelInitializerFunction provider = new ChannelInitializerFunction(serverContext, this.node.getConfig());
        provider.init();
        return provider;
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    @Override
    public void beforeShutdown(boolean terminate) {
        if (this.jetServiceBackend != null && !terminate) {
            this.jetServiceBackend.shutDownJobs();
        }
    }

    @Override
    public void afterShutdown() {
        this.logger.info("Destroying node NodeExtension.");
    }

    @Override
    public void validateJoinRequest(JoinMessage joinMessage) {
        MemberVersion memberVersion = joinMessage.getMemberVersion();
        Version clusterVersion = this.node.getClusterService().getClusterVersion();
        if (!memberVersion.asVersion().equals(clusterVersion)) {
            String msg = "Joining node's version " + memberVersion + " is not compatible with cluster version " + clusterVersion;
            if (clusterVersion.getMajor() != memberVersion.getMajor()) {
                msg = msg + " (Rolling Member Upgrades are only supported for the same major version)";
            }
            if (clusterVersion.getMinor() > memberVersion.getMinor()) {
                msg = msg + " (Rolling Member Upgrades are only supported for the next minor version)";
            }
            if (!BuildInfoProvider.getBuildInfo().isEnterprise()) {
                msg = msg + " (Rolling Member Upgrades are only supported in Hazelcast Enterprise)";
            }
            throw new VersionMismatchException(msg);
        }
    }

    @Override
    public void beforeClusterStateChange(ClusterState currState, ClusterState requestedState, boolean isTransient) {
        if (this.jetServiceBackend != null) {
            this.jetServiceBackend.beforeClusterStateChange(requestedState);
        }
    }

    @Override
    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        ServiceManager serviceManager = this.node.getNodeEngine().getServiceManager();
        List<ClusterStateListener> listeners = serviceManager.getServices(ClusterStateListener.class);
        for (ClusterStateListener listener : listeners) {
            listener.onClusterStateChange(newState);
        }
    }

    @Override
    public void onPartitionStateChange() {
        ClusterViewListenerService service = this.node.clientEngine.getClusterViewListenerService();
        if (service != null) {
            service.onPartitionStateChange();
        }
    }

    @Override
    public void onMemberListChange() {
        ClusterViewListenerService service = this.node.clientEngine.getClusterViewListenerService();
        if (service != null) {
            service.onMemberListChange();
        }
        this.node.clusterTopologyIntentTracker.onMembershipChange();
    }

    @Override
    public void onClusterVersionChange(Version newVersion) {
        if (!this.node.getVersion().asVersion().isEqualTo(newVersion)) {
            this.systemLogger.info("Cluster version set to " + newVersion);
        }
        ServiceManager serviceManager = this.node.getNodeEngine().getServiceManager();
        List<ClusterVersionListener> listeners = serviceManager.getServices(ClusterVersionListener.class);
        for (ClusterVersionListener listener : listeners) {
            listener.onClusterVersionChange(newVersion);
        }
        for (ClusterVersionListener listener : this.clusterVersionListeners) {
            listener.onClusterVersionChange(newVersion);
        }
        ClusterViewListenerService service = this.node.clientEngine.getClusterViewListenerService();
        if (service != null) {
            service.onClusterVersionChange();
        }
    }

    @Override
    public boolean isNodeVersionCompatibleWith(Version clusterVersion) {
        Preconditions.checkNotNull(clusterVersion);
        return this.node.getVersion().asVersion().equals(clusterVersion);
    }

    @Override
    public boolean registerListener(Object listener) {
        if (listener instanceof HazelcastInstanceAware) {
            HazelcastInstanceAware aware = (HazelcastInstanceAware)listener;
            aware.setHazelcastInstance(this.node.hazelcastInstance);
        }
        if (listener instanceof ClusterVersionListener) {
            ClusterVersionListener clusterVersionListener = (ClusterVersionListener)listener;
            this.clusterVersionListeners.add(clusterVersionListener);
            clusterVersionListener.onClusterVersionChange(this.getClusterOrNodeVersion());
            return true;
        }
        return false;
    }

    @Override
    public HotRestartService getHotRestartService() {
        return new NoOpHotRestartService();
    }

    @Override
    public InternalHotRestartService getInternalHotRestartService() {
        return new NoopInternalHotRestartService();
    }

    private Version getClusterOrNodeVersion() {
        if (this.node.getClusterService() != null && !this.node.getClusterService().getClusterVersion().isUnknown()) {
            return this.node.getClusterService().getClusterVersion();
        }
        String overriddenClusterVersion = this.node.getProperties().getString(ClusterProperty.INIT_CLUSTER_VERSION);
        return overriddenClusterVersion != null ? MemberVersion.of(overriddenClusterVersion).asVersion() : this.node.getVersion().asVersion();
    }

    @Override
    public TimedMemberStateFactory createTimedMemberStateFactory(HazelcastInstanceImpl instance) {
        return new TimedMemberStateFactory(instance);
    }

    @Override
    public void registerPlugins(Diagnostics diagnostics) {
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        diagnostics.register(new BuildInfoPlugin(nodeEngine));
        diagnostics.register(new SystemPropertiesPlugin(nodeEngine));
        diagnostics.register(new ConfigPropertiesPlugin(nodeEngine));
        diagnostics.register(new OverloadedConnectionsPlugin(nodeEngine));
        diagnostics.register(new EventQueuePlugin(nodeEngine, ((EventServiceImpl)nodeEngine.getEventService()).getEventExecutor()));
        diagnostics.register(new PendingInvocationsPlugin(nodeEngine));
        diagnostics.register(new MetricsPlugin(nodeEngine));
        diagnostics.register(new SlowOperationPlugin(nodeEngine));
        diagnostics.register(new InvocationSamplePlugin(nodeEngine));
        diagnostics.register(new InvocationProfilerPlugin(nodeEngine));
        diagnostics.register(new OperationProfilerPlugin(nodeEngine));
        diagnostics.register(new MemberHazelcastInstanceInfoPlugin(nodeEngine));
        diagnostics.register(new SystemLogPlugin(nodeEngine));
        diagnostics.register(new StoreLatencyPlugin(nodeEngine));
        diagnostics.register(new MemberHeartbeatPlugin(nodeEngine));
        diagnostics.register(new NetworkingImbalancePlugin(nodeEngine));
        diagnostics.register(new OperationHeartbeatPlugin(nodeEngine));
        diagnostics.register(new OperationThreadSamplerPlugin(nodeEngine));
    }

    @Override
    public ManagementService createJMXManagementService(HazelcastInstanceImpl instance) {
        return new ManagementService(instance);
    }

    @Override
    public TextCommandService createTextCommandService() {
        return new TextCommandServiceImpl(this.node);
    }

    @Override
    public CPPersistenceService getCPPersistenceService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSubsystem createCPSubsystem(NodeEngine nodeEngine) {
        return new CPSubsystemStubImpl();
    }

    public void setLicenseKey(String licenseKey) {
    }

    @Override
    public AuditlogService getAuditlogService() {
        return NoOpAuditlogService.INSTANCE;
    }

    @Override
    public JetService getJet() {
        Util.checkJetIsEnabled(this.node.nodeEngine);
        return this.jetServiceBackend.getJet();
    }

    @Override
    @Nullable
    public JetServiceBackend getJetServiceBackend() {
        return this.jetServiceBackend;
    }

    @Override
    public SSLEngineFactory createSslEngineFactory(SSLConfig sslConfig) {
        throw new IllegalStateException("SSL/TLS requires Hazelcast Enterprise Edition");
    }

    @Override
    public void onThreadStart(Thread thread) {
        NodeEngineThreadLocalContext.declareNodeEngineReference(this.node.getNodeEngine());
    }

    @Override
    public void onThreadStop(Thread thread) {
        NodeEngineThreadLocalContext.destroyNodeEngineReference();
    }

    @Override
    public UserCodeNamespaceService getNamespaceService() {
        return new NoOpUserCodeNamespaceService(Node.getLegacyUCDClassLoader(this.node.getConfig()));
    }

    @Override
    public TpcServerBootstrap createTpcServerBootstrap() {
        return new TpcServerBootstrapImpl(this.node);
    }

    @Override
    public ClientEngine createClientEngine() {
        return new ClientEngineImpl(this.node);
    }
}

