/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.XForwardedRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XForwardedRequestWrapperFactory
extends AbstractRequestWrapperFactory {
    private static final Logger log = LoggerFactory.getLogger(XForwardedRequestWrapperFactory.class);
    protected static final String HTTP_SERVER_PORT_PARAMETER = "httpServerPort";
    protected static final String HTTPS_SERVER_PORT_PARAMETER = "httpsServerPort";
    protected static final String INTERNAL_PROXIES_PARAMETER = "allowedInternalProxies";
    protected static final String PROTOCOL_HEADER_PARAMETER = "protocolHeader";
    protected static final String PROTOCOL_HEADER_SSL_VALUE_PARAMETER = "protocolHeaderSslValue";
    protected static final String PROXIES_HEADER_PARAMETER = "proxiesHeader";
    protected static final String REMOTE_IP_HEADER_PARAMETER = "remoteIPHeader";
    protected static final String TRUSTED_PROXIES_PARAMETER = "trustedProxies";
    private Config config = new Config();

    public final Config getConfig() {
        return this.config;
    }

    public final void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public boolean needsWrapper(HttpServletRequest request) {
        boolean rtn = XForwardedRequestWrapperFactory.matchesOne(request.getRemoteAddr(), this.config.allowedInternalProxies);
        if (!rtn && log.isDebugEnabled()) {
            log.debug("Skip XForwardedFilter for request " + request.getRequestURI() + " with remote address " + request.getRemoteAddr());
        }
        return rtn;
    }

    @Override
    public HttpServletRequest newRequestWrapper(HttpServletRequest request) {
        String protocolHeaderValue;
        int idx;
        String remoteIp = null;
        LinkedList<String> proxiesHeaderValue = new LinkedList<String>();
        String[] remoteIPHeaderValue = XForwardedRequestWrapperFactory.commaDelimitedListToStringArray(request.getHeader(this.config.remoteIPHeader));
        for (idx = remoteIPHeaderValue.length - 1; idx >= 0; --idx) {
            String currentRemoteIp;
            remoteIp = currentRemoteIp = remoteIPHeaderValue[idx];
            if (XForwardedRequestWrapperFactory.matchesOne(currentRemoteIp, this.config.allowedInternalProxies)) continue;
            if (XForwardedRequestWrapperFactory.matchesOne(currentRemoteIp, this.config.trustedProxies)) {
                proxiesHeaderValue.addFirst(currentRemoteIp);
                continue;
            }
            --idx;
            break;
        }
        LinkedList<String> newRemoteIpHeaderValue = new LinkedList<String>();
        while (idx >= 0) {
            String currentRemoteIp = remoteIPHeaderValue[idx];
            newRemoteIpHeaderValue.addFirst(currentRemoteIp);
            --idx;
        }
        XForwardedRequestWrapper xRequest = new XForwardedRequestWrapper(request);
        if (remoteIp != null) {
            xRequest.setRemoteAddr(remoteIp);
            xRequest.setRemoteHost(remoteIp);
            if (proxiesHeaderValue.size() == 0) {
                xRequest.removeHeader(this.config.proxiesHeader);
            } else {
                String commaDelimitedListOfProxies = XForwardedRequestWrapperFactory.listToCommaDelimitedString(proxiesHeaderValue);
                xRequest.setHeader(this.config.proxiesHeader, commaDelimitedListOfProxies);
            }
            if (newRemoteIpHeaderValue.size() == 0) {
                xRequest.removeHeader(this.config.remoteIPHeader);
            } else {
                String commaDelimitedRemoteIpHeaderValue = XForwardedRequestWrapperFactory.listToCommaDelimitedString(newRemoteIpHeaderValue);
                xRequest.setHeader(this.config.remoteIPHeader, commaDelimitedRemoteIpHeaderValue);
            }
        }
        if (this.config.protocolHeader != null && (protocolHeaderValue = request.getHeader(this.config.protocolHeader)) != null) {
            if (this.config.protocolHeaderSslValue.equalsIgnoreCase(protocolHeaderValue)) {
                xRequest.setSecure(true);
                xRequest.setScheme("https");
                xRequest.setServerPort(this.config.httpsServerPort);
            } else {
                xRequest.setSecure(false);
                xRequest.setScheme("http");
                xRequest.setServerPort(this.config.httpServerPort);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Incoming request " + request.getRequestURI() + " with originalRemoteAddr '" + request.getRemoteAddr() + "', originalRemoteHost='" + request.getRemoteHost() + "', originalSecure='" + request.isSecure() + "', originalScheme='" + request.getScheme() + "', original[" + this.config.remoteIPHeader + "]='" + request.getHeader(this.config.remoteIPHeader) + ", original[" + this.config.protocolHeader + "]='" + (this.config.protocolHeader == null ? null : request.getHeader(this.config.protocolHeader)) + "' will be seen as newRemoteAddr='" + xRequest.getRemoteAddr() + "', newRemoteHost='" + xRequest.getRemoteHost() + "', newScheme='" + xRequest.getScheme() + "', newSecure='" + xRequest.isSecure() + "', new[" + this.config.remoteIPHeader + "]='" + xRequest.getHeader(this.config.remoteIPHeader) + ", new[" + this.config.proxiesHeader + "]='" + xRequest.getHeader(this.config.proxiesHeader) + "'");
        }
        return xRequest;
    }

    public void init(FilterConfig filterConfig) {
        if (filterConfig.getInitParameter(INTERNAL_PROXIES_PARAMETER) != null) {
            this.config.setAllowedInternalProxies(filterConfig.getInitParameter(INTERNAL_PROXIES_PARAMETER));
        }
        if (filterConfig.getInitParameter(PROTOCOL_HEADER_PARAMETER) != null) {
            this.config.setProtocolHeader(filterConfig.getInitParameter(PROTOCOL_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(PROTOCOL_HEADER_SSL_VALUE_PARAMETER) != null) {
            this.config.setProtocolHeaderSslValue(filterConfig.getInitParameter(PROTOCOL_HEADER_SSL_VALUE_PARAMETER));
        }
        if (filterConfig.getInitParameter(PROXIES_HEADER_PARAMETER) != null) {
            this.config.setProxiesHeader(filterConfig.getInitParameter(PROXIES_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(REMOTE_IP_HEADER_PARAMETER) != null) {
            this.config.setRemoteIPHeader(filterConfig.getInitParameter(REMOTE_IP_HEADER_PARAMETER));
        }
        if (filterConfig.getInitParameter(TRUSTED_PROXIES_PARAMETER) != null) {
            this.config.setTrustedProxies(filterConfig.getInitParameter(TRUSTED_PROXIES_PARAMETER));
        }
        if (filterConfig.getInitParameter(HTTP_SERVER_PORT_PARAMETER) != null) {
            try {
                this.config.setHttpServerPort(Integer.parseInt(filterConfig.getInitParameter(HTTP_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Illegal httpServerPort : " + e.getMessage());
            }
        }
        if (filterConfig.getInitParameter(HTTPS_SERVER_PORT_PARAMETER) != null) {
            try {
                this.config.setHttpsServerPort(Integer.parseInt(filterConfig.getInitParameter(HTTPS_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Illegal httpsServerPort : " + e.getMessage());
            }
        }
    }

    public static class Config {
        private boolean enabled = true;
        private int httpServerPort = 80;
        private int httpsServerPort = 443;
        private String protocolHeader = null;
        private String protocolHeaderSslValue = "https";
        private String proxiesHeader = "X-Forwarded-By";
        private String remoteIPHeader = "X-Forwarded-For";
        private Pattern[] trustedProxies = new Pattern[0];
        private Pattern[] allowedInternalProxies = new Pattern[]{Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("192\\.168\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("172\\.(?:1[6-9]|2\\d|3[0-1]).\\d{1,3}.\\d{1,3}"), Pattern.compile("169\\.254\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")};

        public void setAllowedInternalProxies(String allowedInternalProxies) {
            this.allowedInternalProxies = AbstractRequestWrapperFactory.commaDelimitedListToPatternArray(allowedInternalProxies);
        }

        public void setHttpServerPort(int httpServerPort) {
            this.httpServerPort = httpServerPort;
        }

        public void setHttpsServerPort(int httpsServerPort) {
            this.httpsServerPort = httpsServerPort;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public void setProtocolHeaderSslValue(String protocolHeaderSslValue) {
            this.protocolHeaderSslValue = protocolHeaderSslValue;
        }

        public void setProxiesHeader(String proxiesHeader) {
            this.proxiesHeader = proxiesHeader;
        }

        public void setRemoteIPHeader(String remoteIPHeader) {
            this.remoteIPHeader = remoteIPHeader;
        }

        public void setTrustedProxies(String trustedProxies) {
            this.trustedProxies = AbstractRequestWrapperFactory.commaDelimitedListToPatternArray(trustedProxies);
        }

        public void setEnabled(boolean enable) {
            this.enabled = enable;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

