/****************************************************************************
 * arch/risc-v/src/rp23xx-rv/hardware/rp23xx_otp_data.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_OTP_DATA_H
#define __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_OTP_DATA_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/rp23xx_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define RP23XX_OTP_DATA_CHIPID0_ROW 0x00000000
#define RP23XX_OTP_DATA_CHIPID0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_CHIPID0_RESET  "-"
#define RP23XX_OTP_DATA_CHIPID0_WIDTH  16
#define RP23XX_OTP_DATA_CHIPID0_MSB    15
#define RP23XX_OTP_DATA_CHIPID0_LSB    0
#define RP23XX_OTP_DATA_CHIPID0_ACCESS "RO"

#define RP23XX_OTP_DATA_CHIPID1_ROW 0x00000001
#define RP23XX_OTP_DATA_CHIPID1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_CHIPID1_RESET  "-"
#define RP23XX_OTP_DATA_CHIPID1_WIDTH  16
#define RP23XX_OTP_DATA_CHIPID1_MSB    15
#define RP23XX_OTP_DATA_CHIPID1_LSB    0
#define RP23XX_OTP_DATA_CHIPID1_ACCESS "RO"

#define RP23XX_OTP_DATA_CHIPID2_ROW 0x00000002
#define RP23XX_OTP_DATA_CHIPID2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_CHIPID2_RESET  "-"
#define RP23XX_OTP_DATA_CHIPID2_WIDTH  16
#define RP23XX_OTP_DATA_CHIPID2_MSB    15
#define RP23XX_OTP_DATA_CHIPID2_LSB    0
#define RP23XX_OTP_DATA_CHIPID2_ACCESS "RO"

#define RP23XX_OTP_DATA_CHIPID3_ROW 0x00000003
#define RP23XX_OTP_DATA_CHIPID3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_CHIPID3_RESET  "-"
#define RP23XX_OTP_DATA_CHIPID3_WIDTH  16
#define RP23XX_OTP_DATA_CHIPID3_MSB    15
#define RP23XX_OTP_DATA_CHIPID3_LSB    0
#define RP23XX_OTP_DATA_CHIPID3_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID0_ROW 0x00000004
#define RP23XX_OTP_DATA_RANDID0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID0_RESET  "-"
#define RP23XX_OTP_DATA_RANDID0_WIDTH  16
#define RP23XX_OTP_DATA_RANDID0_MSB    15
#define RP23XX_OTP_DATA_RANDID0_LSB    0
#define RP23XX_OTP_DATA_RANDID0_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID1_ROW 0x00000005
#define RP23XX_OTP_DATA_RANDID1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID1_RESET  "-"
#define RP23XX_OTP_DATA_RANDID1_WIDTH  16
#define RP23XX_OTP_DATA_RANDID1_MSB    15
#define RP23XX_OTP_DATA_RANDID1_LSB    0
#define RP23XX_OTP_DATA_RANDID1_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID2_ROW 0x00000006
#define RP23XX_OTP_DATA_RANDID2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID2_RESET  "-"
#define RP23XX_OTP_DATA_RANDID2_WIDTH  16
#define RP23XX_OTP_DATA_RANDID2_MSB    15
#define RP23XX_OTP_DATA_RANDID2_LSB    0
#define RP23XX_OTP_DATA_RANDID2_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID3_ROW 0x00000007
#define RP23XX_OTP_DATA_RANDID3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID3_RESET  "-"
#define RP23XX_OTP_DATA_RANDID3_WIDTH  16
#define RP23XX_OTP_DATA_RANDID3_MSB    15
#define RP23XX_OTP_DATA_RANDID3_LSB    0
#define RP23XX_OTP_DATA_RANDID3_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID4_ROW 0x00000008
#define RP23XX_OTP_DATA_RANDID4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID4_RESET  "-"
#define RP23XX_OTP_DATA_RANDID4_WIDTH  16
#define RP23XX_OTP_DATA_RANDID4_MSB    15
#define RP23XX_OTP_DATA_RANDID4_LSB    0
#define RP23XX_OTP_DATA_RANDID4_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID5_ROW 0x00000009
#define RP23XX_OTP_DATA_RANDID5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID5_RESET  "-"
#define RP23XX_OTP_DATA_RANDID5_WIDTH  16
#define RP23XX_OTP_DATA_RANDID5_MSB    15
#define RP23XX_OTP_DATA_RANDID5_LSB    0
#define RP23XX_OTP_DATA_RANDID5_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID6_ROW 0x0000000a
#define RP23XX_OTP_DATA_RANDID6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID6_RESET  "-"
#define RP23XX_OTP_DATA_RANDID6_WIDTH  16
#define RP23XX_OTP_DATA_RANDID6_MSB    15
#define RP23XX_OTP_DATA_RANDID6_LSB    0
#define RP23XX_OTP_DATA_RANDID6_ACCESS "RO"

#define RP23XX_OTP_DATA_RANDID7_ROW 0x0000000b
#define RP23XX_OTP_DATA_RANDID7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_RANDID7_RESET  "-"
#define RP23XX_OTP_DATA_RANDID7_WIDTH  16
#define RP23XX_OTP_DATA_RANDID7_MSB    15
#define RP23XX_OTP_DATA_RANDID7_LSB    0
#define RP23XX_OTP_DATA_RANDID7_ACCESS "RO"

#define RP23XX_OTP_DATA_ROSC_CALIB_ROW 0x00000010
#define RP23XX_OTP_DATA_ROSC_CALIB_BITS   0x0000ffff
#define RP23XX_OTP_DATA_ROSC_CALIB_RESET  "-"
#define RP23XX_OTP_DATA_ROSC_CALIB_WIDTH  16
#define RP23XX_OTP_DATA_ROSC_CALIB_MSB    15
#define RP23XX_OTP_DATA_ROSC_CALIB_LSB    0
#define RP23XX_OTP_DATA_ROSC_CALIB_ACCESS "RO"

#define RP23XX_OTP_DATA_LPOSC_CALIB_ROW 0x00000011
#define RP23XX_OTP_DATA_LPOSC_CALIB_BITS   0x0000ffff
#define RP23XX_OTP_DATA_LPOSC_CALIB_RESET  "-"
#define RP23XX_OTP_DATA_LPOSC_CALIB_WIDTH  16
#define RP23XX_OTP_DATA_LPOSC_CALIB_MSB    15
#define RP23XX_OTP_DATA_LPOSC_CALIB_LSB    0
#define RP23XX_OTP_DATA_LPOSC_CALIB_ACCESS "RO"

#define RP23XX_OTP_DATA_NUM_GPIOS_ROW 0x00000018
#define RP23XX_OTP_DATA_NUM_GPIOS_BITS   0x000000ff
#define RP23XX_OTP_DATA_NUM_GPIOS_RESET  "-"
#define RP23XX_OTP_DATA_NUM_GPIOS_WIDTH  16
#define RP23XX_OTP_DATA_NUM_GPIOS_MSB    7
#define RP23XX_OTP_DATA_NUM_GPIOS_LSB    0
#define RP23XX_OTP_DATA_NUM_GPIOS_ACCESS "RO"

#define RP23XX_OTP_DATA_INFO_CRC0_ROW 0x00000036
#define RP23XX_OTP_DATA_INFO_CRC0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_INFO_CRC0_RESET  "-"
#define RP23XX_OTP_DATA_INFO_CRC0_WIDTH  16
#define RP23XX_OTP_DATA_INFO_CRC0_MSB    15
#define RP23XX_OTP_DATA_INFO_CRC0_LSB    0
#define RP23XX_OTP_DATA_INFO_CRC0_ACCESS "RO"

#define RP23XX_OTP_DATA_INFO_CRC1_ROW 0x00000037
#define RP23XX_OTP_DATA_INFO_CRC1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_INFO_CRC1_RESET  "-"
#define RP23XX_OTP_DATA_INFO_CRC1_WIDTH  16
#define RP23XX_OTP_DATA_INFO_CRC1_MSB    15
#define RP23XX_OTP_DATA_INFO_CRC1_LSB    0
#define RP23XX_OTP_DATA_INFO_CRC1_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_ROW 0x00000038
#define RP23XX_OTP_DATA_CRIT0_BITS   0x00000003
#define RP23XX_OTP_DATA_CRIT0_RESET  0x00000000
#define RP23XX_OTP_DATA_CRIT0_WIDTH  24

#define RP23XX_OTP_DATA_CRIT0_RISCV_DISABLE_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_RISCV_DISABLE_BITS   0x00000002
#define RP23XX_OTP_DATA_CRIT0_RISCV_DISABLE_MSB    1
#define RP23XX_OTP_DATA_CRIT0_RISCV_DISABLE_LSB    1
#define RP23XX_OTP_DATA_CRIT0_RISCV_DISABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_ARM_DISABLE_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_ARM_DISABLE_BITS   0x00000001
#define RP23XX_OTP_DATA_CRIT0_ARM_DISABLE_MSB    0
#define RP23XX_OTP_DATA_CRIT0_ARM_DISABLE_LSB    0
#define RP23XX_OTP_DATA_CRIT0_ARM_DISABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R1_ROW 0x00000039
#define RP23XX_OTP_DATA_CRIT0_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R1_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R1_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R1_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R1_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R2_ROW 0x0000003a
#define RP23XX_OTP_DATA_CRIT0_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R2_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R2_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R2_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R2_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R3_ROW 0x0000003b
#define RP23XX_OTP_DATA_CRIT0_R3_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R3_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R3_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R3_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R3_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R3_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R4_ROW 0x0000003c
#define RP23XX_OTP_DATA_CRIT0_R4_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R4_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R4_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R4_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R4_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R4_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R5_ROW 0x0000003d
#define RP23XX_OTP_DATA_CRIT0_R5_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R5_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R5_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R5_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R5_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R5_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R6_ROW 0x0000003e
#define RP23XX_OTP_DATA_CRIT0_R6_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R6_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R6_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R6_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R6_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R6_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT0_R7_ROW 0x0000003f
#define RP23XX_OTP_DATA_CRIT0_R7_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT0_R7_RESET  "-"
#define RP23XX_OTP_DATA_CRIT0_R7_WIDTH  24
#define RP23XX_OTP_DATA_CRIT0_R7_MSB    23
#define RP23XX_OTP_DATA_CRIT0_R7_LSB    0
#define RP23XX_OTP_DATA_CRIT0_R7_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_ROW 0x00000040
#define RP23XX_OTP_DATA_CRIT1_BITS   0x0000007f
#define RP23XX_OTP_DATA_CRIT1_RESET  0x00000000
#define RP23XX_OTP_DATA_CRIT1_WIDTH  24

#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_SENS_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_SENS_BITS   0x00000060
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_SENS_MSB    6
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_SENS_LSB    5
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_SENS_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_ENABLE_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_ENABLE_BITS   0x00000010
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_ENABLE_MSB    4
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_ENABLE_LSB    4
#define RP23XX_OTP_DATA_CRIT1_GLITCH_DETECTOR_ENABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_BOOT_ARCH_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_BOOT_ARCH_BITS   0x00000008
#define RP23XX_OTP_DATA_CRIT1_BOOT_ARCH_MSB    3
#define RP23XX_OTP_DATA_CRIT1_BOOT_ARCH_LSB    3
#define RP23XX_OTP_DATA_CRIT1_BOOT_ARCH_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_DEBUG_DISABLE_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_DEBUG_DISABLE_BITS   0x00000004
#define RP23XX_OTP_DATA_CRIT1_DEBUG_DISABLE_MSB    2
#define RP23XX_OTP_DATA_CRIT1_DEBUG_DISABLE_LSB    2
#define RP23XX_OTP_DATA_CRIT1_DEBUG_DISABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_SECURE_DEBUG_DISABLE_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_SECURE_DEBUG_DISABLE_BITS   0x00000002
#define RP23XX_OTP_DATA_CRIT1_SECURE_DEBUG_DISABLE_MSB    1
#define RP23XX_OTP_DATA_CRIT1_SECURE_DEBUG_DISABLE_LSB    1
#define RP23XX_OTP_DATA_CRIT1_SECURE_DEBUG_DISABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_SECURE_BOOT_ENABLE_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_SECURE_BOOT_ENABLE_BITS   0x00000001
#define RP23XX_OTP_DATA_CRIT1_SECURE_BOOT_ENABLE_MSB    0
#define RP23XX_OTP_DATA_CRIT1_SECURE_BOOT_ENABLE_LSB    0
#define RP23XX_OTP_DATA_CRIT1_SECURE_BOOT_ENABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R1_ROW 0x00000041
#define RP23XX_OTP_DATA_CRIT1_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R1_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R1_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R1_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R1_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R2_ROW 0x00000042
#define RP23XX_OTP_DATA_CRIT1_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R2_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R2_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R2_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R2_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R3_ROW 0x00000043
#define RP23XX_OTP_DATA_CRIT1_R3_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R3_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R3_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R3_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R3_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R3_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R4_ROW 0x00000044
#define RP23XX_OTP_DATA_CRIT1_R4_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R4_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R4_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R4_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R4_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R4_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R5_ROW 0x00000045
#define RP23XX_OTP_DATA_CRIT1_R5_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R5_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R5_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R5_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R5_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R5_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R6_ROW 0x00000046
#define RP23XX_OTP_DATA_CRIT1_R6_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R6_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R6_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R6_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R6_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R6_ACCESS "RO"

#define RP23XX_OTP_DATA_CRIT1_R7_ROW 0x00000047
#define RP23XX_OTP_DATA_CRIT1_R7_BITS   0x00ffffff
#define RP23XX_OTP_DATA_CRIT1_R7_RESET  "-"
#define RP23XX_OTP_DATA_CRIT1_R7_WIDTH  24
#define RP23XX_OTP_DATA_CRIT1_R7_MSB    23
#define RP23XX_OTP_DATA_CRIT1_R7_LSB    0
#define RP23XX_OTP_DATA_CRIT1_R7_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_ROW 0x00000048
#define RP23XX_OTP_DATA_BOOT_FLAGS0_BITS   0x003fffff
#define RP23XX_OTP_DATA_BOOT_FLAGS0_RESET  0x00000000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_WIDTH  24

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_SRAM_WINDOW_BOOT_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_SRAM_WINDOW_BOOT_BITS   0x00200000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_SRAM_WINDOW_BOOT_MSB    21
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_SRAM_WINDOW_BOOT_LSB    21
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_SRAM_WINDOW_BOOT_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_XIP_ACCESS_ON_SRAM_ENTRY_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_XIP_ACCESS_ON_SRAM_ENTRY_BITS   0x00100000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_XIP_ACCESS_ON_SRAM_ENTRY_MSB    20
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_XIP_ACCESS_ON_SRAM_ENTRY_LSB    20
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_XIP_ACCESS_ON_SRAM_ENTRY_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_UART_BOOT_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_UART_BOOT_BITS   0x00080000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_UART_BOOT_MSB    19
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_UART_BOOT_LSB    19
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_UART_BOOT_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_PICOBOOT_IFC_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_PICOBOOT_IFC_BITS   0x00040000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_PICOBOOT_IFC_MSB    18
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_PICOBOOT_IFC_LSB    18
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_PICOBOOT_IFC_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_MSD_IFC_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_MSD_IFC_BITS   0x00020000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_MSD_IFC_MSB    17
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_MSD_IFC_LSB    17
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_USB_MSD_IFC_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_WATCHDOG_SCRATCH_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_WATCHDOG_SCRATCH_BITS   0x00010000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_WATCHDOG_SCRATCH_MSB    16
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_WATCHDOG_SCRATCH_LSB    16
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_WATCHDOG_SCRATCH_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_POWER_SCRATCH_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_POWER_SCRATCH_BITS   0x00008000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_POWER_SCRATCH_MSB    15
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_POWER_SCRATCH_LSB    15
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_POWER_SCRATCH_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_OTP_BOOT_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_OTP_BOOT_BITS   0x00004000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_OTP_BOOT_MSB    14
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_OTP_BOOT_LSB    14
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_OTP_BOOT_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_OTP_BOOT_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_OTP_BOOT_BITS   0x00002000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_OTP_BOOT_MSB    13
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_OTP_BOOT_LSB    13
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_OTP_BOOT_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_FLASH_BOOT_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_FLASH_BOOT_BITS   0x00001000
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_FLASH_BOOT_MSB    12
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_FLASH_BOOT_LSB    12
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_FLASH_BOOT_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_ROLLBACK_REQUIRED_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ROLLBACK_REQUIRED_BITS   0x00000800
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ROLLBACK_REQUIRED_MSB    11
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ROLLBACK_REQUIRED_LSB    11
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ROLLBACK_REQUIRED_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_HASHED_PARTITION_TABLE_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_HASHED_PARTITION_TABLE_BITS   0x00000400
#define RP23XX_OTP_DATA_BOOT_FLAGS0_HASHED_PARTITION_TABLE_MSB    10
#define RP23XX_OTP_DATA_BOOT_FLAGS0_HASHED_PARTITION_TABLE_LSB    10
#define RP23XX_OTP_DATA_BOOT_FLAGS0_HASHED_PARTITION_TABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_SECURE_PARTITION_TABLE_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SECURE_PARTITION_TABLE_BITS   0x00000200
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SECURE_PARTITION_TABLE_MSB    9
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SECURE_PARTITION_TABLE_LSB    9
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SECURE_PARTITION_TABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_AUTO_SWITCH_ARCH_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_AUTO_SWITCH_ARCH_BITS   0x00000100
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_AUTO_SWITCH_ARCH_MSB    8
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_AUTO_SWITCH_ARCH_LSB    8
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_AUTO_SWITCH_ARCH_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_SINGLE_FLASH_BINARY_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SINGLE_FLASH_BINARY_BITS   0x00000080
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SINGLE_FLASH_BINARY_MSB    7
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SINGLE_FLASH_BINARY_LSB    7
#define RP23XX_OTP_DATA_BOOT_FLAGS0_SINGLE_FLASH_BINARY_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_OVERRIDE_FLASH_PARTITION_SLOT_SIZE_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_OVERRIDE_FLASH_PARTITION_SLOT_SIZE_BITS   0x00000040
#define RP23XX_OTP_DATA_BOOT_FLAGS0_OVERRIDE_FLASH_PARTITION_SLOT_SIZE_MSB    6
#define RP23XX_OTP_DATA_BOOT_FLAGS0_OVERRIDE_FLASH_PARTITION_SLOT_SIZE_LSB    6
#define RP23XX_OTP_DATA_BOOT_FLAGS0_OVERRIDE_FLASH_PARTITION_SLOT_SIZE_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_DEVINFO_ENABLE_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_DEVINFO_ENABLE_BITS   0x00000020
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_DEVINFO_ENABLE_MSB    5
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_DEVINFO_ENABLE_LSB    5
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_DEVINFO_ENABLE_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_FAST_SIGCHECK_ROSC_DIV_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FAST_SIGCHECK_ROSC_DIV_BITS   0x00000010
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FAST_SIGCHECK_ROSC_DIV_MSB    4
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FAST_SIGCHECK_ROSC_DIV_LSB    4
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FAST_SIGCHECK_ROSC_DIV_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_IO_VOLTAGE_1V8_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_IO_VOLTAGE_1V8_BITS   0x00000008
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_IO_VOLTAGE_1V8_MSB    3
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_IO_VOLTAGE_1V8_LSB    3
#define RP23XX_OTP_DATA_BOOT_FLAGS0_FLASH_IO_VOLTAGE_1V8_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG_BITS   0x00000004
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG_MSB    2
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG_LSB    2
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_LED_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_LED_BITS   0x00000002
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_LED_MSB    1
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_LED_LSB    1
#define RP23XX_OTP_DATA_BOOT_FLAGS0_ENABLE_BOOTSEL_LED_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_EXEC2_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_EXEC2_BITS   0x00000001
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_EXEC2_MSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_EXEC2_LSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS0_DISABLE_BOOTSEL_EXEC2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_ROW 0x00000049
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_WIDTH  24
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_MSB    23
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_LSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_ROW 0x0000004a
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_WIDTH  24
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_MSB    23
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_LSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS1_ROW 0x0000004b
#define RP23XX_OTP_DATA_BOOT_FLAGS1_BITS   0x000f0f0f
#define RP23XX_OTP_DATA_BOOT_FLAGS1_RESET  0x00000000
#define RP23XX_OTP_DATA_BOOT_FLAGS1_WIDTH  24

#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_BITS   0x00080000
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_MSB    19
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_LSB    19
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_DELAY_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_DELAY_BITS   0x00070000
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_DELAY_MSB    18
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_DELAY_LSB    16
#define RP23XX_OTP_DATA_BOOT_FLAGS1_DOUBLE_TAP_DELAY_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_INVALID_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_INVALID_BITS   0x00000f00
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_INVALID_MSB    11
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_INVALID_LSB    8
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_INVALID_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_VALID_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_VALID_BITS   0x0000000f
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_VALID_MSB    3
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_VALID_LSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS1_KEY_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_ROW 0x0000004c
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_WIDTH  24
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_MSB    23
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_LSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_ROW 0x0000004d
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_RESET  "-"
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_WIDTH  24
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_MSB    23
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_LSB    0
#define RP23XX_OTP_DATA_BOOT_FLAGS1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_ROW 0x0000004e
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_BITS   0x00ffffff
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_RESET  "-"
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_WIDTH  24
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_MSB    23
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_LSB    0
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_ACCESS "RO"

#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_ROW 0x0000004f
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_RESET  "-"
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_WIDTH  24
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_MSB    23
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_LSB    0
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_ROW 0x00000050
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_RESET  "-"
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_WIDTH  24
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_MSB    23
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_LSB    0
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_ROW 0x00000051
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_RESET  "-"
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_WIDTH  24
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_MSB    23
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_LSB    0
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_ACCESS "RO"

#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_ROW 0x00000052
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_RESET  "-"
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_WIDTH  24
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_MSB    23
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_LSB    0
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_ROW 0x00000053
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_RESET  "-"
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_WIDTH  24
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_MSB    23
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_LSB    0
#define RP23XX_OTP_DATA_DEFAULT_BOOT_VERSION1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_FLASH_DEVINFO_ROW 0x00000054
#define RP23XX_OTP_DATA_FLASH_DEVINFO_BITS   0x0000ffbf
#define RP23XX_OTP_DATA_FLASH_DEVINFO_RESET  0x00000000
#define RP23XX_OTP_DATA_FLASH_DEVINFO_WIDTH  16

#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_RESET  "-"
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_BITS   0x0000f000
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_MSB    15
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_LSB    12
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_ACCESS "RO"
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_NONE 0x0
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_8K 0x1
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_16K 0x2
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_32K 0x3
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_64K 0x4
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_128K 0x5
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_256K 0x6
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_512K 0x7
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_1M 0x8
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_2M 0x9
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_4M 0xa
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_8M 0xb
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_SIZE_VALUE_16M 0xc

#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_RESET  "-"
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_BITS   0x00000f00
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_MSB    11
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_LSB    8
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_ACCESS "RO"
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_NONE 0x0
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_8K 0x1
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_16K 0x2
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_32K 0x3
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_64K 0x4
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_128K 0x5
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_256K 0x6
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_512K 0x7
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_1M 0x8
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_2M 0x9
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_4M 0xa
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_8M 0xb
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS0_SIZE_VALUE_16M 0xc

#define RP23XX_OTP_DATA_FLASH_DEVINFO_D8H_ERASE_SUPPORTED_RESET  "-"
#define RP23XX_OTP_DATA_FLASH_DEVINFO_D8H_ERASE_SUPPORTED_BITS   0x00000080
#define RP23XX_OTP_DATA_FLASH_DEVINFO_D8H_ERASE_SUPPORTED_MSB    7
#define RP23XX_OTP_DATA_FLASH_DEVINFO_D8H_ERASE_SUPPORTED_LSB    7
#define RP23XX_OTP_DATA_FLASH_DEVINFO_D8H_ERASE_SUPPORTED_ACCESS "RO"

#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_GPIO_RESET  "-"
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_GPIO_BITS   0x0000003f
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_GPIO_MSB    5
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_GPIO_LSB    0
#define RP23XX_OTP_DATA_FLASH_DEVINFO_CS1_GPIO_ACCESS "RO"

#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_ROW 0x00000055
#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_BITS   0x0000ffff
#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_RESET  "-"
#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_WIDTH  16
#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_MSB    15
#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_LSB    0
#define RP23XX_OTP_DATA_FLASH_PARTITION_SLOT_SIZE_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_ROW 0x00000056
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_BITS   0x0000013f
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_RESET  0x00000000
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_WIDTH  16

#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_ACTIVELOW_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_ACTIVELOW_BITS   0x00000100
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_ACTIVELOW_MSB    8
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_ACTIVELOW_LSB    8
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_ACTIVELOW_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_PIN_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_PIN_BITS   0x0000003f
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_PIN_MSB    5
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_PIN_LSB    0
#define RP23XX_OTP_DATA_BOOTSEL_LED_CFG_PIN_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_ROW 0x00000057
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_RESET  0x00000000
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_WIDTH  16

#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_REFDIV_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_REFDIV_BITS   0x00008000
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_REFDIV_MSB    15
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_REFDIV_LSB    15
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_REFDIV_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV2_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV2_BITS   0x00007000
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV2_MSB    14
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV2_LSB    12
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV1_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV1_BITS   0x00000e00
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV1_MSB    11
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV1_LSB    9
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_POSTDIV1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_FBDIV_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_FBDIV_BITS   0x000001ff
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_FBDIV_MSB    8
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_FBDIV_LSB    0
#define RP23XX_OTP_DATA_BOOTSEL_PLL_CFG_FBDIV_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_ROW 0x00000058
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RESET  0x00000000
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_WIDTH  16

#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_BITS   0x0000c000
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_MSB    15
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_LSB    14
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_ACCESS "RO"
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_VALUE_1_15MHZ 0x0
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_VALUE_10_30MHZ 0x1
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_VALUE_25_60MHZ 0x2
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_RANGE_VALUE_40_100MHZ 0x3

#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_STARTUP_RESET  "-"
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_STARTUP_BITS   0x00003fff
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_STARTUP_MSB    13
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_STARTUP_LSB    0
#define RP23XX_OTP_DATA_BOOTSEL_XOSC_CFG_STARTUP_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_ROW 0x00000059
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_BITS   0x00c0ffff
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_RESET  0x00000000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WIDTH  24

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_DP_DM_SWAP_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_DP_DM_SWAP_BITS   0x00800000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_DP_DM_SWAP_MSB    23
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_DP_DM_SWAP_LSB    23
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_DP_DM_SWAP_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WHITE_LABEL_ADDR_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WHITE_LABEL_ADDR_VALID_BITS   0x00400000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WHITE_LABEL_ADDR_VALID_MSB    22
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WHITE_LABEL_ADDR_VALID_LSB    22
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WHITE_LABEL_ADDR_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_BOARD_ID_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_BOARD_ID_STRDEF_VALID_BITS   0x00008000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_BOARD_ID_STRDEF_VALID_MSB    15
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_BOARD_ID_STRDEF_VALID_LSB    15
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_BOARD_ID_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_MODEL_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_MODEL_STRDEF_VALID_BITS   0x00004000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_MODEL_STRDEF_VALID_MSB    14
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_MODEL_STRDEF_VALID_LSB    14
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INFO_UF2_TXT_MODEL_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_NAME_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_NAME_STRDEF_VALID_BITS   0x00002000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_NAME_STRDEF_VALID_MSB    13
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_NAME_STRDEF_VALID_LSB    13
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_NAME_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_URL_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_URL_STRDEF_VALID_BITS   0x00001000
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_URL_STRDEF_VALID_MSB    12
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_URL_STRDEF_VALID_LSB    12
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_INDEX_HTM_REDIRECT_URL_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VERSION_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VERSION_STRDEF_VALID_BITS   0x00000800
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VERSION_STRDEF_VALID_MSB    11
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VERSION_STRDEF_VALID_LSB    11
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VERSION_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_PRODUCT_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_PRODUCT_STRDEF_VALID_BITS   0x00000400
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_PRODUCT_STRDEF_VALID_MSB    10
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_PRODUCT_STRDEF_VALID_LSB    10
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_PRODUCT_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VENDOR_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VENDOR_STRDEF_VALID_BITS   0x00000200
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VENDOR_STRDEF_VALID_MSB    9
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VENDOR_STRDEF_VALID_LSB    9
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_SCSI_INQUIRY_VENDOR_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_VOLUME_LABEL_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_VOLUME_LABEL_STRDEF_VALID_BITS   0x00000100
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_VOLUME_LABEL_STRDEF_VALID_MSB    8
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_VOLUME_LABEL_STRDEF_VALID_LSB    8
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_VOLUME_LABEL_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES_VALID_BITS   0x00000080
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES_VALID_MSB    7
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES_VALID_LSB    7
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_STRDEF_VALID_BITS   0x00000040
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_STRDEF_VALID_MSB    6
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_STRDEF_VALID_LSB    6
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PRODUCT_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PRODUCT_STRDEF_VALID_BITS   0x00000020
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PRODUCT_STRDEF_VALID_MSB    5
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PRODUCT_STRDEF_VALID_LSB    5
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PRODUCT_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_MANUFACTURER_STRDEF_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_MANUFACTURER_STRDEF_VALID_BITS   0x00000010
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_MANUFACTURER_STRDEF_VALID_MSB    4
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_MANUFACTURER_STRDEF_VALID_LSB    4
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_MANUFACTURER_STRDEF_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_LANG_ID_VALUE_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_LANG_ID_VALUE_VALID_BITS   0x00000008
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_LANG_ID_VALUE_VALID_MSB    3
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_LANG_ID_VALUE_VALID_LSB    3
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_LANG_ID_VALUE_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_VALUE_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_VALUE_VALID_BITS   0x00000004
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_VALUE_VALID_MSB    2
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_VALUE_VALID_LSB    2
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_SERIAL_NUMBER_VALUE_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PID_VALUE_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PID_VALUE_VALID_BITS   0x00000002
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PID_VALUE_VALID_MSB    1
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PID_VALUE_VALID_LSB    1
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_PID_VALUE_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_VID_VALUE_VALID_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_VID_VALUE_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_VID_VALUE_VALID_MSB    0
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_VID_VALUE_VALID_LSB    0
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_WL_USB_DEVICE_VID_VALUE_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_ROW 0x0000005a
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_BITS   0x00ffffff
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_WIDTH  24
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_MSB    23
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_LSB    0
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_ROW 0x0000005b
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_BITS   0x00ffffff
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_RESET  "-"
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_WIDTH  24
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_MSB    23
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_LSB    0
#define RP23XX_OTP_DATA_USB_BOOT_FLAGS_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_ROW 0x0000005c
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_BITS   0x0000ffff
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_RESET  "-"
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_WIDTH  16
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_MSB    15
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_LSB    0
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_ACCESS "RO"
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_VID_VALUE 0x0000
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_PID_VALUE 0x0001
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_BCD_DEVICE_VALUE 0x0002
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_LANG_ID_VALUE 0x0003
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_MANUFACTURER_STRDEF 0x0004
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_PRODUCT_STRDEF 0x0005
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_DEVICE_SERIAL_NUMBER_STRDEF 0x0006
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_USB_CONFIG_ATTRIBUTES_MAX_POWER_VALUES 0x0007
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_VOLUME_LABEL_STRDEF 0x0008
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_SCSI_INQUIRY_VENDOR_STRDEF 0x0009
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_SCSI_INQUIRY_PRODUCT_STRDEF 0x000a
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_SCSI_INQUIRY_VERSION_STRDEF 0x000b
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_INDEX_HTM_REDIRECT_URL_STRDEF 0x000c
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_INDEX_HTM_REDIRECT_NAME_STRDEF 0x000d
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_INFO_UF2_TXT_MODEL_STRDEF 0x000e
#define RP23XX_OTP_DATA_USB_WHITE_LABEL_ADDR_VALUE_INDEX_INFO_UF2_TXT_BOARD_ID_STRDEF 0x000f

#define RP23XX_OTP_DATA_OTPBOOT_SRC_ROW 0x0000005e
#define RP23XX_OTP_DATA_OTPBOOT_SRC_BITS   0x0000ffff
#define RP23XX_OTP_DATA_OTPBOOT_SRC_RESET  "-"
#define RP23XX_OTP_DATA_OTPBOOT_SRC_WIDTH  16
#define RP23XX_OTP_DATA_OTPBOOT_SRC_MSB    15
#define RP23XX_OTP_DATA_OTPBOOT_SRC_LSB    0
#define RP23XX_OTP_DATA_OTPBOOT_SRC_ACCESS "RO"

#define RP23XX_OTP_DATA_OTPBOOT_LEN_ROW 0x0000005f
#define RP23XX_OTP_DATA_OTPBOOT_LEN_BITS   0x0000ffff
#define RP23XX_OTP_DATA_OTPBOOT_LEN_RESET  "-"
#define RP23XX_OTP_DATA_OTPBOOT_LEN_WIDTH  16
#define RP23XX_OTP_DATA_OTPBOOT_LEN_MSB    15
#define RP23XX_OTP_DATA_OTPBOOT_LEN_LSB    0
#define RP23XX_OTP_DATA_OTPBOOT_LEN_ACCESS "RO"

#define RP23XX_OTP_DATA_OTPBOOT_DST0_ROW 0x00000060
#define RP23XX_OTP_DATA_OTPBOOT_DST0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_OTPBOOT_DST0_RESET  "-"
#define RP23XX_OTP_DATA_OTPBOOT_DST0_WIDTH  16
#define RP23XX_OTP_DATA_OTPBOOT_DST0_MSB    15
#define RP23XX_OTP_DATA_OTPBOOT_DST0_LSB    0
#define RP23XX_OTP_DATA_OTPBOOT_DST0_ACCESS "RO"

#define RP23XX_OTP_DATA_OTPBOOT_DST1_ROW 0x00000061
#define RP23XX_OTP_DATA_OTPBOOT_DST1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_OTPBOOT_DST1_RESET  "-"
#define RP23XX_OTP_DATA_OTPBOOT_DST1_WIDTH  16
#define RP23XX_OTP_DATA_OTPBOOT_DST1_MSB    15
#define RP23XX_OTP_DATA_OTPBOOT_DST1_LSB    0
#define RP23XX_OTP_DATA_OTPBOOT_DST1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_0_ROW 0x00000080
#define RP23XX_OTP_DATA_BOOTKEY0_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_0_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_0_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_0_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_0_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_0_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_1_ROW 0x00000081
#define RP23XX_OTP_DATA_BOOTKEY0_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_1_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_1_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_1_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_1_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_2_ROW 0x00000082
#define RP23XX_OTP_DATA_BOOTKEY0_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_2_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_2_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_2_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_2_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_3_ROW 0x00000083
#define RP23XX_OTP_DATA_BOOTKEY0_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_3_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_3_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_3_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_3_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_3_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_4_ROW 0x00000084
#define RP23XX_OTP_DATA_BOOTKEY0_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_4_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_4_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_4_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_4_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_4_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_5_ROW 0x00000085
#define RP23XX_OTP_DATA_BOOTKEY0_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_5_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_5_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_5_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_5_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_5_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_6_ROW 0x00000086
#define RP23XX_OTP_DATA_BOOTKEY0_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_6_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_6_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_6_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_6_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_6_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_7_ROW 0x00000087
#define RP23XX_OTP_DATA_BOOTKEY0_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_7_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_7_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_7_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_7_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_7_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_8_ROW 0x00000088
#define RP23XX_OTP_DATA_BOOTKEY0_8_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_8_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_8_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_8_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_8_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_8_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_9_ROW 0x00000089
#define RP23XX_OTP_DATA_BOOTKEY0_9_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_9_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_9_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_9_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_9_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_9_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_10_ROW 0x0000008a
#define RP23XX_OTP_DATA_BOOTKEY0_10_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_10_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_10_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_10_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_10_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_10_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_11_ROW 0x0000008b
#define RP23XX_OTP_DATA_BOOTKEY0_11_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_11_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_11_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_11_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_11_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_11_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_12_ROW 0x0000008c
#define RP23XX_OTP_DATA_BOOTKEY0_12_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_12_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_12_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_12_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_12_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_12_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_13_ROW 0x0000008d
#define RP23XX_OTP_DATA_BOOTKEY0_13_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_13_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_13_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_13_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_13_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_13_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_14_ROW 0x0000008e
#define RP23XX_OTP_DATA_BOOTKEY0_14_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_14_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_14_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_14_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_14_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_14_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY0_15_ROW 0x0000008f
#define RP23XX_OTP_DATA_BOOTKEY0_15_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY0_15_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY0_15_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY0_15_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY0_15_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY0_15_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_0_ROW 0x00000090
#define RP23XX_OTP_DATA_BOOTKEY1_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_0_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_0_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_0_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_0_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_0_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_1_ROW 0x00000091
#define RP23XX_OTP_DATA_BOOTKEY1_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_1_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_1_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_1_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_1_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_2_ROW 0x00000092
#define RP23XX_OTP_DATA_BOOTKEY1_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_2_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_2_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_2_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_2_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_3_ROW 0x00000093
#define RP23XX_OTP_DATA_BOOTKEY1_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_3_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_3_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_3_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_3_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_3_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_4_ROW 0x00000094
#define RP23XX_OTP_DATA_BOOTKEY1_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_4_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_4_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_4_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_4_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_4_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_5_ROW 0x00000095
#define RP23XX_OTP_DATA_BOOTKEY1_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_5_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_5_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_5_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_5_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_5_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_6_ROW 0x00000096
#define RP23XX_OTP_DATA_BOOTKEY1_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_6_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_6_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_6_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_6_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_6_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_7_ROW 0x00000097
#define RP23XX_OTP_DATA_BOOTKEY1_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_7_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_7_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_7_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_7_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_7_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_8_ROW 0x00000098
#define RP23XX_OTP_DATA_BOOTKEY1_8_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_8_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_8_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_8_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_8_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_8_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_9_ROW 0x00000099
#define RP23XX_OTP_DATA_BOOTKEY1_9_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_9_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_9_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_9_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_9_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_9_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_10_ROW 0x0000009a
#define RP23XX_OTP_DATA_BOOTKEY1_10_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_10_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_10_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_10_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_10_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_10_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_11_ROW 0x0000009b
#define RP23XX_OTP_DATA_BOOTKEY1_11_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_11_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_11_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_11_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_11_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_11_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_12_ROW 0x0000009c
#define RP23XX_OTP_DATA_BOOTKEY1_12_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_12_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_12_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_12_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_12_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_12_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_13_ROW 0x0000009d
#define RP23XX_OTP_DATA_BOOTKEY1_13_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_13_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_13_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_13_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_13_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_13_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_14_ROW 0x0000009e
#define RP23XX_OTP_DATA_BOOTKEY1_14_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_14_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_14_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_14_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_14_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_14_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY1_15_ROW 0x0000009f
#define RP23XX_OTP_DATA_BOOTKEY1_15_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY1_15_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY1_15_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY1_15_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY1_15_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY1_15_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_0_ROW 0x000000a0
#define RP23XX_OTP_DATA_BOOTKEY2_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_0_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_0_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_0_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_0_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_0_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_1_ROW 0x000000a1
#define RP23XX_OTP_DATA_BOOTKEY2_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_1_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_1_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_1_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_1_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_2_ROW 0x000000a2
#define RP23XX_OTP_DATA_BOOTKEY2_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_2_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_2_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_2_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_2_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_3_ROW 0x000000a3
#define RP23XX_OTP_DATA_BOOTKEY2_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_3_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_3_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_3_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_3_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_3_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_4_ROW 0x000000a4
#define RP23XX_OTP_DATA_BOOTKEY2_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_4_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_4_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_4_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_4_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_4_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_5_ROW 0x000000a5
#define RP23XX_OTP_DATA_BOOTKEY2_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_5_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_5_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_5_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_5_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_5_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_6_ROW 0x000000a6
#define RP23XX_OTP_DATA_BOOTKEY2_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_6_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_6_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_6_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_6_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_6_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_7_ROW 0x000000a7
#define RP23XX_OTP_DATA_BOOTKEY2_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_7_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_7_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_7_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_7_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_7_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_8_ROW 0x000000a8
#define RP23XX_OTP_DATA_BOOTKEY2_8_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_8_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_8_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_8_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_8_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_8_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_9_ROW 0x000000a9
#define RP23XX_OTP_DATA_BOOTKEY2_9_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_9_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_9_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_9_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_9_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_9_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_10_ROW 0x000000aa
#define RP23XX_OTP_DATA_BOOTKEY2_10_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_10_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_10_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_10_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_10_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_10_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_11_ROW 0x000000ab
#define RP23XX_OTP_DATA_BOOTKEY2_11_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_11_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_11_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_11_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_11_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_11_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_12_ROW 0x000000ac
#define RP23XX_OTP_DATA_BOOTKEY2_12_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_12_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_12_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_12_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_12_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_12_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_13_ROW 0x000000ad
#define RP23XX_OTP_DATA_BOOTKEY2_13_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_13_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_13_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_13_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_13_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_13_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_14_ROW 0x000000ae
#define RP23XX_OTP_DATA_BOOTKEY2_14_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_14_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_14_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_14_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_14_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_14_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY2_15_ROW 0x000000af
#define RP23XX_OTP_DATA_BOOTKEY2_15_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY2_15_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY2_15_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY2_15_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY2_15_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY2_15_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_0_ROW 0x000000b0
#define RP23XX_OTP_DATA_BOOTKEY3_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_0_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_0_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_0_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_0_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_0_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_1_ROW 0x000000b1
#define RP23XX_OTP_DATA_BOOTKEY3_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_1_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_1_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_1_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_1_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_1_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_2_ROW 0x000000b2
#define RP23XX_OTP_DATA_BOOTKEY3_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_2_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_2_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_2_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_2_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_2_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_3_ROW 0x000000b3
#define RP23XX_OTP_DATA_BOOTKEY3_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_3_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_3_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_3_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_3_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_3_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_4_ROW 0x000000b4
#define RP23XX_OTP_DATA_BOOTKEY3_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_4_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_4_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_4_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_4_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_4_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_5_ROW 0x000000b5
#define RP23XX_OTP_DATA_BOOTKEY3_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_5_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_5_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_5_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_5_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_5_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_6_ROW 0x000000b6
#define RP23XX_OTP_DATA_BOOTKEY3_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_6_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_6_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_6_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_6_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_6_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_7_ROW 0x000000b7
#define RP23XX_OTP_DATA_BOOTKEY3_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_7_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_7_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_7_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_7_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_7_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_8_ROW 0x000000b8
#define RP23XX_OTP_DATA_BOOTKEY3_8_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_8_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_8_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_8_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_8_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_8_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_9_ROW 0x000000b9
#define RP23XX_OTP_DATA_BOOTKEY3_9_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_9_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_9_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_9_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_9_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_9_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_10_ROW 0x000000ba
#define RP23XX_OTP_DATA_BOOTKEY3_10_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_10_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_10_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_10_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_10_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_10_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_11_ROW 0x000000bb
#define RP23XX_OTP_DATA_BOOTKEY3_11_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_11_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_11_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_11_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_11_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_11_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_12_ROW 0x000000bc
#define RP23XX_OTP_DATA_BOOTKEY3_12_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_12_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_12_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_12_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_12_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_12_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_13_ROW 0x000000bd
#define RP23XX_OTP_DATA_BOOTKEY3_13_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_13_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_13_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_13_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_13_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_13_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_14_ROW 0x000000be
#define RP23XX_OTP_DATA_BOOTKEY3_14_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_14_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_14_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_14_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_14_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_14_ACCESS "RO"

#define RP23XX_OTP_DATA_BOOTKEY3_15_ROW 0x000000bf
#define RP23XX_OTP_DATA_BOOTKEY3_15_BITS   0x0000ffff
#define RP23XX_OTP_DATA_BOOTKEY3_15_RESET  "-"
#define RP23XX_OTP_DATA_BOOTKEY3_15_WIDTH  16
#define RP23XX_OTP_DATA_BOOTKEY3_15_MSB    15
#define RP23XX_OTP_DATA_BOOTKEY3_15_LSB    0
#define RP23XX_OTP_DATA_BOOTKEY3_15_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_0_ROW 0x00000f48
#define RP23XX_OTP_DATA_KEY1_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_0_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_0_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_0_MSB    15
#define RP23XX_OTP_DATA_KEY1_0_LSB    0
#define RP23XX_OTP_DATA_KEY1_0_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_1_ROW 0x00000f49
#define RP23XX_OTP_DATA_KEY1_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_1_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_1_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_1_MSB    15
#define RP23XX_OTP_DATA_KEY1_1_LSB    0
#define RP23XX_OTP_DATA_KEY1_1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_2_ROW 0x00000f4a
#define RP23XX_OTP_DATA_KEY1_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_2_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_2_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_2_MSB    15
#define RP23XX_OTP_DATA_KEY1_2_LSB    0
#define RP23XX_OTP_DATA_KEY1_2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_3_ROW 0x00000f4b
#define RP23XX_OTP_DATA_KEY1_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_3_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_3_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_3_MSB    15
#define RP23XX_OTP_DATA_KEY1_3_LSB    0
#define RP23XX_OTP_DATA_KEY1_3_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_4_ROW 0x00000f4c
#define RP23XX_OTP_DATA_KEY1_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_4_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_4_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_4_MSB    15
#define RP23XX_OTP_DATA_KEY1_4_LSB    0
#define RP23XX_OTP_DATA_KEY1_4_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_5_ROW 0x00000f4d
#define RP23XX_OTP_DATA_KEY1_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_5_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_5_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_5_MSB    15
#define RP23XX_OTP_DATA_KEY1_5_LSB    0
#define RP23XX_OTP_DATA_KEY1_5_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_6_ROW 0x00000f4e
#define RP23XX_OTP_DATA_KEY1_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_6_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_6_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_6_MSB    15
#define RP23XX_OTP_DATA_KEY1_6_LSB    0
#define RP23XX_OTP_DATA_KEY1_6_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_7_ROW 0x00000f4f
#define RP23XX_OTP_DATA_KEY1_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY1_7_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_7_WIDTH  16
#define RP23XX_OTP_DATA_KEY1_7_MSB    15
#define RP23XX_OTP_DATA_KEY1_7_LSB    0
#define RP23XX_OTP_DATA_KEY1_7_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_0_ROW 0x00000f50
#define RP23XX_OTP_DATA_KEY2_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_0_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_0_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_0_MSB    15
#define RP23XX_OTP_DATA_KEY2_0_LSB    0
#define RP23XX_OTP_DATA_KEY2_0_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_1_ROW 0x00000f51
#define RP23XX_OTP_DATA_KEY2_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_1_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_1_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_1_MSB    15
#define RP23XX_OTP_DATA_KEY2_1_LSB    0
#define RP23XX_OTP_DATA_KEY2_1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_2_ROW 0x00000f52
#define RP23XX_OTP_DATA_KEY2_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_2_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_2_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_2_MSB    15
#define RP23XX_OTP_DATA_KEY2_2_LSB    0
#define RP23XX_OTP_DATA_KEY2_2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_3_ROW 0x00000f53
#define RP23XX_OTP_DATA_KEY2_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_3_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_3_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_3_MSB    15
#define RP23XX_OTP_DATA_KEY2_3_LSB    0
#define RP23XX_OTP_DATA_KEY2_3_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_4_ROW 0x00000f54
#define RP23XX_OTP_DATA_KEY2_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_4_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_4_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_4_MSB    15
#define RP23XX_OTP_DATA_KEY2_4_LSB    0
#define RP23XX_OTP_DATA_KEY2_4_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_5_ROW 0x00000f55
#define RP23XX_OTP_DATA_KEY2_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_5_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_5_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_5_MSB    15
#define RP23XX_OTP_DATA_KEY2_5_LSB    0
#define RP23XX_OTP_DATA_KEY2_5_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_6_ROW 0x00000f56
#define RP23XX_OTP_DATA_KEY2_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_6_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_6_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_6_MSB    15
#define RP23XX_OTP_DATA_KEY2_6_LSB    0
#define RP23XX_OTP_DATA_KEY2_6_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_7_ROW 0x00000f57
#define RP23XX_OTP_DATA_KEY2_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY2_7_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_7_WIDTH  16
#define RP23XX_OTP_DATA_KEY2_7_MSB    15
#define RP23XX_OTP_DATA_KEY2_7_LSB    0
#define RP23XX_OTP_DATA_KEY2_7_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_0_ROW 0x00000f58
#define RP23XX_OTP_DATA_KEY3_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_0_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_0_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_0_MSB    15
#define RP23XX_OTP_DATA_KEY3_0_LSB    0
#define RP23XX_OTP_DATA_KEY3_0_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_1_ROW 0x00000f59
#define RP23XX_OTP_DATA_KEY3_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_1_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_1_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_1_MSB    15
#define RP23XX_OTP_DATA_KEY3_1_LSB    0
#define RP23XX_OTP_DATA_KEY3_1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_2_ROW 0x00000f5a
#define RP23XX_OTP_DATA_KEY3_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_2_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_2_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_2_MSB    15
#define RP23XX_OTP_DATA_KEY3_2_LSB    0
#define RP23XX_OTP_DATA_KEY3_2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_3_ROW 0x00000f5b
#define RP23XX_OTP_DATA_KEY3_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_3_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_3_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_3_MSB    15
#define RP23XX_OTP_DATA_KEY3_3_LSB    0
#define RP23XX_OTP_DATA_KEY3_3_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_4_ROW 0x00000f5c
#define RP23XX_OTP_DATA_KEY3_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_4_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_4_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_4_MSB    15
#define RP23XX_OTP_DATA_KEY3_4_LSB    0
#define RP23XX_OTP_DATA_KEY3_4_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_5_ROW 0x00000f5d
#define RP23XX_OTP_DATA_KEY3_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_5_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_5_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_5_MSB    15
#define RP23XX_OTP_DATA_KEY3_5_LSB    0
#define RP23XX_OTP_DATA_KEY3_5_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_6_ROW 0x00000f5e
#define RP23XX_OTP_DATA_KEY3_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_6_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_6_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_6_MSB    15
#define RP23XX_OTP_DATA_KEY3_6_LSB    0
#define RP23XX_OTP_DATA_KEY3_6_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_7_ROW 0x00000f5f
#define RP23XX_OTP_DATA_KEY3_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY3_7_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_7_WIDTH  16
#define RP23XX_OTP_DATA_KEY3_7_MSB    15
#define RP23XX_OTP_DATA_KEY3_7_LSB    0
#define RP23XX_OTP_DATA_KEY3_7_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_0_ROW 0x00000f60
#define RP23XX_OTP_DATA_KEY4_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_0_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_0_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_0_MSB    15
#define RP23XX_OTP_DATA_KEY4_0_LSB    0
#define RP23XX_OTP_DATA_KEY4_0_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_1_ROW 0x00000f61
#define RP23XX_OTP_DATA_KEY4_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_1_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_1_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_1_MSB    15
#define RP23XX_OTP_DATA_KEY4_1_LSB    0
#define RP23XX_OTP_DATA_KEY4_1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_2_ROW 0x00000f62
#define RP23XX_OTP_DATA_KEY4_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_2_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_2_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_2_MSB    15
#define RP23XX_OTP_DATA_KEY4_2_LSB    0
#define RP23XX_OTP_DATA_KEY4_2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_3_ROW 0x00000f63
#define RP23XX_OTP_DATA_KEY4_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_3_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_3_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_3_MSB    15
#define RP23XX_OTP_DATA_KEY4_3_LSB    0
#define RP23XX_OTP_DATA_KEY4_3_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_4_ROW 0x00000f64
#define RP23XX_OTP_DATA_KEY4_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_4_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_4_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_4_MSB    15
#define RP23XX_OTP_DATA_KEY4_4_LSB    0
#define RP23XX_OTP_DATA_KEY4_4_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_5_ROW 0x00000f65
#define RP23XX_OTP_DATA_KEY4_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_5_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_5_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_5_MSB    15
#define RP23XX_OTP_DATA_KEY4_5_LSB    0
#define RP23XX_OTP_DATA_KEY4_5_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_6_ROW 0x00000f66
#define RP23XX_OTP_DATA_KEY4_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_6_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_6_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_6_MSB    15
#define RP23XX_OTP_DATA_KEY4_6_LSB    0
#define RP23XX_OTP_DATA_KEY4_6_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_7_ROW 0x00000f67
#define RP23XX_OTP_DATA_KEY4_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY4_7_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_7_WIDTH  16
#define RP23XX_OTP_DATA_KEY4_7_MSB    15
#define RP23XX_OTP_DATA_KEY4_7_LSB    0
#define RP23XX_OTP_DATA_KEY4_7_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_0_ROW 0x00000f68
#define RP23XX_OTP_DATA_KEY5_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_0_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_0_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_0_MSB    15
#define RP23XX_OTP_DATA_KEY5_0_LSB    0
#define RP23XX_OTP_DATA_KEY5_0_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_1_ROW 0x00000f69
#define RP23XX_OTP_DATA_KEY5_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_1_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_1_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_1_MSB    15
#define RP23XX_OTP_DATA_KEY5_1_LSB    0
#define RP23XX_OTP_DATA_KEY5_1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_2_ROW 0x00000f6a
#define RP23XX_OTP_DATA_KEY5_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_2_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_2_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_2_MSB    15
#define RP23XX_OTP_DATA_KEY5_2_LSB    0
#define RP23XX_OTP_DATA_KEY5_2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_3_ROW 0x00000f6b
#define RP23XX_OTP_DATA_KEY5_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_3_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_3_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_3_MSB    15
#define RP23XX_OTP_DATA_KEY5_3_LSB    0
#define RP23XX_OTP_DATA_KEY5_3_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_4_ROW 0x00000f6c
#define RP23XX_OTP_DATA_KEY5_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_4_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_4_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_4_MSB    15
#define RP23XX_OTP_DATA_KEY5_4_LSB    0
#define RP23XX_OTP_DATA_KEY5_4_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_5_ROW 0x00000f6d
#define RP23XX_OTP_DATA_KEY5_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_5_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_5_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_5_MSB    15
#define RP23XX_OTP_DATA_KEY5_5_LSB    0
#define RP23XX_OTP_DATA_KEY5_5_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_6_ROW 0x00000f6e
#define RP23XX_OTP_DATA_KEY5_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_6_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_6_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_6_MSB    15
#define RP23XX_OTP_DATA_KEY5_6_LSB    0
#define RP23XX_OTP_DATA_KEY5_6_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_7_ROW 0x00000f6f
#define RP23XX_OTP_DATA_KEY5_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY5_7_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_7_WIDTH  16
#define RP23XX_OTP_DATA_KEY5_7_MSB    15
#define RP23XX_OTP_DATA_KEY5_7_LSB    0
#define RP23XX_OTP_DATA_KEY5_7_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_0_ROW 0x00000f70
#define RP23XX_OTP_DATA_KEY6_0_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_0_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_0_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_0_MSB    15
#define RP23XX_OTP_DATA_KEY6_0_LSB    0
#define RP23XX_OTP_DATA_KEY6_0_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_1_ROW 0x00000f71
#define RP23XX_OTP_DATA_KEY6_1_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_1_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_1_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_1_MSB    15
#define RP23XX_OTP_DATA_KEY6_1_LSB    0
#define RP23XX_OTP_DATA_KEY6_1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_2_ROW 0x00000f72
#define RP23XX_OTP_DATA_KEY6_2_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_2_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_2_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_2_MSB    15
#define RP23XX_OTP_DATA_KEY6_2_LSB    0
#define RP23XX_OTP_DATA_KEY6_2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_3_ROW 0x00000f73
#define RP23XX_OTP_DATA_KEY6_3_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_3_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_3_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_3_MSB    15
#define RP23XX_OTP_DATA_KEY6_3_LSB    0
#define RP23XX_OTP_DATA_KEY6_3_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_4_ROW 0x00000f74
#define RP23XX_OTP_DATA_KEY6_4_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_4_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_4_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_4_MSB    15
#define RP23XX_OTP_DATA_KEY6_4_LSB    0
#define RP23XX_OTP_DATA_KEY6_4_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_5_ROW 0x00000f75
#define RP23XX_OTP_DATA_KEY6_5_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_5_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_5_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_5_MSB    15
#define RP23XX_OTP_DATA_KEY6_5_LSB    0
#define RP23XX_OTP_DATA_KEY6_5_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_6_ROW 0x00000f76
#define RP23XX_OTP_DATA_KEY6_6_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_6_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_6_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_6_MSB    15
#define RP23XX_OTP_DATA_KEY6_6_LSB    0
#define RP23XX_OTP_DATA_KEY6_6_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_7_ROW 0x00000f77
#define RP23XX_OTP_DATA_KEY6_7_BITS   0x0000ffff
#define RP23XX_OTP_DATA_KEY6_7_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_7_WIDTH  16
#define RP23XX_OTP_DATA_KEY6_7_MSB    15
#define RP23XX_OTP_DATA_KEY6_7_LSB    0
#define RP23XX_OTP_DATA_KEY6_7_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_VALID_ROW 0x00000f79
#define RP23XX_OTP_DATA_KEY1_VALID_BITS   0x00010101
#define RP23XX_OTP_DATA_KEY1_VALID_RESET  0x00000000
#define RP23XX_OTP_DATA_KEY1_VALID_WIDTH  24

#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R2_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R2_BITS   0x00010000
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R2_MSB    16
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R2_LSB    16
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R1_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R1_BITS   0x00000100
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R1_MSB    8
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R1_LSB    8
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY1_VALID_VALID_RESET  "-"
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_MSB    0
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_LSB    0
#define RP23XX_OTP_DATA_KEY1_VALID_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_VALID_ROW 0x00000f7a
#define RP23XX_OTP_DATA_KEY2_VALID_BITS   0x00010101
#define RP23XX_OTP_DATA_KEY2_VALID_RESET  0x00000000
#define RP23XX_OTP_DATA_KEY2_VALID_WIDTH  24

#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R2_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R2_BITS   0x00010000
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R2_MSB    16
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R2_LSB    16
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R1_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R1_BITS   0x00000100
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R1_MSB    8
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R1_LSB    8
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY2_VALID_VALID_RESET  "-"
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_MSB    0
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_LSB    0
#define RP23XX_OTP_DATA_KEY2_VALID_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_VALID_ROW 0x00000f7b
#define RP23XX_OTP_DATA_KEY3_VALID_BITS   0x00010101
#define RP23XX_OTP_DATA_KEY3_VALID_RESET  0x00000000
#define RP23XX_OTP_DATA_KEY3_VALID_WIDTH  24

#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R2_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R2_BITS   0x00010000
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R2_MSB    16
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R2_LSB    16
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R1_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R1_BITS   0x00000100
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R1_MSB    8
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R1_LSB    8
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY3_VALID_VALID_RESET  "-"
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_MSB    0
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_LSB    0
#define RP23XX_OTP_DATA_KEY3_VALID_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_VALID_ROW 0x00000f7c
#define RP23XX_OTP_DATA_KEY4_VALID_BITS   0x00010101
#define RP23XX_OTP_DATA_KEY4_VALID_RESET  0x00000000
#define RP23XX_OTP_DATA_KEY4_VALID_WIDTH  24

#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R2_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R2_BITS   0x00010000
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R2_MSB    16
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R2_LSB    16
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R1_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R1_BITS   0x00000100
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R1_MSB    8
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R1_LSB    8
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY4_VALID_VALID_RESET  "-"
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_MSB    0
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_LSB    0
#define RP23XX_OTP_DATA_KEY4_VALID_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_VALID_ROW 0x00000f7d
#define RP23XX_OTP_DATA_KEY5_VALID_BITS   0x00010101
#define RP23XX_OTP_DATA_KEY5_VALID_RESET  0x00000000
#define RP23XX_OTP_DATA_KEY5_VALID_WIDTH  24

#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R2_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R2_BITS   0x00010000
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R2_MSB    16
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R2_LSB    16
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R1_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R1_BITS   0x00000100
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R1_MSB    8
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R1_LSB    8
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY5_VALID_VALID_RESET  "-"
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_MSB    0
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_LSB    0
#define RP23XX_OTP_DATA_KEY5_VALID_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_VALID_ROW 0x00000f7e
#define RP23XX_OTP_DATA_KEY6_VALID_BITS   0x00010101
#define RP23XX_OTP_DATA_KEY6_VALID_RESET  0x00000000
#define RP23XX_OTP_DATA_KEY6_VALID_WIDTH  24

#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R2_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R2_BITS   0x00010000
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R2_MSB    16
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R2_LSB    16
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R1_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R1_BITS   0x00000100
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R1_MSB    8
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R1_LSB    8
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_KEY6_VALID_VALID_RESET  "-"
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_BITS   0x00000001
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_MSB    0
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_LSB    0
#define RP23XX_OTP_DATA_KEY6_VALID_VALID_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK0_ROW 0x00000f80
#define RP23XX_OTP_DATA_PAGE0_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE0_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE0_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE0_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE0_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE0_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE0_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK1_ROW 0x00000f81
#define RP23XX_OTP_DATA_PAGE0_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE0_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE0_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE0_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE0_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE0_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE1_LOCK0_ROW 0x00000f82
#define RP23XX_OTP_DATA_PAGE1_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE1_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE1_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE1_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE1_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE1_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE1_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE1_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE1_LOCK1_ROW 0x00000f83
#define RP23XX_OTP_DATA_PAGE1_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE1_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE1_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE1_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE1_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE1_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE1_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE2_LOCK0_ROW 0x00000f84
#define RP23XX_OTP_DATA_PAGE2_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE2_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE2_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE2_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE2_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE2_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE2_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE2_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE2_LOCK1_ROW 0x00000f85
#define RP23XX_OTP_DATA_PAGE2_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE2_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE2_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE2_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE2_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE2_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE2_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE3_LOCK0_ROW 0x00000f86
#define RP23XX_OTP_DATA_PAGE3_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE3_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE3_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE3_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE3_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE3_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE3_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE3_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE3_LOCK1_ROW 0x00000f87
#define RP23XX_OTP_DATA_PAGE3_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE3_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE3_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE3_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE3_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE3_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE3_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE4_LOCK0_ROW 0x00000f88
#define RP23XX_OTP_DATA_PAGE4_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE4_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE4_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE4_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE4_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE4_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE4_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE4_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE4_LOCK1_ROW 0x00000f89
#define RP23XX_OTP_DATA_PAGE4_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE4_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE4_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE4_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE4_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE4_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE4_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE5_LOCK0_ROW 0x00000f8a
#define RP23XX_OTP_DATA_PAGE5_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE5_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE5_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE5_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE5_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE5_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE5_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE5_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE5_LOCK1_ROW 0x00000f8b
#define RP23XX_OTP_DATA_PAGE5_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE5_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE5_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE5_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE5_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE5_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE5_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE6_LOCK0_ROW 0x00000f8c
#define RP23XX_OTP_DATA_PAGE6_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE6_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE6_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE6_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE6_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE6_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE6_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE6_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE6_LOCK1_ROW 0x00000f8d
#define RP23XX_OTP_DATA_PAGE6_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE6_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE6_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE6_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE6_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE6_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE6_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE7_LOCK0_ROW 0x00000f8e
#define RP23XX_OTP_DATA_PAGE7_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE7_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE7_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE7_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE7_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE7_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE7_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE7_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE7_LOCK1_ROW 0x00000f8f
#define RP23XX_OTP_DATA_PAGE7_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE7_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE7_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE7_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE7_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE7_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE7_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE8_LOCK0_ROW 0x00000f90
#define RP23XX_OTP_DATA_PAGE8_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE8_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE8_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE8_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE8_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE8_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE8_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE8_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE8_LOCK1_ROW 0x00000f91
#define RP23XX_OTP_DATA_PAGE8_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE8_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE8_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE8_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE8_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE8_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE8_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE9_LOCK0_ROW 0x00000f92
#define RP23XX_OTP_DATA_PAGE9_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE9_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE9_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE9_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE9_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE9_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE9_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE9_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE9_LOCK1_ROW 0x00000f93
#define RP23XX_OTP_DATA_PAGE9_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE9_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE9_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE9_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE9_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE9_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE9_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE10_LOCK0_ROW 0x00000f94
#define RP23XX_OTP_DATA_PAGE10_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE10_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE10_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE10_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE10_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE10_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE10_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE10_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE10_LOCK1_ROW 0x00000f95
#define RP23XX_OTP_DATA_PAGE10_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE10_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE10_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE10_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE10_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE10_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE10_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE11_LOCK0_ROW 0x00000f96
#define RP23XX_OTP_DATA_PAGE11_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE11_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE11_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE11_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE11_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE11_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE11_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE11_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE11_LOCK1_ROW 0x00000f97
#define RP23XX_OTP_DATA_PAGE11_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE11_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE11_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE11_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE11_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE11_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE11_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE12_LOCK0_ROW 0x00000f98
#define RP23XX_OTP_DATA_PAGE12_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE12_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE12_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE12_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE12_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE12_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE12_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE12_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE12_LOCK1_ROW 0x00000f99
#define RP23XX_OTP_DATA_PAGE12_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE12_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE12_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE12_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE12_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE12_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE12_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE13_LOCK0_ROW 0x00000f9a
#define RP23XX_OTP_DATA_PAGE13_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE13_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE13_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE13_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE13_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE13_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE13_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE13_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE13_LOCK1_ROW 0x00000f9b
#define RP23XX_OTP_DATA_PAGE13_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE13_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE13_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE13_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE13_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE13_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE13_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE14_LOCK0_ROW 0x00000f9c
#define RP23XX_OTP_DATA_PAGE14_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE14_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE14_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE14_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE14_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE14_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE14_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE14_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE14_LOCK1_ROW 0x00000f9d
#define RP23XX_OTP_DATA_PAGE14_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE14_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE14_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE14_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE14_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE14_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE14_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE15_LOCK0_ROW 0x00000f9e
#define RP23XX_OTP_DATA_PAGE15_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE15_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE15_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE15_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE15_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE15_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE15_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE15_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE15_LOCK1_ROW 0x00000f9f
#define RP23XX_OTP_DATA_PAGE15_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE15_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE15_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE15_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE15_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE15_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE15_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE16_LOCK0_ROW 0x00000fa0
#define RP23XX_OTP_DATA_PAGE16_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE16_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE16_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE16_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE16_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE16_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE16_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE16_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE16_LOCK1_ROW 0x00000fa1
#define RP23XX_OTP_DATA_PAGE16_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE16_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE16_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE16_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE16_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE16_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE16_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE17_LOCK0_ROW 0x00000fa2
#define RP23XX_OTP_DATA_PAGE17_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE17_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE17_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE17_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE17_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE17_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE17_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE17_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE17_LOCK1_ROW 0x00000fa3
#define RP23XX_OTP_DATA_PAGE17_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE17_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE17_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE17_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE17_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE17_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE17_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE18_LOCK0_ROW 0x00000fa4
#define RP23XX_OTP_DATA_PAGE18_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE18_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE18_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE18_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE18_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE18_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE18_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE18_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE18_LOCK1_ROW 0x00000fa5
#define RP23XX_OTP_DATA_PAGE18_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE18_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE18_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE18_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE18_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE18_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE18_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE19_LOCK0_ROW 0x00000fa6
#define RP23XX_OTP_DATA_PAGE19_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE19_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE19_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE19_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE19_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE19_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE19_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE19_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE19_LOCK1_ROW 0x00000fa7
#define RP23XX_OTP_DATA_PAGE19_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE19_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE19_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE19_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE19_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE19_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE19_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE20_LOCK0_ROW 0x00000fa8
#define RP23XX_OTP_DATA_PAGE20_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE20_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE20_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE20_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE20_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE20_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE20_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE20_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE20_LOCK1_ROW 0x00000fa9
#define RP23XX_OTP_DATA_PAGE20_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE20_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE20_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE20_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE20_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE20_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE20_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE21_LOCK0_ROW 0x00000faa
#define RP23XX_OTP_DATA_PAGE21_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE21_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE21_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE21_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE21_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE21_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE21_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE21_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE21_LOCK1_ROW 0x00000fab
#define RP23XX_OTP_DATA_PAGE21_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE21_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE21_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE21_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE21_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE21_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE21_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE22_LOCK0_ROW 0x00000fac
#define RP23XX_OTP_DATA_PAGE22_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE22_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE22_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE22_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE22_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE22_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE22_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE22_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE22_LOCK1_ROW 0x00000fad
#define RP23XX_OTP_DATA_PAGE22_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE22_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE22_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE22_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE22_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE22_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE22_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE23_LOCK0_ROW 0x00000fae
#define RP23XX_OTP_DATA_PAGE23_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE23_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE23_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE23_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE23_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE23_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE23_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE23_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE23_LOCK1_ROW 0x00000faf
#define RP23XX_OTP_DATA_PAGE23_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE23_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE23_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE23_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE23_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE23_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE23_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE24_LOCK0_ROW 0x00000fb0
#define RP23XX_OTP_DATA_PAGE24_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE24_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE24_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE24_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE24_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE24_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE24_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE24_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE24_LOCK1_ROW 0x00000fb1
#define RP23XX_OTP_DATA_PAGE24_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE24_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE24_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE24_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE24_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE24_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE24_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE25_LOCK0_ROW 0x00000fb2
#define RP23XX_OTP_DATA_PAGE25_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE25_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE25_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE25_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE25_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE25_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE25_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE25_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE25_LOCK1_ROW 0x00000fb3
#define RP23XX_OTP_DATA_PAGE25_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE25_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE25_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE25_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE25_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE25_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE25_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE26_LOCK0_ROW 0x00000fb4
#define RP23XX_OTP_DATA_PAGE26_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE26_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE26_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE26_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE26_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE26_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE26_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE26_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE26_LOCK1_ROW 0x00000fb5
#define RP23XX_OTP_DATA_PAGE26_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE26_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE26_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE26_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE26_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE26_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE26_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE27_LOCK0_ROW 0x00000fb6
#define RP23XX_OTP_DATA_PAGE27_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE27_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE27_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE27_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE27_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE27_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE27_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE27_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE27_LOCK1_ROW 0x00000fb7
#define RP23XX_OTP_DATA_PAGE27_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE27_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE27_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE27_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE27_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE27_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE27_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE28_LOCK0_ROW 0x00000fb8
#define RP23XX_OTP_DATA_PAGE28_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE28_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE28_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE28_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE28_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE28_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE28_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE28_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE28_LOCK1_ROW 0x00000fb9
#define RP23XX_OTP_DATA_PAGE28_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE28_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE28_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE28_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE28_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE28_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE28_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE29_LOCK0_ROW 0x00000fba
#define RP23XX_OTP_DATA_PAGE29_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE29_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE29_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE29_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE29_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE29_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE29_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE29_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE29_LOCK1_ROW 0x00000fbb
#define RP23XX_OTP_DATA_PAGE29_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE29_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE29_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE29_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE29_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE29_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE29_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE30_LOCK0_ROW 0x00000fbc
#define RP23XX_OTP_DATA_PAGE30_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE30_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE30_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE30_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE30_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE30_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE30_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE30_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE30_LOCK1_ROW 0x00000fbd
#define RP23XX_OTP_DATA_PAGE30_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE30_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE30_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE30_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE30_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE30_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE30_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE31_LOCK0_ROW 0x00000fbe
#define RP23XX_OTP_DATA_PAGE31_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE31_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE31_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE31_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE31_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE31_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE31_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE31_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE31_LOCK1_ROW 0x00000fbf
#define RP23XX_OTP_DATA_PAGE31_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE31_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE31_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE31_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE31_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE31_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE31_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE32_LOCK0_ROW 0x00000fc0
#define RP23XX_OTP_DATA_PAGE32_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE32_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE32_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE32_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE32_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE32_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE32_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE32_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE32_LOCK1_ROW 0x00000fc1
#define RP23XX_OTP_DATA_PAGE32_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE32_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE32_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE32_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE32_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE32_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE32_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE33_LOCK0_ROW 0x00000fc2
#define RP23XX_OTP_DATA_PAGE33_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE33_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE33_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE33_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE33_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE33_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE33_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE33_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE33_LOCK1_ROW 0x00000fc3
#define RP23XX_OTP_DATA_PAGE33_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE33_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE33_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE33_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE33_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE33_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE33_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE34_LOCK0_ROW 0x00000fc4
#define RP23XX_OTP_DATA_PAGE34_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE34_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE34_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE34_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE34_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE34_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE34_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE34_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE34_LOCK1_ROW 0x00000fc5
#define RP23XX_OTP_DATA_PAGE34_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE34_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE34_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE34_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE34_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE34_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE34_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE35_LOCK0_ROW 0x00000fc6
#define RP23XX_OTP_DATA_PAGE35_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE35_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE35_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE35_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE35_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE35_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE35_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE35_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE35_LOCK1_ROW 0x00000fc7
#define RP23XX_OTP_DATA_PAGE35_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE35_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE35_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE35_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE35_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE35_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE35_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE36_LOCK0_ROW 0x00000fc8
#define RP23XX_OTP_DATA_PAGE36_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE36_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE36_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE36_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE36_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE36_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE36_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE36_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE36_LOCK1_ROW 0x00000fc9
#define RP23XX_OTP_DATA_PAGE36_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE36_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE36_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE36_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE36_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE36_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE36_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE37_LOCK0_ROW 0x00000fca
#define RP23XX_OTP_DATA_PAGE37_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE37_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE37_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE37_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE37_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE37_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE37_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE37_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE37_LOCK1_ROW 0x00000fcb
#define RP23XX_OTP_DATA_PAGE37_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE37_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE37_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE37_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE37_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE37_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE37_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE38_LOCK0_ROW 0x00000fcc
#define RP23XX_OTP_DATA_PAGE38_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE38_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE38_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE38_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE38_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE38_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE38_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE38_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE38_LOCK1_ROW 0x00000fcd
#define RP23XX_OTP_DATA_PAGE38_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE38_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE38_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE38_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE38_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE38_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE38_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE39_LOCK0_ROW 0x00000fce
#define RP23XX_OTP_DATA_PAGE39_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE39_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE39_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE39_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE39_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE39_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE39_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE39_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE39_LOCK1_ROW 0x00000fcf
#define RP23XX_OTP_DATA_PAGE39_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE39_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE39_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE39_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE39_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE39_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE39_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE40_LOCK0_ROW 0x00000fd0
#define RP23XX_OTP_DATA_PAGE40_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE40_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE40_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE40_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE40_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE40_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE40_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE40_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE40_LOCK1_ROW 0x00000fd1
#define RP23XX_OTP_DATA_PAGE40_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE40_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE40_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE40_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE40_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE40_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE40_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE41_LOCK0_ROW 0x00000fd2
#define RP23XX_OTP_DATA_PAGE41_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE41_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE41_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE41_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE41_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE41_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE41_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE41_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE41_LOCK1_ROW 0x00000fd3
#define RP23XX_OTP_DATA_PAGE41_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE41_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE41_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE41_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE41_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE41_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE41_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE42_LOCK0_ROW 0x00000fd4
#define RP23XX_OTP_DATA_PAGE42_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE42_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE42_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE42_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE42_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE42_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE42_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE42_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE42_LOCK1_ROW 0x00000fd5
#define RP23XX_OTP_DATA_PAGE42_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE42_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE42_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE42_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE42_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE42_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE42_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE43_LOCK0_ROW 0x00000fd6
#define RP23XX_OTP_DATA_PAGE43_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE43_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE43_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE43_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE43_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE43_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE43_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE43_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE43_LOCK1_ROW 0x00000fd7
#define RP23XX_OTP_DATA_PAGE43_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE43_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE43_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE43_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE43_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE43_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE43_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE44_LOCK0_ROW 0x00000fd8
#define RP23XX_OTP_DATA_PAGE44_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE44_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE44_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE44_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE44_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE44_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE44_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE44_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE44_LOCK1_ROW 0x00000fd9
#define RP23XX_OTP_DATA_PAGE44_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE44_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE44_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE44_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE44_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE44_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE44_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE45_LOCK0_ROW 0x00000fda
#define RP23XX_OTP_DATA_PAGE45_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE45_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE45_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE45_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE45_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE45_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE45_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE45_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE45_LOCK1_ROW 0x00000fdb
#define RP23XX_OTP_DATA_PAGE45_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE45_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE45_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE45_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE45_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE45_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE45_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE46_LOCK0_ROW 0x00000fdc
#define RP23XX_OTP_DATA_PAGE46_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE46_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE46_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE46_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE46_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE46_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE46_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE46_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE46_LOCK1_ROW 0x00000fdd
#define RP23XX_OTP_DATA_PAGE46_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE46_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE46_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE46_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE46_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE46_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE46_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE47_LOCK0_ROW 0x00000fde
#define RP23XX_OTP_DATA_PAGE47_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE47_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE47_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE47_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE47_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE47_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE47_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE47_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE47_LOCK1_ROW 0x00000fdf
#define RP23XX_OTP_DATA_PAGE47_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE47_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE47_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE47_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE47_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE47_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE47_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE48_LOCK0_ROW 0x00000fe0
#define RP23XX_OTP_DATA_PAGE48_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE48_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE48_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE48_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE48_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE48_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE48_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE48_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE48_LOCK1_ROW 0x00000fe1
#define RP23XX_OTP_DATA_PAGE48_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE48_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE48_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE48_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE48_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE48_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE48_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE49_LOCK0_ROW 0x00000fe2
#define RP23XX_OTP_DATA_PAGE49_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE49_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE49_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE49_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE49_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE49_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE49_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE49_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE49_LOCK1_ROW 0x00000fe3
#define RP23XX_OTP_DATA_PAGE49_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE49_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE49_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE49_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE49_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE49_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE49_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE50_LOCK0_ROW 0x00000fe4
#define RP23XX_OTP_DATA_PAGE50_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE50_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE50_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE50_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE50_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE50_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE50_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE50_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE50_LOCK1_ROW 0x00000fe5
#define RP23XX_OTP_DATA_PAGE50_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE50_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE50_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE50_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE50_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE50_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE50_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE51_LOCK0_ROW 0x00000fe6
#define RP23XX_OTP_DATA_PAGE51_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE51_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE51_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE51_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE51_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE51_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE51_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE51_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE51_LOCK1_ROW 0x00000fe7
#define RP23XX_OTP_DATA_PAGE51_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE51_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE51_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE51_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE51_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE51_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE51_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE52_LOCK0_ROW 0x00000fe8
#define RP23XX_OTP_DATA_PAGE52_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE52_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE52_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE52_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE52_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE52_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE52_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE52_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE52_LOCK1_ROW 0x00000fe9
#define RP23XX_OTP_DATA_PAGE52_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE52_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE52_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE52_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE52_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE52_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE52_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE53_LOCK0_ROW 0x00000fea
#define RP23XX_OTP_DATA_PAGE53_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE53_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE53_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE53_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE53_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE53_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE53_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE53_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE53_LOCK1_ROW 0x00000feb
#define RP23XX_OTP_DATA_PAGE53_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE53_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE53_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE53_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE53_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE53_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE53_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE54_LOCK0_ROW 0x00000fec
#define RP23XX_OTP_DATA_PAGE54_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE54_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE54_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE54_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE54_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE54_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE54_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE54_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE54_LOCK1_ROW 0x00000fed
#define RP23XX_OTP_DATA_PAGE54_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE54_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE54_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE54_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE54_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE54_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE54_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE55_LOCK0_ROW 0x00000fee
#define RP23XX_OTP_DATA_PAGE55_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE55_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE55_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE55_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE55_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE55_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE55_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE55_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE55_LOCK1_ROW 0x00000fef
#define RP23XX_OTP_DATA_PAGE55_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE55_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE55_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE55_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE55_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE55_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE55_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE56_LOCK0_ROW 0x00000ff0
#define RP23XX_OTP_DATA_PAGE56_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE56_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE56_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE56_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE56_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE56_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE56_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE56_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE56_LOCK1_ROW 0x00000ff1
#define RP23XX_OTP_DATA_PAGE56_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE56_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE56_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE56_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE56_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE56_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE56_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE57_LOCK0_ROW 0x00000ff2
#define RP23XX_OTP_DATA_PAGE57_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE57_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE57_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE57_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE57_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE57_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE57_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE57_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE57_LOCK1_ROW 0x00000ff3
#define RP23XX_OTP_DATA_PAGE57_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE57_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE57_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE57_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE57_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE57_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE57_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE58_LOCK0_ROW 0x00000ff4
#define RP23XX_OTP_DATA_PAGE58_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE58_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE58_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE58_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE58_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE58_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE58_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE58_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE58_LOCK1_ROW 0x00000ff5
#define RP23XX_OTP_DATA_PAGE58_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE58_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE58_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE58_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE58_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE58_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE58_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE59_LOCK0_ROW 0x00000ff6
#define RP23XX_OTP_DATA_PAGE59_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE59_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE59_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE59_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE59_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE59_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE59_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE59_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE59_LOCK1_ROW 0x00000ff7
#define RP23XX_OTP_DATA_PAGE59_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE59_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE59_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE59_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE59_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE59_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE59_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE60_LOCK0_ROW 0x00000ff8
#define RP23XX_OTP_DATA_PAGE60_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE60_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE60_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE60_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE60_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE60_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE60_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE60_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE60_LOCK1_ROW 0x00000ff9
#define RP23XX_OTP_DATA_PAGE60_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE60_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE60_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE60_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE60_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE60_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE60_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE61_LOCK0_ROW 0x00000ffa
#define RP23XX_OTP_DATA_PAGE61_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE61_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE61_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE61_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE61_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE61_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE61_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE61_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE61_LOCK1_ROW 0x00000ffb
#define RP23XX_OTP_DATA_PAGE61_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE61_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE61_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE61_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE61_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE61_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE61_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE62_LOCK0_ROW 0x00000ffc
#define RP23XX_OTP_DATA_PAGE62_LOCK0_BITS   0x00ffff7f
#define RP23XX_OTP_DATA_PAGE62_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE62_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE62_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE62_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE62_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE62_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE62_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE62_LOCK1_ROW 0x00000ffd
#define RP23XX_OTP_DATA_PAGE62_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE62_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE62_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE62_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE62_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE62_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE62_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE63_LOCK0_ROW 0x00000ffe
#define RP23XX_OTP_DATA_PAGE63_LOCK0_BITS   0x00ffffff
#define RP23XX_OTP_DATA_PAGE63_LOCK0_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE63_LOCK0_WIDTH  24

#define RP23XX_OTP_DATA_PAGE63_LOCK0_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK0_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE63_LOCK0_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK0_RMA_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_RMA_BITS   0x00000080
#define RP23XX_OTP_DATA_PAGE63_LOCK0_RMA_MSB    7
#define RP23XX_OTP_DATA_PAGE63_LOCK0_RMA_LSB    7
#define RP23XX_OTP_DATA_PAGE63_LOCK0_RMA_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_BITS   0x00000040
#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_MSB    6
#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_LSB    6
#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_VALUE_READ_ONLY 0x0
#define RP23XX_OTP_DATA_PAGE63_LOCK0_NO_KEY_STATE_VALUE_INACCESSIBLE 0x1

#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_R_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_R_BITS   0x00000038
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_R_MSB    5
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_R_LSB    3
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_R_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_W_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_W_BITS   0x00000007
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_W_MSB    2
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_W_LSB    0
#define RP23XX_OTP_DATA_PAGE63_LOCK0_KEY_W_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK1_ROW 0x00000fff
#define RP23XX_OTP_DATA_PAGE63_LOCK1_BITS   0x00ffff3f
#define RP23XX_OTP_DATA_PAGE63_LOCK1_RESET  0x00000000
#define RP23XX_OTP_DATA_PAGE63_LOCK1_WIDTH  24

#define RP23XX_OTP_DATA_PAGE63_LOCK1_R2_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R2_BITS   0x00ff0000
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R2_MSB    23
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R2_LSB    16
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R2_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK1_R1_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R1_BITS   0x0000ff00
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R1_MSB    15
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R1_LSB    8
#define RP23XX_OTP_DATA_PAGE63_LOCK1_R1_ACCESS "RO"

#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_BITS   0x00000030
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_MSB    5
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_LSB    4
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_BL_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_BITS   0x0000000c
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_MSB    3
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_LSB    2
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_NS_VALUE_INACCESSIBLE 0x3

#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_RESET  "-"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_BITS   0x00000003
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_MSB    1
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_LSB    0
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_ACCESS "RO"
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_VALUE_READ_WRITE 0x0
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_VALUE_READ_ONLY 0x1
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_VALUE_RESERVED 0x2
#define RP23XX_OTP_DATA_PAGE63_LOCK1_LOCK_S_VALUE_INACCESSIBLE 0x3

#endif /* __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_OTP_DATA_H */
