/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedRareTerms;

public class ParsedLongRareTerms
extends ParsedRareTerms {
    private static final ObjectParser<ParsedLongRareTerms, Void> PARSER = new ObjectParser(ParsedLongRareTerms.class.getSimpleName(), true, ParsedLongRareTerms::new);

    @Override
    public String getType() {
        return "lrareterms";
    }

    public static ParsedLongRareTerms fromXContent(XContentParser parser, String name) throws IOException {
        ParsedLongRareTerms aggregation = (ParsedLongRareTerms)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedLongRareTerms.declareParsedTermsFields(PARSER, (CheckedFunction<XContentParser, ParsedRareTerms.ParsedBucket, IOException>)((CheckedFunction)ParsedBucket::fromXContent));
    }

    public static class ParsedBucket
    extends ParsedRareTerms.ParsedBucket {
        private Long key;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Long.toString(this.key);
            }
            return null;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.key;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            if (super.getKeyAsString() != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            return builder;
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseRareTermsBucketXContent(parser, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.longValue();
            });
        }
    }
}

