/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;

public interface BulletinRepository {
    public static final int MAX_BULLETINS_PER_COMPONENT = 5;
    public static final int MAX_BULLETINS_FOR_CONTROLLER = 10;

    public void addBulletin(Bulletin var1);

    public int getControllerBulletinCapacity();

    public int getComponentBulletinCapacity();

    public List<Bulletin> findBulletins(BulletinQuery var1);

    public List<Bulletin> findBulletinsForSource(String var1);

    public List<Bulletin> findBulletinsForSource(String var1, String var2);

    public List<Bulletin> findBulletinsForGroupBySource(String var1);

    public List<Bulletin> findBulletinsForGroupBySource(String var1, int var2);

    public List<Bulletin> findBulletinsForController();

    public List<Bulletin> findBulletinsForController(int var1);

    public long getMaxBulletinId();

    default public int clearBulletinsForComponent(String sourceId, Instant fromTimestamp) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Clear Bulletins for Component not supported");
    }

    default public int clearBulletinsForComponents(Collection<String> sourceIds, Instant fromTimestamp) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Clear Bulletins for Components not supported");
    }
}

