/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.SnippetClient;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.SnippetEntity;

public class JerseySnippetClient
extends AbstractJerseyClient
implements SnippetClient {
    private final WebTarget snippetTarget;

    public JerseySnippetClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseySnippetClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.snippetTarget = baseTarget.path("/snippets");
    }

    @Override
    public SnippetEntity createSnippet(SnippetEntity snippet) throws NiFiClientException, IOException {
        if (snippet == null) {
            throw new IllegalArgumentException("Snippet entity cannot be null");
        }
        return this.executeAction("Error creating snippet", () -> (SnippetEntity)this.getRequestBuilder(this.snippetTarget).post(Entity.entity((Object)snippet, (String)"application/json"), SnippetEntity.class));
    }

    @Override
    public SnippetEntity updateSnippet(SnippetEntity snippet) throws NiFiClientException, IOException {
        if (snippet == null) {
            throw new IllegalArgumentException("Snippet entity cannot be null");
        }
        return this.executeAction("Error updating snippet", () -> {
            WebTarget target = this.snippetTarget.path("/{id}").resolveTemplate("id", (Object)snippet.getSnippet().getId());
            Entity entity = Entity.entity((Object)snippet, (String)"application/json");
            return (SnippetEntity)this.getRequestBuilder(target).put(entity, SnippetEntity.class);
        });
    }
}

