/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.secrets.SecretClient;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.properties.AesGcmSensitivePropertyProvider;
import org.apache.nifi.properties.AwsKmsSensitivePropertyProvider;
import org.apache.nifi.properties.AwsSecretsManagerSensitivePropertyProvider;
import org.apache.nifi.properties.AzureKeyVaultKeySensitivePropertyProvider;
import org.apache.nifi.properties.AzureKeyVaultSecretSensitivePropertyProvider;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.GcpKmsSensitivePropertyProvider;
import org.apache.nifi.properties.HashiCorpVaultKeyValueSensitivePropertyProvider;
import org.apache.nifi.properties.HashiCorpVaultTransitSensitivePropertyProvider;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.configuration.AwsKmsClientProvider;
import org.apache.nifi.properties.configuration.AwsSecretsManagerClientProvider;
import org.apache.nifi.properties.configuration.AzureCryptographyClientProvider;
import org.apache.nifi.properties.configuration.AzureSecretClientProvider;
import org.apache.nifi.properties.configuration.ClientProvider;
import org.apache.nifi.properties.configuration.GoogleKeyManagementServiceClientProvider;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public class StandardSensitivePropertyProviderFactory
implements SensitivePropertyProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(StandardSensitivePropertyProviderFactory.class);
    private static final List<Class<? extends SensitivePropertyProvider>> PROVIDER_CLASSES = Arrays.asList(AesGcmSensitivePropertyProvider.class, AwsKmsSensitivePropertyProvider.class, AwsSecretsManagerSensitivePropertyProvider.class, AzureKeyVaultKeySensitivePropertyProvider.class, AzureKeyVaultSecretSensitivePropertyProvider.class, GcpKmsSensitivePropertyProvider.class, HashiCorpVaultKeyValueSensitivePropertyProvider.class, HashiCorpVaultTransitSensitivePropertyProvider.class);
    private Optional<String> keyHex;
    private final Supplier<BootstrapProperties> bootstrapPropertiesSupplier;
    private final Map<Class<? extends SensitivePropertyProvider>, SensitivePropertyProvider> providers;
    private Map<String, Pattern> customPropertyContextMap;

    public StandardSensitivePropertyProviderFactory() {
        this(null, null);
    }

    public void setKeyHex(String hexadecimalKey) {
        this.keyHex = Optional.ofNullable(hexadecimalKey);
    }

    public static SensitivePropertyProviderFactory withDefaults() {
        return StandardSensitivePropertyProviderFactory.withKeyAndBootstrapSupplier(null, null);
    }

    public static SensitivePropertyProviderFactory withKey(String keyHex) {
        return new StandardSensitivePropertyProviderFactory(keyHex, null);
    }

    public static SensitivePropertyProviderFactory withKeyAndBootstrapSupplier(String keyHex, Supplier<BootstrapProperties> bootstrapPropertiesSupplier) {
        return new StandardSensitivePropertyProviderFactory(keyHex, bootstrapPropertiesSupplier);
    }

    private StandardSensitivePropertyProviderFactory(String keyHex, Supplier<BootstrapProperties> bootstrapPropertiesSupplier) {
        this.keyHex = Optional.ofNullable(keyHex);
        this.bootstrapPropertiesSupplier = bootstrapPropertiesSupplier == null ? () -> null : bootstrapPropertiesSupplier;
        this.providers = new HashMap<Class<? extends SensitivePropertyProvider>, SensitivePropertyProvider>();
        this.customPropertyContextMap = null;
    }

    public SensitivePropertyProvider getProvider(ProtectionScheme protectionScheme) throws SensitivePropertyProtectionException {
        String path = Objects.requireNonNull(protectionScheme, "Protection Scheme required").getPath();
        Collection<SensitivePropertyProvider> supportedProviders = this.getSupportedProviders();
        return supportedProviders.stream().filter(provider -> provider.getIdentifierKey().startsWith(path)).findFirst().orElseThrow(() -> new SensitivePropertyProtectionException(String.format("Protection Scheme [%s] not found", path)));
    }

    public Collection<SensitivePropertyProvider> getSupportedProviders() {
        return PROVIDER_CLASSES.stream().map(this::getProvider).filter(SensitivePropertyProvider::isSupported).collect(Collectors.toList());
    }

    public ProtectedPropertyContext getPropertyContext(String groupIdentifier, String propertyName) {
        if (this.customPropertyContextMap == null) {
            this.populateCustomPropertyContextMap();
        }
        String contextName = this.customPropertyContextMap.entrySet().stream().filter(entry -> ((Pattern)entry.getValue()).matcher(groupIdentifier).find()).map(Map.Entry::getKey).findFirst().orElse(null);
        return ProtectedPropertyContext.contextFor((String)propertyName, (String)contextName);
    }

    private void populateCustomPropertyContextMap() {
        BootstrapProperties bootstrapProperties = this.getBootstrapProperties();
        this.customPropertyContextMap = new HashMap<String, Pattern>();
        String contextMappingKeyPrefix = BootstrapProperties.BootstrapPropertyKey.CONTEXT_MAPPING_PREFIX.getKey();
        bootstrapProperties.getPropertyKeys().stream().filter(k -> k.contains(contextMappingKeyPrefix)).forEach(k -> this.customPropertyContextMap.put(StringUtils.substringAfter((String)k, (String)contextMappingKeyPrefix), Pattern.compile(bootstrapProperties.getProperty(k))));
    }

    private String getKeyHex() {
        return this.keyHex.orElseGet(() -> (String)this.getBootstrapProperties().getProperty(BootstrapProperties.BootstrapPropertyKey.SENSITIVE_KEY).orElseThrow(() -> new SensitivePropertyProtectionException("Could not read root key from bootstrap.conf")));
    }

    private BootstrapProperties getBootstrapProperties() {
        return Optional.ofNullable(this.bootstrapPropertiesSupplier.get()).orElseGet(() -> {
            try {
                return NiFiBootstrapUtils.loadBootstrapProperties();
            }
            catch (IOException e) {
                logger.debug("Bootstrap Properties loading failed", (Throwable)e);
                return BootstrapProperties.EMPTY;
            }
        });
    }

    private <T> Properties getClientProperties(ClientProvider<T> clientProvider) {
        Optional clientProperties = clientProvider.getClientProperties(this.getBootstrapProperties());
        return clientProperties.orElse(null);
    }

    private SensitivePropertyProvider getProvider(Class<? extends SensitivePropertyProvider> providerClass) throws SensitivePropertyProtectionException {
        SensitivePropertyProvider provider = this.providers.get(providerClass);
        if (provider == null) {
            if (AesGcmSensitivePropertyProvider.class.equals(providerClass)) {
                String hexadecimalKey = this.getKeyHex();
                provider = new AesGcmSensitivePropertyProvider(hexadecimalKey);
            } else if (AwsKmsSensitivePropertyProvider.class.equals(providerClass)) {
                AwsKmsClientProvider clientProvider = new AwsKmsClientProvider();
                Properties clientProperties = this.getClientProperties((ClientProvider)clientProvider);
                Optional kmsClient = clientProvider.getClient(clientProperties);
                provider = new AwsKmsSensitivePropertyProvider((KmsClient)kmsClient.orElse(null), clientProperties);
            } else if (AwsSecretsManagerSensitivePropertyProvider.class.equals(providerClass)) {
                AwsSecretsManagerClientProvider clientProvider = new AwsSecretsManagerClientProvider();
                Properties clientProperties = this.getClientProperties((ClientProvider)clientProvider);
                Optional secretsManagerClient = clientProvider.getClient(clientProperties);
                provider = new AwsSecretsManagerSensitivePropertyProvider((SecretsManagerClient)secretsManagerClient.orElse(null));
            } else if (AzureKeyVaultKeySensitivePropertyProvider.class.equals(providerClass)) {
                AzureCryptographyClientProvider clientProvider = new AzureCryptographyClientProvider();
                Properties clientProperties = this.getClientProperties((ClientProvider)clientProvider);
                Optional cryptographyClient = clientProvider.getClient(clientProperties);
                provider = new AzureKeyVaultKeySensitivePropertyProvider((CryptographyClient)cryptographyClient.orElse(null), clientProperties);
            } else if (AzureKeyVaultSecretSensitivePropertyProvider.class.equals(providerClass)) {
                AzureSecretClientProvider clientProvider = new AzureSecretClientProvider();
                Properties clientProperties = this.getClientProperties((ClientProvider)clientProvider);
                Optional secretClient = clientProvider.getClient(clientProperties);
                provider = new AzureKeyVaultSecretSensitivePropertyProvider((SecretClient)secretClient.orElse(null));
            } else if (GcpKmsSensitivePropertyProvider.class.equals(providerClass)) {
                GoogleKeyManagementServiceClientProvider clientProvider = new GoogleKeyManagementServiceClientProvider();
                Properties clientProperties = this.getClientProperties((ClientProvider)clientProvider);
                Optional keyManagementServiceClient = clientProvider.getClient(clientProperties);
                provider = new GcpKmsSensitivePropertyProvider((KeyManagementServiceClient)keyManagementServiceClient.orElse(null), clientProperties);
            } else if (HashiCorpVaultKeyValueSensitivePropertyProvider.class.equals(providerClass)) {
                provider = new HashiCorpVaultKeyValueSensitivePropertyProvider(this.getBootstrapProperties());
            } else if (HashiCorpVaultTransitSensitivePropertyProvider.class.equals(providerClass)) {
                provider = new HashiCorpVaultTransitSensitivePropertyProvider(this.getBootstrapProperties());
            }
        }
        if (provider == null) {
            throw new UnsupportedOperationException(String.format("Provider class not supported [%s]", providerClass));
        }
        this.providers.put(providerClass, provider);
        return provider;
    }
}

