/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import org.jetbrains.annotations.NotNull;

public class HaversineDistDegreeGroupByFunction
extends DoubleFunction
implements GroupByFunction,
TernaryFunction {
    private static final double EARTH_RADIUS = 6371.088;
    private final Function latDegree;
    private final Function lonDegree;
    private final Function timestamp;
    private int valueIndex;

    public HaversineDistDegreeGroupByFunction(@NotNull Function latDegree, @NotNull Function lonDegree, Function timestamp) {
        this.latDegree = latDegree;
        this.lonDegree = lonDegree;
        this.timestamp = timestamp;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        this.saveFirstItem(mapValue, this.latDegree.getDouble(record), this.lonDegree.getDouble(record), this.timestamp.getTimestamp(record));
        this.saveLastItem(mapValue, this.latDegree.getDouble(record), this.lonDegree.getDouble(record), this.timestamp.getTimestamp(record));
        this.saveDistance(mapValue, 0.0);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        double lat1Degrees = this.getLastLatitude(mapValue);
        double lon1Degrees = this.getLastLongitude(mapValue);
        long timestamp1 = this.getLastTimestamp(mapValue);
        double lat2Degrees = this.latDegree.getDouble(record);
        double lon2Degrees = this.lonDegree.getDouble(record);
        long timestamp2 = this.timestamp.getTimestamp(record);
        if (!Double.isNaN(lat1Degrees) && !Double.isNaN(lon1Degrees) && timestamp1 != Long.MIN_VALUE) {
            if (!Double.isNaN(lat2Degrees) && !Double.isNaN(lon2Degrees) && timestamp2 != Long.MIN_VALUE) {
                double currentTotalDistance = this.getDistance(mapValue);
                double distance = this.calculateHaversineDistanceFromDegrees(lat1Degrees, lon1Degrees, lat2Degrees, lon2Degrees, currentTotalDistance);
                this.saveLastItem(mapValue, lat2Degrees, lon2Degrees, timestamp2);
                this.saveDistance(mapValue, distance);
            }
        } else {
            this.saveLastItem(mapValue, lat2Degrees, lon2Degrees, timestamp2);
        }
    }

    @Override
    public Function getCenter() {
        return this.lonDegree;
    }

    @Override
    public double getDouble(Record rec) {
        return this.getDistance(rec);
    }

    @Override
    public Function getLeft() {
        return this.latDegree;
    }

    @Override
    public String getName() {
        return "haversine_dist_deg";
    }

    @Override
    public Function getRight() {
        return this.timestamp;
    }

    @Override
    public void interpolateBoundary(MapValue value1, MapValue value2, long boundaryTimestamp, boolean isEndOfBoundary) {
        double distance = this.calculateHaversineDistance(value1, value2);
        long ts1 = this.getLastTimestamp(value1);
        long ts2 = this.getFirstTimestamp(value2);
        long boundaryLength = isEndOfBoundary ? boundaryTimestamp - ts1 : ts2 - boundaryTimestamp;
        double interpolatedBoundaryDistance = (double)boundaryLength * distance / (double)(ts2 - ts1);
        MapValue result = isEndOfBoundary ? value1 : value2;
        this.saveDistance(interpolatedBoundaryDistance, result, this.getDistance(result));
    }

    @Override
    public void interpolateGap(MapValue result, MapValue value1, MapValue value2, long gapSize) {
        double distance = this.calculateHaversineDistance(value1, value2);
        long ts1 = this.getLastTimestamp(value1);
        long ts2 = this.getFirstTimestamp(value2);
        double interpolatedGapDistance = (double)gapSize * distance / (double)(ts2 - ts1);
        this.saveDistance(result, interpolatedGapDistance);
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(6);
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(6);
        columnTypes.add(10);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.saveFirstItem(mapValue, Double.NaN, Double.NaN, Long.MIN_VALUE);
        this.saveLastItem(mapValue, Double.NaN, Double.NaN, Long.MIN_VALUE);
        this.saveDistance(mapValue, 0.0);
    }

    private double calculateHaversineDistance(MapValue value1, MapValue value2) {
        double lat1Degrees = this.getLastLatitude(value1);
        double lon1Degrees = this.getLastLongitude(value1);
        double lat2Degrees = this.getFirstLatitude(value2);
        double lon2Degrees = this.getFirstLongitude(value2);
        return this.calculateHaversineDistanceFromDegrees(lat1Degrees, lon1Degrees, lat2Degrees, lon2Degrees, 0.0);
    }

    private double calculateHaversineDistanceFromDegrees(double lat1Degrees, double lon1Degrees, double lat2Degrees, double lon2Degrees, double currentTotalDistance) {
        double lat1 = this.toRad(lat1Degrees);
        double lon1 = this.toRad(lon1Degrees);
        double lat2 = this.toRad(lat2Degrees);
        double lon2 = this.toRad(lon2Degrees);
        return this.calculateHaversineDistanceFromRadians(currentTotalDistance, lat1, lon1, lat2, lon2);
    }

    private double calculateHaversineDistanceFromRadians(double currentTotal, double lat1, double lon1, double lat2, double lon2) {
        double halfLatDist = (lat2 - lat1) / 2.0;
        double halfLonDist = (lon2 - lon1) / 2.0;
        double a = Math.sin(halfLatDist) * Math.sin(halfLatDist) + Math.cos(lat1) * Math.cos(lat2) * Math.sin(halfLonDist) * Math.sin(halfLonDist);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return currentTotal += 6371.088 * c;
    }

    private double getDistance(Record result) {
        return result.getDouble(this.valueIndex + 6);
    }

    private double getFirstLatitude(MapValue value) {
        return value.getDouble(this.valueIndex);
    }

    private double getFirstLongitude(MapValue value) {
        return value.getDouble(this.valueIndex + 1);
    }

    private long getFirstTimestamp(MapValue value) {
        return value.getTimestamp(this.valueIndex + 2);
    }

    private double getLastLatitude(MapValue value1) {
        return value1.getDouble(this.valueIndex + 3);
    }

    private double getLastLongitude(MapValue mapValue) {
        return mapValue.getDouble(this.valueIndex + 4);
    }

    private long getLastTimestamp(MapValue value) {
        return value.getTimestamp(this.valueIndex + 5);
    }

    private void saveDistance(double interpolatedBoundaryDistance, MapValue result, double currentDistance) {
        this.saveDistance(result, currentDistance + interpolatedBoundaryDistance);
    }

    private void saveDistance(MapValue result, double distance) {
        result.putDouble(this.valueIndex + 6, distance);
    }

    private void saveFirstItem(MapValue mapValue, double lat, double lon, long timestamp) {
        mapValue.putDouble(this.valueIndex, lat);
        mapValue.putDouble(this.valueIndex + 1, lon);
        mapValue.putTimestamp(this.valueIndex + 2, timestamp);
    }

    private void saveLastItem(MapValue mapValue, double lat, double lon, long timestamp) {
        mapValue.putDouble(this.valueIndex + 3, lat);
        mapValue.putDouble(this.valueIndex + 4, lon);
        mapValue.putTimestamp(this.valueIndex + 5, timestamp);
    }

    private double toRad(double deg) {
        return deg * Math.PI / 180.0;
    }
}

