/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public abstract class RebuildColumnBase
implements Closeable,
Mutable {
    static final int REBUILD_ALL_COLUMNS = -1;
    protected final String unsupportedTableMessage = "Table does not have any indexes";
    private final StringSink tempStringSink = new StringSink();
    protected CairoConfiguration configuration;
    protected FilesFacade ff;
    protected Path path = new Path();
    protected int rootLen;
    protected String unsupportedColumnMessage = "Wrong column type";
    private MillisecondClock clock;
    private int lockFd;

    @Override
    public void clear() {
        this.path.trimTo(0);
        this.tempStringSink.clear();
    }

    @Override
    public void close() {
        this.path = Misc.free(this.path);
    }

    public RebuildColumnBase of(CharSequence tablePath, CairoConfiguration configuration) {
        this.path.of(tablePath);
        this.rootLen = tablePath.length();
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.clock = configuration.getMillisecondClock();
        return this;
    }

    public void rebuildAll() {
        this.reindex(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(@Nullable CharSequence partitionName, @Nullable CharSequence columnName) {
        try {
            this.lock(this.ff);
            this.path.concat("_cv").$();
            try (ColumnVersionReader columnVersionReader = new ColumnVersionReader().ofRO(this.ff, this.path);){
                long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
                columnVersionReader.readSafe(this.clock, deadline);
                this.path.trimTo(this.rootLen);
                this.reindex0(columnVersionReader, partitionName, columnName);
            }
        }
        finally {
            TableUtils.lockName(this.path);
            this.releaseLock(this.ff);
        }
    }

    public void reindexAfterUpdate(long partitionTimestamp, CharSequence columnName, TableWriter tableWriter) {
        TxReader txReader = tableWriter.getTxReader();
        int partitionIndex = txReader.getPartitionIndex(partitionTimestamp);
        assert ((long)partitionIndex > -1L);
        TableRecordMetadata metadata = tableWriter.getMetadata();
        int columnIndex = tableWriter.getColumnIndex(columnName);
        int indexValueBlockCapacity = metadata.getIndexValueBlockCapacity(columnIndex);
        assert (indexValueBlockCapacity > 0);
        long partitionSize = partitionIndex == txReader.getPartitionCount() - 1 ? txReader.getTransientRowCount() : txReader.getPartitionSize(partitionIndex);
        long partitionNameTxn = txReader.getPartitionNameTxn(partitionIndex);
        this.tempStringSink.clear();
        DateFormat partitionDirFormatMethod = PartitionBy.getPartitionDirFormatMethod(tableWriter.getPartitionBy());
        partitionDirFormatMethod.format(partitionTimestamp, null, null, this.tempStringSink);
        this.doReindex(tableWriter.getColumnVersionReader(), columnIndex, columnName, this.tempStringSink, partitionNameTxn, partitionSize, partitionTimestamp, indexValueBlockCapacity);
    }

    public void reindexAllInPartition(CharSequence partitionName) {
        this.reindex(partitionName, null);
    }

    public void reindexColumn(CharSequence columnName) {
        this.reindex(null, columnName);
    }

    public void reindexColumn(ColumnVersionReader columnVersionReader, RecordMetadata metadata, int columnIndex, CharSequence partitionName, long partitionNameTxn, long partitionTimestamp, long partitionSize) {
        this.doReindex(columnVersionReader, metadata.getWriterIndex(columnIndex), metadata.getColumnName(columnIndex), partitionName, partitionNameTxn, partitionSize, partitionTimestamp, metadata.getIndexValueBlockCapacity(columnIndex));
    }

    private void lock(FilesFacade ff) {
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.lockName(this.path);
            this.lockFd = TableUtils.lock(ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1) {
            throw CairoException.nonCritical().put("Cannot lock table: ").put(this.path.$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex0(ColumnVersionReader columnVersionReader, @Nullable CharSequence partitionName, @Nullable CharSequence columnName) {
        this.path.trimTo(this.rootLen).concat("_meta");
        try (TableReaderMetadata metadata = new TableReaderMetadata(this.configuration);){
            metadata.load(this.path.$());
            int columnIndex = columnName != null ? metadata.getColumnIndex(columnName) : -1;
            this.path.trimTo(this.rootLen);
            int partitionBy = metadata.getPartitionBy();
            DateFormat partitionDirFormatMethod = PartitionBy.getPartitionDirFormatMethod(partitionBy);
            try (TxReader txReader = new TxReader(this.ff).ofRO(this.path.concat("_txn").$(), partitionBy);){
                txReader.unsafeLoadAll();
                this.path.trimTo(this.rootLen);
                if (PartitionBy.isPartitioned(partitionBy)) {
                    if (partitionName != null) {
                        long partitionTimestamp = PartitionBy.parsePartitionDirName(partitionName, partitionBy);
                        int partitionIndex = txReader.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
                        if ((long)partitionIndex > -1L) {
                            this.reindexPartition(metadata, columnVersionReader, txReader, columnIndex, partitionIndex, partitionDirFormatMethod, partitionTimestamp);
                        }
                    } else {
                        for (int partitionIndex = txReader.getPartitionCount() - 1; partitionIndex > -1; --partitionIndex) {
                            this.reindexPartition(metadata, columnVersionReader, txReader, columnIndex, partitionIndex, partitionDirFormatMethod, txReader.getPartitionTimestamp(partitionIndex));
                        }
                    }
                } else {
                    this.reindexOneOrAllColumns(metadata, columnVersionReader, columnIndex, partitionDirFormatMethod, -1L, 0L, txReader.getTransientRowCount());
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void reindexOneOrAllColumns(RecordMetadata metadata, ColumnVersionReader columnVersionReader, int columnIndex, DateFormat partitionDirFormatMethod, long partitionNameTxn, long partitionTimestamp, long partitionSize) {
        boolean isIndexed = false;
        this.tempStringSink.clear();
        partitionDirFormatMethod.format(partitionTimestamp, null, null, this.tempStringSink);
        if (columnIndex == -1) {
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isSupportedColumn(metadata, i)) continue;
                isIndexed = true;
                this.reindexColumn(columnVersionReader, metadata, i, this.tempStringSink, partitionNameTxn, partitionTimestamp, partitionSize);
            }
            if (!isIndexed) {
                throw CairoException.nonCritical().put("Table does not have any indexes");
            }
        } else if (this.isSupportedColumn(metadata, columnIndex)) {
            this.reindexColumn(columnVersionReader, metadata, columnIndex, this.tempStringSink, partitionNameTxn, partitionTimestamp, partitionSize);
        } else {
            throw CairoException.nonCritical().put(this.unsupportedColumnMessage);
        }
    }

    private void reindexPartition(RecordMetadata metadata, ColumnVersionReader columnVersionReader, TxReader txReader, int columnIndex, int partitionIndex, DateFormat partitionDirFormatMethod, long partitionTimestamp) {
        long partitionSize = partitionIndex == txReader.getPartitionCount() - 1 ? txReader.getTransientRowCount() : txReader.getPartitionSize(partitionIndex);
        this.reindexOneOrAllColumns(metadata, columnVersionReader, columnIndex, partitionDirFormatMethod, txReader.getPartitionNameTxn(partitionIndex), partitionTimestamp, partitionSize);
    }

    private void releaseLock(FilesFacade ff) {
        if ((long)this.lockFd != -1L) {
            ff.close(this.lockFd);
            this.lockFd = -1;
            try {
                this.path.trimTo(this.rootLen);
                TableUtils.lockName(this.path);
                if (ff.exists(this.path) && !ff.remove(this.path)) {
                    throw CairoException.critical(ff.errno()).put("Cannot remove ").put(this.path);
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    protected abstract void doReindex(ColumnVersionReader var1, int var2, CharSequence var3, CharSequence var4, long var5, long var7, long var9, int var11);

    protected abstract boolean isSupportedColumn(RecordMetadata var1, int var2);
}

