/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class IntegerBinding
extends ComparableBinding {
    public static final IntegerBinding BINDING = new IntegerBinding();

    private IntegerBinding() {
    }

    @Override
    public Integer readObject(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readInt(stream);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        output.writeUnsignedInt((long)((Integer)object ^ Integer.MIN_VALUE));
    }

    public static int entryToInt(@NotNull ByteIterable entry) {
        return (Integer)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable intToEntry(int object) {
        return BINDING.objectToEntry(Integer.valueOf(object));
    }

    public static int compressedEntryToInt(@NotNull ByteIterable entry) {
        return IntegerBinding.readCompressed(entry.iterator());
    }

    public static ArrayByteIterable intToCompressedEntry(int object) {
        if (object < 0) {
            throw new IllegalArgumentException();
        }
        LightOutputStream output = new LightOutputStream(5);
        IntegerBinding.writeCompressed(output, object);
        return output.asArrayByteIterable();
    }

    public static int compressedEntryToSignedInt(@NotNull ByteIterable entry) {
        int result = IntegerBinding.compressedEntryToInt(entry);
        return result >> 1 ^ (result & 1) << 31 >> 31;
    }

    public static ArrayByteIterable signedIntToCompressedEntry(int object) {
        return IntegerBinding.intToCompressedEntry(object << 1 ^ object >> 31);
    }

    public static int readCompressed(@NotNull ByteIterator iterator) {
        int firstByte = iterator.next() & 0xFF;
        int result = firstByte & 0x1F;
        int byteLen = firstByte >> 5;
        while (--byteLen >= 0) {
            result = (result << 8) + (iterator.next() & 0xFF);
        }
        return result;
    }

    public static int readCompressed(@NotNull ByteArrayInputStream iterator) {
        int firstByte = iterator.read() & 0xFF;
        int result = firstByte & 0x1F;
        int byteLen = firstByte >> 5;
        while (--byteLen >= 0) {
            result = (result << 8) + (iterator.read() & 0xFF);
        }
        return result;
    }

    public static int readCompressed(@NotNull byte[] bytes) {
        int firstByte = bytes[0] & 0xFF;
        int result = firstByte & 0x1F;
        int byteLen = firstByte >> 5;
        for (int i = 1; i <= byteLen; ++i) {
            result = (result << 8) + (bytes[i] & 0xFF);
        }
        return result;
    }

    public static void writeCompressed(@NotNull LightOutputStream output, int i) {
        IntegerBinding.writeCompressed(output, i, new int[4]);
    }

    public static void writeCompressed(@NotNull LightOutputStream output, int i, int[] bytes) {
        int upperByte;
        int byteLen;
        for (int j = 0; j < 4; ++j) {
            bytes[j] = i & 0xFF;
            i >>= 8;
        }
        for (byteLen = 4; byteLen > 0 && bytes[byteLen - 1] == 0; --byteLen) {
        }
        int firstByte = byteLen << 5;
        if (byteLen > 0 && (upperByte = bytes[byteLen - 1]) < 32) {
            firstByte = ((firstByte >> 5) - 1 << 5) + upperByte;
            --byteLen;
        }
        output.write(firstByte);
        while (--byteLen >= 0) {
            output.write(bytes[byteLen]);
        }
    }
}

