/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.repository.schema.ComplexRecordField;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.MapRecordField;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SimpleRecordField;
import org.apache.nifi.repository.schema.UnionRecordField;

public class RecordSchema {
    private static final String FIELD_NAME = "Field Name";
    private static final String FIELD_TYPE = "Field Type";
    private static final String REPETITION = "Repetition";
    private static final String SUBFIELDS = "SubFields";
    private static final String STRING_TYPE = "String";
    private static final String INT_TYPE = "Integer";
    private static final String LONG_TYPE = "Long";
    private static final String SUBFIELD_TYPE = "SubFieldList";
    private final List<RecordField> fields;

    public RecordSchema(List<RecordField> fields) {
        this.fields = fields;
    }

    public RecordSchema(RecordField ... fields) {
        this(Arrays.asList(fields));
    }

    public List<RecordField> getFields() {
        return this.fields;
    }

    public RecordField getField(String fieldName) {
        return this.fields.stream().filter(field -> field.getFieldName().equals(fieldName)).findFirst().orElse(null);
    }

    public void writeTo(OutputStream out) throws IOException {
        try {
            DataOutputStream dos = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
            dos.writeInt(this.fields.size());
            for (RecordField field : this.fields) {
                this.writeField(field, dos);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Unable to write Record Schema to stream", ioe);
        }
    }

    private void writeField(RecordField field, DataOutputStream dos) throws IOException {
        dos.writeInt(4);
        dos.writeUTF(FIELD_NAME);
        dos.writeUTF(STRING_TYPE);
        dos.writeUTF(field.getFieldName());
        dos.writeUTF(FIELD_TYPE);
        dos.writeUTF(STRING_TYPE);
        dos.writeUTF(field.getFieldType().name());
        dos.writeUTF(REPETITION);
        dos.writeUTF(STRING_TYPE);
        dos.writeUTF(field.getRepetition().name());
        dos.writeUTF(SUBFIELDS);
        dos.writeUTF(SUBFIELD_TYPE);
        List<RecordField> subFields = field.getSubFields();
        dos.writeInt(subFields.size());
        for (RecordField subField : subFields) {
            this.writeField(subField, dos);
        }
    }

    public static RecordSchema readFrom(InputStream in) throws IOException {
        try {
            DataInputStream dis = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
            int numFields = dis.readInt();
            ArrayList<RecordField> fields = new ArrayList<RecordField>(numFields);
            for (int i = 0; i < numFields; ++i) {
                RecordField field = RecordSchema.readField(dis);
                fields.add(field);
            }
            return new RecordSchema(fields);
        }
        catch (IOException ioe) {
            throw new IOException("Unable to read Record Schema from stream", ioe);
        }
    }

    private static RecordField readField(DataInputStream dis) throws IOException {
        int numElementsToRead = dis.readInt();
        HashMap schemaFieldMap = new HashMap(numElementsToRead);
        for (int i = 0; i < numElementsToRead; ++i) {
            String fieldName = dis.readUTF();
            String typeName = dis.readUTF();
            ArrayList<RecordField> fieldValue = null;
            switch (typeName) {
                case "String": {
                    fieldValue = dis.readUTF();
                    break;
                }
                case "Integer": {
                    fieldValue = dis.readInt();
                    break;
                }
                case "Long": {
                    fieldValue = dis.readLong();
                    break;
                }
                case "SubFieldList": {
                    int numFields = dis.readInt();
                    ArrayList<RecordField> subFields = new ArrayList<RecordField>(numFields);
                    for (int j = 0; j < numFields; ++j) {
                        subFields.add(RecordSchema.readField(dis));
                    }
                    fieldValue = subFields;
                    break;
                }
                default: {
                    throw new IOException("Cannot read schema because the schema definition contains a field named '" + fieldName + "' with a Field Type of '" + typeName + "', which is not a known Field Type");
                }
            }
            schemaFieldMap.put(fieldName, fieldValue);
        }
        String fieldName = (String)schemaFieldMap.get(FIELD_NAME);
        String fieldTypeName = (String)schemaFieldMap.get(FIELD_TYPE);
        String repetitionName = (String)schemaFieldMap.get(REPETITION);
        List<RecordField> subFields = (List<RecordField>)schemaFieldMap.get(SUBFIELDS);
        if (subFields == null) {
            subFields = Collections.emptyList();
        }
        Repetition repetition = Repetition.valueOf(repetitionName);
        if (FieldType.COMPLEX.name().equals(fieldTypeName)) {
            return new ComplexRecordField(fieldName, repetition, subFields);
        }
        if (FieldType.UNION.name().equals(fieldTypeName)) {
            return new UnionRecordField(fieldName, repetition, subFields);
        }
        if (FieldType.MAP.name().equals(fieldTypeName)) {
            if (subFields.size() != 2) {
                throw new IOException("Found a Map that did not have a 'Key' field and a 'Value' field but instead had " + subFields.size() + " fields: " + subFields);
            }
            RecordField keyField = subFields.get(0);
            RecordField valueField = subFields.get(1);
            return new MapRecordField(fieldName, keyField, valueField, repetition);
        }
        return new SimpleRecordField(fieldName, FieldType.valueOf(fieldTypeName), repetition);
    }

    public String toString() {
        return "RecordSchema[" + this.fields + "]";
    }
}

