/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PreRenderViewEvent;
import org.apache.myfaces.tobago.util.FacesVersion;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractUIMetaLink
extends UIComponentBase {
    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        if (event instanceof PreRenderViewEvent) {
            this.addComponentResource();
        } else if (event instanceof PostAddToViewEvent) {
            if (FacesVersion.supports21() || !FacesVersion.isMyfaces()) {
                this.getFacesContext().getViewRoot().subscribeToEvent(PreRenderViewEvent.class, (ComponentSystemEventListener)this);
            } else {
                this.addComponentResource();
            }
        }
    }

    private void addComponentResource() {
        FacesContext facesContext = this.getFacesContext();
        UIViewRoot root = facesContext.getViewRoot();
        root.addComponentResource(facesContext, (UIComponent)this);
    }

    public abstract String getCharset();

    public abstract String getRev();

    public abstract String getHref();

    public abstract String getHreflang();

    public abstract String getRel();

    public abstract String getMedia();

    public abstract String getType();
}

