/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.internal.component.AbstractUIObject;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ObjectRenderer
extends RendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIObject object = (AbstractUIObject)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = object.getMarkup();
        writer.startElement(HtmlElements.IFRAME);
        writer.writeAttribute(HtmlAttributes.FRAMEBORDER, "0", false);
        String clientId = object.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        String name = object.getName();
        if (name == null) {
            name = clientId;
        }
        writer.writeNameAttribute(name);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)object);
        writer.writeAttribute(HtmlAttributes.SRC, object.getSrc(), true);
        writer.writeClassAttribute((CssItem)TobagoClass.OBJECT, TobagoClass.OBJECT.createMarkup(markup), new CssItem[]{object.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        String sandbox = object.getSandbox();
        if (sandbox != null) {
            writer.writeAttribute(HtmlAttributes.SANDBOX, sandbox, false);
        }
        String noframes = TobagoResourceBundle.getString(facesContext, "browser.noframe.message.prefix");
        writer.writeText(noframes);
        writer.writeText(" ");
        if (object.getSrc() != null) {
            writer.writeText(object.getSrc());
        }
        noframes = TobagoResourceBundle.getString(facesContext, "browser.noframe.message.postfix");
        writer.writeText(" " + noframes);
        writer.endElement(HtmlElements.IFRAME);
    }
}

