/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class GridLayoutRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIGridLayout gridLayout = (AbstractUIGridLayout)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = gridLayout.getMarkup();
        writer.startElement(HtmlElements.DIV);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PRESENTATION.toString(), false);
        writer.writeIdAttribute(gridLayout.getClientId(facesContext));
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(gridLayout.getMarkup()), false);
        writer.writeClassAttribute((CssItem)TobagoClass.GRID_LAYOUT, TobagoClass.GRID_LAYOUT.createMarkup(markup), new CssItem[]{markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        MeasureList columns = MeasureList.parse(gridLayout.getColumns());
        MeasureList rows = MeasureList.parse(gridLayout.getRows());
        AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
        style.setTransient(true);
        if (columns.stream().anyMatch(measure -> Measure.Unit.AUTO.equals((Object)measure.getUnit())) && columns.stream().noneMatch(measure -> Measure.Unit.FR.equals((Object)measure.getUnit()))) {
            columns.add(new Measure(1, Measure.Unit.FR));
        }
        style.setGridTemplateColumns(columns.serialize());
        style.setGridTemplateRows(rows.serialize());
        gridLayout.getChildren().add(style);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }
}

