/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.requestParameterProvider;

/**
 * The interface a provider has to implement to add parameters to the url.
 * <p>
 * Objects which need to append parameters to all urls in the page being generated
 * should create an implementation of this interface and register an object of that
 * type with the RequestParameterProviderManager. When the page is generated the
 * manager will call back to every registered RequestParameterProvider to get the
 * data it needs to append.  
 */
public interface RequestParameterProvider
{
    /**
     * Return the names of fields this instance wants to add to the url. Each value in the
     * returned array is then used as a parameter to the getFieldValue method.
     */
    public String[] getFields();

    /**
     * Return the value for the given field (which should be one of the values returned
     * by the getFields method).
     */
    public String getFieldValue(String field);
}
