/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.util.UUID;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class UUIDConverter
implements Converter<UUID> {
    public static final String CONVERTER_ID = "jakarta.faces.UUID";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    public static final String UUID_ID = "jakarta.faces.converter.UUIDConverter.UUID";

    @Override
    public UUID getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, UUID_ID, new Object[]{value, "29573f55-4254-4afa-9ca6-6b5ae6c7ab6e", MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }

    @Override
    public String getAsString(FacesContext facesContext, UIComponent uiComponent, UUID value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null) {
            return "";
        }
        try {
            return value.toString();
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }
}

