/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.putty;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.putty.AbstractPuttyKeyDecoder;
import org.apache.sshd.putty.PuttyKeyReader;

public class DSSPuttyKeyDecoder
extends AbstractPuttyKeyDecoder {
    public static final DSSPuttyKeyDecoder INSTANCE = new DSSPuttyKeyDecoder();

    public DSSPuttyKeyDecoder() {
        super(Collections.singletonList("ssh-dss"));
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(NamedResource resourceKey, int formatVersion, PuttyKeyReader pubReader, PuttyKeyReader prvReader, Map<String, String> headers) throws IOException, GeneralSecurityException {
        pubReader.skip();
        BigInteger p = pubReader.readInt();
        BigInteger q = pubReader.readInt();
        BigInteger g = pubReader.readInt();
        BigInteger y = pubReader.readInt();
        BigInteger x = prvReader.readInt();
        KeyFactory kf = SecurityUtils.getKeyFactory((String)"DSA");
        PublicKey pubKey = kf.generatePublic(new DSAPublicKeySpec(y, p, q, g));
        PrivateKey prvKey = kf.generatePrivate(new DSAPrivateKeySpec(x, p, q, g));
        return Collections.singletonList(new KeyPair(pubKey, prvKey));
    }
}

