/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.InvalidKeyException;
import java.util.Arrays;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Poly1305Mac
implements Mac {
    public static final int KEY_BYTES = 32;
    private static final int BLOCK_SIZE = 16;
    private long r0;
    private long r1;
    private long r2;
    private long r3;
    private long r4;
    private long s1;
    private long s2;
    private long s3;
    private long s4;
    private long k0;
    private long k1;
    private long k2;
    private long k3;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private final byte[] currentBlock = new byte[16];
    private final IntBuffer currentInts = ByteBuffer.wrap(this.currentBlock).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    private int currentBlockOffset;

    @Override
    public String getAlgorithm() {
        return "Poly1305";
    }

    @Override
    public void init(byte[] key) throws Exception {
        if (NumberUtils.length(key) != 32) {
            throw new InvalidKeyException("Poly1305 key must be 32 bytes");
        }
        int t0 = Poly1305Mac.unpackIntLE(key, 0);
        int t1 = Poly1305Mac.unpackIntLE(key, 4);
        int t2 = Poly1305Mac.unpackIntLE(key, 8);
        int t3 = Poly1305Mac.unpackIntLE(key, 12);
        this.r0 = t0 & 0x3FFFFFF;
        this.r1 = (t0 >>> 26 | t1 << 6) & 0x3FFFF03;
        this.r2 = (t1 >>> 20 | t2 << 12) & 0x3FFC0FF;
        this.r3 = (t2 >>> 14 | t3 << 18) & 0x3F03FFF;
        this.r4 = t3 >>> 8 & 0xFFFFF;
        this.s1 = this.r1 * 5L;
        this.s2 = this.r2 * 5L;
        this.s3 = this.r3 * 5L;
        this.s4 = this.r4 * 5L;
        this.k0 = (long)Poly1305Mac.unpackIntLE(key, 16) & 0xFFFFFFFFL;
        this.k1 = (long)Poly1305Mac.unpackIntLE(key, 20) & 0xFFFFFFFFL;
        this.k2 = (long)Poly1305Mac.unpackIntLE(key, 24) & 0xFFFFFFFFL;
        this.k3 = (long)Poly1305Mac.unpackIntLE(key, 28) & 0xFFFFFFFFL;
        this.currentBlockOffset = 0;
    }

    @Override
    public void update(byte[] in, int offset, int length) {
        if (this.currentBlockOffset > 0) {
            int toCopy = Math.min(length, 16 - this.currentBlockOffset);
            System.arraycopy(in, offset, this.currentBlock, this.currentBlockOffset, toCopy);
            offset += toCopy;
            length -= toCopy;
            this.currentBlockOffset += toCopy;
            if (this.currentBlockOffset == 16) {
                this.currentInts.clear();
                this.processBlock(this.currentInts, 16);
                this.currentBlockOffset = 0;
            }
            if (length == 0) {
                return;
            }
        }
        if (length >= 16) {
            int numBlocks;
            IntBuffer inB = ByteBuffer.wrap(in, offset, length & 0xFFFFFFF0).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            int bytesProcessed = numBlocks * 16;
            for (numBlocks = length / 16; numBlocks > 0; --numBlocks) {
                this.processBlock(inB, 16);
            }
            length -= bytesProcessed;
            offset += bytesProcessed;
        }
        if (length > 0) {
            System.arraycopy(in, offset, this.currentBlock, 0, length);
            this.currentBlockOffset = length;
        }
    }

    @Override
    public void updateUInt(long value) {
        byte[] encoded = new byte[4];
        BufferUtils.putUInt(value, encoded);
        this.update(encoded);
    }

    @Override
    public void doFinal(byte[] out, int offset) throws Exception {
        if (offset + 16 > NumberUtils.length(out)) {
            throw new BufferOverflowException();
        }
        if (this.currentBlockOffset > 0) {
            if (this.currentBlockOffset < 16) {
                this.currentBlock[this.currentBlockOffset] = 1;
                for (int i = this.currentBlockOffset + 1; i < 16; ++i) {
                    this.currentBlock[i] = 0;
                }
            }
            this.currentInts.clear();
            this.processBlock(this.currentInts, this.currentBlockOffset);
        }
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        this.h2 += this.h1 >>> 26;
        this.h1 &= 0x3FFFFFF;
        this.h3 += this.h2 >>> 26;
        this.h2 &= 0x3FFFFFF;
        this.h4 += this.h3 >>> 26;
        this.h3 &= 0x3FFFFFF;
        this.h0 += (this.h4 >>> 26) * 5;
        this.h4 &= 0x3FFFFFF;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        int g0 = this.h0 + 5;
        int b = g0 >>> 26;
        g0 &= 0x3FFFFFF;
        int g1 = this.h1 + b;
        b = g1 >>> 26;
        g1 &= 0x3FFFFFF;
        int g2 = this.h2 + b;
        b = g2 >>> 26;
        g2 &= 0x3FFFFFF;
        int g3 = this.h3 + b;
        b = g3 >>> 26;
        g3 &= 0x3FFFFFF;
        int g4 = this.h4 + b - 0x4000000;
        b = (g4 >>> 31) - 1;
        int nb = ~b;
        this.h0 = this.h0 & nb | g0 & b;
        this.h1 = this.h1 & nb | g1 & b;
        this.h2 = this.h2 & nb | g2 & b;
        this.h3 = this.h3 & nb | g3 & b;
        this.h4 = this.h4 & nb | g4 & b;
        long f0 = ((long)(this.h0 | this.h1 << 26) & 0xFFFFFFFFL) + this.k0;
        long f1 = ((long)(this.h1 >>> 6 | this.h2 << 20) & 0xFFFFFFFFL) + this.k1;
        long f2 = ((long)(this.h2 >>> 12 | this.h3 << 14) & 0xFFFFFFFFL) + this.k2;
        long f3 = ((long)(this.h3 >>> 18 | this.h4 << 8) & 0xFFFFFFFFL) + this.k3;
        Poly1305Mac.packIntLE((int)f0, out, offset);
        Poly1305Mac.packIntLE((int)(f1 += f0 >>> 32), out, offset + 4);
        Poly1305Mac.packIntLE((int)(f2 += f1 >>> 32), out, offset + 8);
        Poly1305Mac.packIntLE((int)(f3 += f2 >>> 32), out, offset + 12);
        this.reset();
    }

    private void processBlock(IntBuffer block, int length) {
        int t0 = block.get();
        int t1 = block.get();
        int t2 = block.get();
        int t3 = block.get();
        this.h0 += t0 & 0x3FFFFFF;
        this.h1 += (t0 >>> 26 | t1 << 6) & 0x3FFFFFF;
        this.h2 += (t1 >>> 20 | t2 << 12) & 0x3FFFFFF;
        this.h3 += (t2 >>> 14 | t3 << 18) & 0x3FFFFFF;
        this.h4 += t3 >>> 8;
        if (length == 16) {
            this.h4 += 0x1000000;
        }
        long l0 = this.h0;
        long l1 = this.h1;
        long l2 = this.h2;
        long l3 = this.h3;
        long l4 = this.h4;
        long tp0 = l0 * this.r0 + l1 * this.s4 + l2 * this.s3 + l3 * this.s2 + l4 * this.s1;
        long tp1 = l0 * this.r1 + l1 * this.r0 + l2 * this.s4 + l3 * this.s3 + l4 * this.s2;
        long tp2 = l0 * this.r2 + l1 * this.r1 + l2 * this.r0 + l3 * this.s4 + l4 * this.s3;
        long tp3 = l0 * this.r3 + l1 * this.r2 + l2 * this.r1 + l3 * this.r0 + l4 * this.s4;
        long tp4 = l0 * this.r4 + l1 * this.r3 + l2 * this.r2 + l3 * this.r1 + l4 * this.r0;
        this.h0 = (int)tp0 & 0x3FFFFFF;
        this.h1 = (int)(tp1 += tp0 >>> 26) & 0x3FFFFFF;
        this.h2 = (int)(tp2 += tp1 >>> 26) & 0x3FFFFFF;
        this.h3 = (int)(tp3 += tp2 >>> 26) & 0x3FFFFFF;
        this.h4 = (int)(tp4 += tp3 >>> 26) & 0x3FFFFFF;
        this.h0 += (int)(tp4 >>> 26) * 5;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
    }

    private void reset() {
        this.h0 = 0;
        this.h1 = 0;
        this.h2 = 0;
        this.h3 = 0;
        this.h4 = 0;
        this.currentBlockOffset = 0;
        Arrays.fill(this.currentBlock, (byte)0);
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int getDefaultBlockSize() {
        return 16;
    }

    public static int unpackIntLE(byte[] buf, int off) {
        int ret = buf[off++] & 0xFF;
        ret |= (buf[off++] & 0xFF) << 8;
        ret |= (buf[off++] & 0xFF) << 16;
        return ret |= (buf[off] & 0xFF) << 24;
    }

    public static void packIntLE(int value, byte[] dst, int off) {
        dst[off++] = (byte)value;
        dst[off++] = (byte)(value >> 8);
        dst[off++] = (byte)(value >> 16);
        dst[off] = (byte)(value >> 24);
    }
}

