package org.apache.maven.plugin.coreit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.codehaus.plexus.PlexusConstants;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class DefaultComponent
    implements Component, Contextualizable
{

    private PlexusCipher comp1;

    private SecDispatcher comp2;

    public void contextualize( Context context )
        throws ContextException
    {
        PlexusContainer plexus = (PlexusContainer) context.get( PlexusConstants.PLEXUS_KEY );

        // NOTE: Doing components lookup via string key, forcing container to load proper type

        try
        {
            comp1 = (PlexusCipher) plexus.lookup( PlexusCipher.class.getName() );
        }
        catch ( ComponentLookupException e )
        {
            throw new ContextException( e.getMessage(), e );
        }

        try
        {
            comp2 = (SecDispatcher) plexus.lookup( SecDispatcher.class.getName() );
        }
        catch ( ComponentLookupException e )
        {
            throw new ContextException( e.getMessage(), e );
        }
    }

    public String toString()
    {
        return comp1 + ", " + comp2;
    }

}
